/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsBrowserOptionsDialog;
import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsDestination;
import com.tibco.gems.GemsDestinationPicker;
import com.tibco.gems.GemsMessageFrame;
import com.tibco.gems.GemsReqReplyMessageTableModel;
import com.tibco.gems.GemsUtilities;
import com.tibco.gems.TableSorter;
import com.tibco.tibjms.TibjmsConnectionFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.Timer;
import javax.swing.text.DefaultEditorKit;

public class GemsReqReplyTester
extends JFrame {
    GemsReqReplyTester m_frame;
    JPanel m_panel;
    boolean m_running = false;
    int m_msgCount = 0;
    int m_msgSeq = 0;
    int m_maxMsgs = 10;
    Session m_session = null;
    Session m_replysession = null;
    GemsConnectionNode m_cn;
    Connection m_connection = null;
    MessageProducer m_producer = null;
    MessageConsumer m_consumer = null;
    Destination m_requestDestination = null;
    Destination m_replyDestination = null;
    String m_destination = null;
    Timer m_timer = null;
    Timer m_stoptimer = null;
    SyncThread m_thread = null;
    protected JTextField m_conn;
    protected JTextField m_reqDest;
    protected JTextField m_msgsSend;
    protected JTextField m_delay;
    protected JComboBox m_mode;
    protected JComboBox m_msgType;
    protected JButton m_destwiz;
    protected JButton m_msgwiz;
    protected JButton m_startButton;
    protected JButton m_stopButton;
    protected JCheckBox m_noDelay;
    protected GemsMessageFrame m_textMsgFrame;
    protected GemsMessageFrame m_mapMsgFrame;
    JTable m_table;
    protected GemsReqReplyMessageTableModel m_tableModel;
    protected boolean m_viewoldestFirst = Gems.getGems().getViewOldMessagesFirst();
    protected long m_RRTimeout = Gems.getGems().getRequestReplyTimeout() * 1000;
    protected JMenuItem m_optMenuItem;
    protected JMenuItem m_dumpMenuItem;
    TableSorter m_sorter;
    boolean m_isQueue = true;
    public Hashtable m_pending = new Hashtable();

    public GemsReqReplyTester(GemsConnectionNode cn, String reqDest, boolean isQueue, String title) {
        super(Gems.getGems().getTitlePrefix() + title);
        this.setLocation(400, 175);
        this.setDefaultCloseOperation(2);
        this.m_frame = this;
        this.m_cn = cn;
        this.m_isQueue = isQueue;
        this.m_destination = reqDest;
        String prefix = isQueue ? "Queue" : "Topic";
        this.m_mapMsgFrame = new GemsMessageFrame(this.m_cn, true, reqDest, this.m_isQueue, this.m_frame, false, true, true);
        this.m_textMsgFrame = new GemsMessageFrame(this.m_cn, true, reqDest, this.m_isQueue, this.m_frame, false, false, true);
        JMenuBar menuBar = this.constructMenuBar();
        this.setJMenuBar(menuBar);
        JPanel m_panel = new JPanel(true);
        m_panel.setLayout(new BorderLayout());
        this.getContentPane().add("Center", m_panel);
        JPanel panel = new JPanel(new SpringLayout(), true);
        m_panel.add((Component)panel, "North");
        JLabel l1 = new JLabel("Server:", 11);
        this.m_conn = new JTextField(cn.getName(), 20);
        this.m_conn.setEditable(false);
        this.m_conn.setMaximumSize(new Dimension(0, 24));
        l1.setLabelFor(this.m_conn);
        panel.add(l1);
        panel.add(this.m_conn);
        JPanel qpanel = new JPanel(true);
        qpanel.setLayout(new BoxLayout(qpanel, 0));
        JLabel l2 = new JLabel("Request " + prefix + " Name:", 11);
        this.m_reqDest = new JTextField(reqDest, 20);
        l2.setLabelFor(this.m_reqDest);
        panel.add(l2);
        qpanel.add(this.m_reqDest);
        this.m_destwiz = new JButton("...");
        this.m_destwiz.setPreferredSize(new Dimension(18, 16));
        this.m_destwiz.addActionListener(new DestinationWizardAction());
        qpanel.add(this.m_destwiz);
        panel.add(qpanel);
        JLabel l6 = new JLabel("Mode:", 11);
        this.m_mode = new JComboBox();
        for (MODE_TYPE dm : MODE_TYPE.values()) {
            this.m_mode.addItem(dm);
        }
        l6.setLabelFor(this.m_mode);
        panel.add(l6);
        panel.add(this.m_mode);
        JPanel tpanel = new JPanel(true);
        tpanel.setLayout(new BoxLayout(tpanel, 0));
        JLabel l5 = new JLabel("Request Message:", 11);
        this.m_msgType = new JComboBox();
        for (MSG_TYPE dm : MSG_TYPE.values()) {
            this.m_msgType.addItem(dm);
        }
        l5.setLabelFor(this.m_msgType);
        panel.add(l5);
        this.m_msgwiz = new JButton("...");
        this.m_msgwiz.setPreferredSize(new Dimension(18, 16));
        this.m_msgwiz.addActionListener(new MessageWizardAction());
        tpanel.add(this.m_msgType);
        tpanel.add(this.m_msgwiz);
        panel.add(tpanel);
        JLabel l9 = new JLabel("Requests to Send:", 11);
        this.m_msgsSend = new JTextField("10", 20);
        this.m_msgsSend.setMinimumSize(new Dimension(40, 24));
        l9.setLabelFor(this.m_msgsSend);
        panel.add(l9);
        panel.add(this.m_msgsSend);
        JPanel mpanel = new JPanel(true);
        mpanel.setLayout(new BoxLayout(mpanel, 0));
        JLabel l7 = new JLabel("Delay Between Sends(ms):", 11);
        this.m_delay = new JTextField("200", 20);
        this.m_delay.setMinimumSize(new Dimension(40, 24));
        mpanel.setPreferredSize(new Dimension(100, 24));
        l7.setLabelFor(this.m_delay);
        panel.add(l7);
        mpanel.add(this.m_delay);
        this.m_noDelay = new JCheckBox("None", false);
        mpanel.add(this.m_noDelay);
        panel.add(mpanel);
        this.m_tableModel = new GemsReqReplyMessageTableModel(false, false);
        this.m_sorter = new TableSorter(this.m_tableModel);
        this.m_table = new JTable(this.m_sorter);
        this.m_table.getTableHeader().setReorderingAllowed(false);
        this.m_sorter.setTableHeader(this.m_table.getTableHeader());
        this.m_table.setSelectionMode(0);
        this.m_tableModel.m_table = this.m_table;
        this.addMouseListenerToTable(this.m_table);
        JScrollPane spane = new JScrollPane(this.m_table);
        spane.setPreferredSize(new Dimension(480, 300));
        m_panel.add((Component)spane, "Center");
        JPanel bpanel = new JPanel(true);
        bpanel.setLayout(new BoxLayout(bpanel, 0));
        Component bx = Box.createRigidArea(new Dimension(280, 10));
        bpanel.add(bx);
        this.m_startButton = new JButton("Start");
        this.m_startButton.addActionListener(new StartPressed());
        this.m_stopButton = new JButton("Stop");
        this.m_stopButton.addActionListener(new StopPressed());
        this.m_stopButton.setEnabled(false);
        bpanel.add(this.m_startButton);
        bx = Box.createRigidArea(new Dimension(20, 10));
        bpanel.add(bx);
        bpanel.add(this.m_stopButton);
        m_panel.add((Component)bpanel, "South");
        GemsUtilities.makeCompactGrid(panel, 3, 4, 5, 5, 5, 5);
        this.m_frame.setIconImage(Gems.getGems().m_icon.getImage());
        this.pack();
        this.show();
    }

    public void start() {
        this.m_running = true;
        this.m_msgCount = 0;
        this.m_reqDest.setEnabled(false);
        this.m_msgsSend.setEnabled(false);
        this.m_startButton.setEnabled(false);
        this.m_stopButton.setEnabled(true);
        this.m_noDelay.setEnabled(false);
        this.m_delay.setEnabled(false);
        this.m_mode.setEnabled(false);
        this.m_msgType.setEnabled(false);
        this.m_destwiz.setEnabled(false);
        this.m_msgwiz.setEnabled(false);
        this.m_optMenuItem.setEnabled(false);
        this.m_dumpMenuItem.setEnabled(false);
        int delay = 0;
        try {
            this.m_maxMsgs = Integer.parseInt(this.m_msgsSend.getText());
            delay = Integer.parseInt(this.m_delay.getText());
        }
        catch (Exception ie) {
            this.m_maxMsgs = 10;
            delay = 200;
        }
        if (this.m_noDelay.isSelected()) {
            delay = 0;
        }
        this.m_tableModel.buildColumnHeaders();
        if (this.m_reqDest.getText() == null || this.m_reqDest.getText().length() == 0) {
            this.stop();
            return;
        }
        try {
            TibjmsConnectionFactory factory = new TibjmsConnectionFactory(this.m_cn.m_url, null, this.m_cn.m_sslParams);
            this.m_connection = factory.createConnection(this.m_cn.m_user, this.m_cn.m_password);
            this.m_session = this.m_connection.createSession(false, 22);
            if (this.m_isQueue) {
                this.m_requestDestination = this.m_session.createQueue(this.m_reqDest.getText());
                if (this.m_mode.getSelectedItem() == MODE_TYPE.Asynchronous) {
                    this.m_replyDestination = this.m_session.createTemporaryQueue();
                }
            } else {
                this.m_requestDestination = this.m_session.createTopic(this.m_reqDest.getText());
                if (this.m_mode.getSelectedItem() == MODE_TYPE.Asynchronous) {
                    this.m_replyDestination = this.m_session.createTemporaryTopic();
                }
            }
            if (this.m_mode.getSelectedItem() == MODE_TYPE.Asynchronous) {
                this.m_consumer = this.m_session.createConsumer(this.m_replyDestination);
                this.m_consumer.setMessageListener((MessageListener)new OnAsyncReplyMessage());
            }
            this.m_producer = this.m_session.createProducer(null);
            this.m_connection.start();
            if (this.m_mode.getSelectedItem() == MODE_TYPE.Asynchronous) {
                if (this.m_timer == null) {
                    this.m_timer = new Timer(delay, new RefreshTimerAction());
                } else {
                    this.m_timer.setDelay(delay);
                }
                this.m_timer.setInitialDelay(200);
                this.m_timer.start();
            } else {
                this.m_thread = new SyncThread(delay);
                this.m_thread.start();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.m_frame, e.getMessage(), "Error", 1);
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (!this.m_running) {
            return;
        }
        try {
            this.m_thread = null;
            if (this.m_timer != null) {
                this.m_timer.stop();
            }
            this.m_running = false;
            if (this.m_consumer != null) {
                this.m_consumer.close();
                this.m_consumer = null;
            }
            if (this.m_replyDestination != null) {
                if (this.m_isQueue) {
                    ((TemporaryQueue)this.m_replyDestination).delete();
                } else {
                    ((TemporaryTopic)this.m_replyDestination).delete();
                }
                this.m_replyDestination = null;
            }
            if (this.m_producer != null) {
                this.m_producer.close();
                this.m_producer = null;
            }
            if (this.m_session != null) {
                this.m_session.close();
                this.m_session = null;
            }
            if (this.m_connection != null) {
                this.m_connection.close();
                this.m_connection = null;
            }
            this.m_reqDest.setEnabled(true);
            this.m_msgsSend.setEnabled(true);
            this.m_startButton.setEnabled(true);
            this.m_stopButton.setEnabled(false);
            this.m_noDelay.setEnabled(true);
            this.m_delay.setEnabled(true);
            this.m_mode.setEnabled(true);
            this.m_destwiz.setEnabled(true);
            this.m_msgwiz.setEnabled(true);
            this.m_msgType.setEnabled(true);
            this.m_optMenuItem.setEnabled(true);
            this.m_dumpMenuItem.setEnabled(true);
            GemsReqReplyTester gemsReqReplyTester = this;
            synchronized (gemsReqReplyTester) {
                this.m_pending.clear();
            }
        }
        catch (Exception e) {
            System.err.println("Exception: " + e.getMessage());
        }
    }

    public void updateByTimer(Message m, Message r) {
        Timer timer = new Timer(0, new UpdateTimerAction(m, r));
        timer.setRepeats(false);
        timer.start();
    }

    public void stopByTimer() {
        if (this.m_stoptimer == null) {
            this.m_stoptimer = new Timer(0, new StopTimerAction());
        }
        this.m_stoptimer.setRepeats(false);
        this.m_stoptimer.start();
    }

    public void addMouseListenerToTable(JTable table) {
        MouseAdapter listMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    GemsReqReplyTester.this.showReplyMessageFrame();
                }
            }
        };
        table.addMouseListener(listMouseListener);
    }

    private JMenuBar constructMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menuBar.add(menu);
        this.m_dumpMenuItem = new JMenuItem("Save Messages To File...");
        this.m_dumpMenuItem.addActionListener(new DumpToFile());
        menu.add(this.m_dumpMenuItem);
        JMenuItem menuItem = menu.add(new JMenuItem("Exit"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemsReqReplyTester.this.dispose();
            }
        });
        menu = new JMenu("Edit");
        menu.setMnemonic(69);
        menuItem = new JMenuItem(new DefaultEditorKit.CutAction());
        menuItem.setText("Cut");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        menu.add(menuItem);
        menuItem = new JMenuItem(new DefaultEditorKit.CopyAction());
        menuItem.setText("Copy");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        menu.add(menuItem);
        menuItem = new JMenuItem(new DefaultEditorKit.PasteAction());
        menuItem.setText("Paste");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        menu.add(menuItem);
        menu.addSeparator();
        this.m_optMenuItem = menu.add(new JMenuItem("Options..."));
        this.m_optMenuItem.addActionListener(new EditOptionsAction());
        menuBar.add(menu);
        menu = new JMenu("View");
        menu.setMnemonic(86);
        menuBar.add(menu);
        menuItem = menu.add(new JMenuItem("View Selected Request Message..."));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemsReqReplyTester.this.showRequestMessageFrame();
            }
        });
        menuItem = menu.add(new JMenuItem("View Selected Reply Message..."));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemsReqReplyTester.this.showReplyMessageFrame();
            }
        });
        return menuBar;
    }

    public void showReplyMessageFrame() {
        Message m = this.m_tableModel.getSelectedReplyMessage();
        if (m != null) {
            GemsMessageFrame f = new GemsMessageFrame(this.m_cn, false, null, true, null, false);
            f.populate(m);
        } else {
            JOptionPane.showMessageDialog(this.m_frame, "There is no reply Message to view!", "View Reply Message", 1);
        }
    }

    public void showRequestMessageFrame() {
        Message m = this.m_tableModel.getSelectedMessage();
        if (m != null) {
            GemsMessageFrame f = new GemsMessageFrame(this.m_cn, false, null, true, null, false);
            f.populate(m);
        } else {
            JOptionPane.showMessageDialog(this.m_frame, "Select a Message to view!", "View Request Message", 1);
        }
    }

    @Override
    public void dispose() {
        this.stop();
        super.dispose();
    }

    class DumpToFile
    implements ActionListener {
        DumpToFile() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JFileChooser chooser = new JFileChooser(new File("."));
                chooser.setApproveButtonText("Save");
                chooser.setDialogTitle("Save Messages To File (appends)");
                int returnVal = chooser.showOpenDialog(GemsReqReplyTester.this.m_frame);
                if (returnVal == 0) {
                    File f = chooser.getSelectedFile();
                    GemsReqReplyTester.this.m_tableModel.dumpMsgsToFile(f, GemsReqReplyTester.this.m_viewoldestFirst);
                }
            }
            catch (IOException ie) {
                JOptionPane.showMessageDialog(GemsReqReplyTester.this.m_frame, ie.getMessage(), "Error", 1);
                return;
            }
        }
    }

    class OnAsyncReplyMessage
    implements MessageListener {
        OnAsyncReplyMessage() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(Message msg) {
            try {
                if (msg == null) {
                    return;
                }
                String cid = msg.getJMSCorrelationID();
                if (cid == null || cid.length() == 0) {
                    System.err.println("GemsReqReplyTester.onAsyncReplyMessage: JMSCorrelationID not returned by receiver, try using Synch mode");
                    return;
                }
                Message rm = null;
                OnAsyncReplyMessage onAsyncReplyMessage = this;
                synchronized (onAsyncReplyMessage) {
                    rm = (Message)GemsReqReplyTester.this.m_pending.remove(cid);
                }
                if (rm == null) {
                    System.err.println("GemsReqReplyTester.onAsyncReplyMessage: No pending message for CID: " + cid);
                    return;
                }
                GemsReqReplyTester.this.m_tableModel.updateRequestMessage(rm, msg);
            }
            catch (JMSException e) {
                Gems.debug("GemsReqReplyTester.onAsyncReplyMessage: Exception: " + e.toString());
            }
        }
    }

    class MessageWizardAction
    implements ActionListener {
        MessageWizardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GemsReqReplyTester.this.m_msgType.getSelectedItem() == MSG_TYPE.TextMessage) {
                if (GemsReqReplyTester.this.m_textMsgFrame == null) {
                    GemsReqReplyTester.this.m_textMsgFrame = new GemsMessageFrame(GemsReqReplyTester.this.m_cn, true, GemsReqReplyTester.this.m_destination, GemsReqReplyTester.this.m_isQueue, GemsReqReplyTester.this.m_frame, false, false, true);
                }
                GemsReqReplyTester.this.m_textMsgFrame.show();
            } else {
                if (GemsReqReplyTester.this.m_mapMsgFrame == null) {
                    GemsReqReplyTester.this.m_mapMsgFrame = new GemsMessageFrame(GemsReqReplyTester.this.m_cn, true, GemsReqReplyTester.this.m_destination, GemsReqReplyTester.this.m_isQueue, GemsReqReplyTester.this.m_frame, false, true, true);
                }
                GemsReqReplyTester.this.m_mapMsgFrame.show();
            }
        }
    }

    class DestinationWizardAction
    implements ActionListener {
        DestinationWizardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsDestinationPicker dp = new GemsDestinationPicker(GemsReqReplyTester.this.m_frame, GemsReqReplyTester.this.m_cn, GemsReqReplyTester.this.m_isQueue ? GemsDestination.DEST_TYPE.Queue : GemsDestination.DEST_TYPE.Topic);
            if (dp.m_retDest != null) {
                GemsReqReplyTester.this.m_destination = dp.m_retDest.m_destName;
                GemsReqReplyTester.this.m_reqDest.setText(GemsReqReplyTester.this.m_destination);
            }
        }
    }

    class EditOptionsAction
    implements ActionListener {
        EditOptionsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new GemsBrowserOptionsDialog(GemsReqReplyTester.this.m_frame, "Edit Options", false, true, false);
            GemsReqReplyTester.this.m_viewoldestFirst = Gems.getGems().getViewOldMessagesFirst();
            GemsReqReplyTester.this.m_RRTimeout = Gems.getGems().getRequestReplyTimeout() * 1000;
        }
    }

    class StopPressed
    implements ActionListener {
        StopPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsReqReplyTester.this.stop();
        }
    }

    class StartPressed
    implements ActionListener {
        StartPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsReqReplyTester.this.start();
        }
    }

    class RefreshTimerAction
    implements ActionListener {
        RefreshTimerAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (GemsReqReplyTester.this.m_running && GemsReqReplyTester.this.m_msgCount < GemsReqReplyTester.this.m_maxMsgs) {
                try {
                    Message msg = GemsReqReplyTester.this.m_msgType.getSelectedItem() == MSG_TYPE.TextMessage ? GemsReqReplyTester.this.m_textMsgFrame.createMessage(GemsReqReplyTester.this.m_session) : GemsReqReplyTester.this.m_mapMsgFrame.createMessage(GemsReqReplyTester.this.m_session);
                    msg.setJMSReplyTo(GemsReqReplyTester.this.m_replyDestination);
                    if (GemsReqReplyTester.this.m_mode.getSelectedItem() == MODE_TYPE.Synchronous) {
                        GemsReqReplyTester.this.m_replyDestination = GemsReqReplyTester.this.m_isQueue ? GemsReqReplyTester.this.m_session.createTemporaryQueue() : GemsReqReplyTester.this.m_session.createTemporaryTopic();
                        GemsReqReplyTester.this.m_consumer = GemsReqReplyTester.this.m_session.createConsumer(GemsReqReplyTester.this.m_replyDestination);
                    } else {
                        msg.setJMSCorrelationID(String.valueOf(++GemsReqReplyTester.this.m_msgSeq));
                    }
                    GemsReqReplyTester.this.m_producer.send(GemsReqReplyTester.this.m_requestDestination, msg, msg.getJMSDeliveryMode(), msg.getJMSPriority(), msg.getJMSExpiration());
                    ++GemsReqReplyTester.this.m_msgCount;
                    if (GemsReqReplyTester.this.m_mode.getSelectedItem() == MODE_TYPE.Asynchronous) {
                        RefreshTimerAction refreshTimerAction = this;
                        synchronized (refreshTimerAction) {
                            GemsReqReplyTester.this.m_pending.put(msg.getJMSCorrelationID(), msg);
                        }
                    }
                    GemsReqReplyTester.this.m_tableModel.addRequestMessage(msg, null, GemsReqReplyTester.this.m_viewoldestFirst);
                    if (GemsReqReplyTester.this.m_mode.getSelectedItem() == MODE_TYPE.Synchronous) {
                        Message reply = GemsReqReplyTester.this.m_consumer.receive(GemsReqReplyTester.this.m_RRTimeout);
                        if (reply != null) {
                            GemsReqReplyTester.this.m_tableModel.updateRequestMessage(msg, reply);
                        } else {
                            GemsReqReplyTester.this.m_tableModel.timeoutRequestMessage(msg);
                        }
                        GemsReqReplyTester.this.m_consumer.close();
                        if (GemsReqReplyTester.this.m_isQueue) {
                            ((TemporaryQueue)GemsReqReplyTester.this.m_replyDestination).delete();
                        } else {
                            ((TemporaryTopic)GemsReqReplyTester.this.m_replyDestination).delete();
                        }
                        GemsReqReplyTester.this.m_replyDestination = null;
                        GemsReqReplyTester.this.m_consumer = null;
                    }
                }
                catch (JMSException ex) {
                    System.err.println("Exception: " + ex.getMessage());
                    GemsReqReplyTester.this.m_frame.stop();
                }
            } else {
                GemsReqReplyTester.this.m_frame.stop();
            }
        }
    }

    class StopTimerAction
    implements ActionListener {
        StopTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsReqReplyTester.this.m_frame.stop();
        }
    }

    class UpdateTimerAction
    implements ActionListener {
        Message msg;
        Message rep;

        public UpdateTimerAction(Message m, Message r) {
            this.msg = m;
            this.rep = r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                GemsReqReplyTester gemsReqReplyTester = GemsReqReplyTester.this.m_frame;
                synchronized (gemsReqReplyTester) {
                    if (this.rep != null) {
                        GemsReqReplyTester.this.m_frame.m_tableModel.updateRequestMessage(this.msg, this.rep);
                    } else {
                        GemsReqReplyTester.this.m_frame.m_tableModel.timeoutRequestMessage(this.msg);
                    }
                }
            }
            catch (Exception ex) {
                System.err.println("Exception in updateTimerAction: " + ex.getMessage());
            }
        }
    }

    class SyncThread
    extends Thread {
        long m_delay;

        SyncThread(long delay) {
            this.m_delay = delay;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (GemsReqReplyTester.this.m_running && GemsReqReplyTester.this.m_msgCount < GemsReqReplyTester.this.m_maxMsgs) {
                try {
                    Message msg = GemsReqReplyTester.this.m_msgType.getSelectedItem() == MSG_TYPE.TextMessage ? GemsReqReplyTester.this.m_textMsgFrame.createMessage(GemsReqReplyTester.this.m_session) : GemsReqReplyTester.this.m_mapMsgFrame.createMessage(GemsReqReplyTester.this.m_session);
                    if (GemsReqReplyTester.this.m_mode.getSelectedItem() == MODE_TYPE.Synchronous) {
                        GemsReqReplyTester.this.m_replyDestination = GemsReqReplyTester.this.m_isQueue ? GemsReqReplyTester.this.m_session.createTemporaryQueue() : GemsReqReplyTester.this.m_session.createTemporaryTopic();
                        GemsReqReplyTester.this.m_consumer = GemsReqReplyTester.this.m_session.createConsumer(GemsReqReplyTester.this.m_replyDestination);
                    } else {
                        msg.setJMSCorrelationID(String.valueOf(++GemsReqReplyTester.this.m_msgSeq));
                    }
                    msg.setJMSReplyTo(GemsReqReplyTester.this.m_replyDestination);
                    GemsReqReplyTester.this.m_producer.send(GemsReqReplyTester.this.m_requestDestination, msg, msg.getJMSDeliveryMode(), msg.getJMSPriority(), msg.getJMSExpiration());
                    ++GemsReqReplyTester.this.m_msgCount;
                    if (GemsReqReplyTester.this.m_mode.getSelectedItem() == MODE_TYPE.Asynchronous) {
                        SyncThread syncThread = this;
                        synchronized (syncThread) {
                            GemsReqReplyTester.this.m_pending.put(msg.getJMSCorrelationID(), msg);
                        }
                    }
                    GemsReqReplyTester.this.m_tableModel.addRequestMessage(msg, null, GemsReqReplyTester.this.m_viewoldestFirst);
                    if (GemsReqReplyTester.this.m_mode.getSelectedItem() == MODE_TYPE.Synchronous) {
                        Message reply = GemsReqReplyTester.this.m_consumer.receive(GemsReqReplyTester.this.m_RRTimeout);
                        GemsReqReplyTester.this.updateByTimer(msg, reply);
                        if (GemsReqReplyTester.this.m_consumer != null) {
                            GemsReqReplyTester.this.m_consumer.close();
                            GemsReqReplyTester.this.m_consumer = null;
                        }
                        if (GemsReqReplyTester.this.m_replyDestination != null) {
                            if (GemsReqReplyTester.this.m_isQueue) {
                                ((TemporaryQueue)GemsReqReplyTester.this.m_replyDestination).delete();
                            } else {
                                ((TemporaryTopic)GemsReqReplyTester.this.m_replyDestination).delete();
                            }
                        }
                        GemsReqReplyTester.this.m_replyDestination = null;
                    }
                }
                catch (JMSException ex) {
                    System.err.println("Exception: " + ex.getMessage());
                    GemsReqReplyTester.this.m_frame.stop();
                    return;
                }
                try {
                    SyncThread.sleep(this.m_delay);
                }
                catch (Exception ie) {
                    System.err.println("Exception: " + ie.getMessage());
                }
            }
            GemsReqReplyTester.this.m_frame.stop();
        }
    }

    public static enum MSG_TYPE {
        TextMessage,
        MapMessage;

    }

    public static enum MODE_TYPE {
        Synchronous,
        Asynchronous;

    }
}

