/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsCellValue;
import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsDetailsTableModel;
import com.tibco.gems.GemsSSNode;
import com.tibco.gems.MsgCellValue;
import com.tibco.gems.PopupHandler;
import com.tibco.gems.PopupSSDetailsTableHandler;
import com.tibco.gems.SSCellFFValue;
import com.tibco.gems.SSCellValue;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JTable;

public class GemsSSDetailsTableModel
extends GemsDetailsTableModel {
    static String[] s_prop_cols = new String[]{"Property", "Value"};
    static String[] s_ssactive_cols = new String[]{"Identifier", "Date", "Time"};
    static String[] s_sssuspend_cols = new String[]{"Identifier", "Date", "Time"};
    static String[] s_ssactiveL_cols = new String[]{"Destination"};
    static String[] s_ssactiveL_cols27 = new String[]{"Recipe Name", "Destination"};
    static String[] s_ssinactive_cols = new String[]{"Identifier", "SSType", "Reason", "Disable Date", "Disable Time"};
    static String[] s_ssinterface_cols = new String[]{"Interface ID", "Type", "Date", "Time", "Busy", "Applid", "Status"};
    static String[] s_ssinterface_cols27 = new String[]{"Interface ID", "Type", "Date", "Time", "Busy", "ESB Endpoint", "Status"};
    static String[] s_ssdetails_cols = new String[]{"Details"};
    static String[] s_ssimsstats_cols = new String[]{"IMS Buffer", "Value"};
    static String[] s_ssimsbuffs_cols = new String[]{"IMS Property", "Value"};
    static String[] s_sssxth_cols = new String[]{"Details"};
    static String[] s_sscemt_cols = new String[]{"Details"};
    static String[] s_ssimsgen_cols = new String[]{"IMS Connection Property", "Con Value"};

    @Override
    public PopupHandler getPopupHandler() {
        if (this.m_popup == null) {
            this.m_popup = new PopupSSDetailsTableHandler(this.m_table, this);
        }
        return this.m_popup;
    }

    @Override
    public void setTable(JTable table) {
        this.m_table = table;
        if (Gems.getGems().getColourPendingMsgs()) {
            this.m_table.setDefaultRenderer(new Long(1L).getClass(), this.m_renderer);
            this.m_table.setDefaultRenderer(new Object().getClass(), this.m_renderer);
            this.m_table.setDefaultRenderer(new MsgCellValue(0L).getClass(), this.m_renderer);
            this.m_table.setDefaultRenderer(new GemsCellValue("").getClass(), this.m_renderer);
            this.m_table.setDefaultRenderer(new SSCellValue("", "Head").getClass(), this.m_renderer);
            this.m_table.setDefaultRenderer(new SSCellFFValue("").getClass(), this.m_renderer);
        }
    }

    @Override
    public Class getColumnClass(int c) {
        Object v = this.getValueAt(0, c);
        if (v != null) {
            if (v instanceof MsgCellValue) {
                return new Long(0L).getClass();
            }
            if (v instanceof SSCellValue) {
                return new String().getClass();
            }
            if (v instanceof GemsCellValue) {
                return new String().getClass();
            }
            return v.getClass();
        }
        return new String().getClass();
    }

    @Override
    public String getSelectedCol1() {
        if (this.m_table.getSelectedRow() < 0) {
            return null;
        }
        if (this.getColumnCount() == 1 && this.getColumnName(0).equals("Error")) {
            return null;
        }
        Object val = this.m_table.getValueAt(this.m_table.getSelectedRow(), 0);
        if (val instanceof Long) {
            return String.valueOf((Long)val);
        }
        if (val instanceof SSCellValue) {
            return ((SSCellValue)val).m_cellValue;
        }
        if (val instanceof SSCellFFValue) {
            return ((SSCellFFValue)val).m_cellValue;
        }
        return (String)val;
    }

    public void populateSSInfo(GemsConnectionNode cn, GemsSSNode ssn) {
        if (cn == null || ssn == null) {
            return;
        }
        this.setRowCount(0);
        if (this.getColumnCount() != 2 || !this.getColumnName(0).equals("Property")) {
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(2);
            this.setColumnIdentifiers(s_prop_cols);
        }
        MessageFormat mf1 = new MessageFormat("SXS0800I -  {0} - {1}");
        MessageFormat mf1a = new MessageFormat("SXS0800I -  UoW - {0} - {1}");
        MessageFormat mf2 = new MessageFormat("SXS0850I -  IId:{0} UoW Que statistics request");
        MessageFormat mf3 = new MessageFormat("SXS0851I -  {0} - {1}");
        MessageFormat mf4 = new MessageFormat("SXA1008I Substation ID:{0} {1}");
        String cmd = "SHOW";
        cmd = ssn.m_ver.equals("2.7") || ssn.m_ver.equals("2.8") || ssn.m_ver.equals("2.9") ? cmd + ",SYS" : cmd + ",ALL";
        String[] o = ssn.RunCommand(cmd).split("\n");
        for (int i = 0; i < o.length; ++i) {
            Object[] r;
            int pos;
            if (o[i].startsWith("SXS0800I") && (pos = o[i].indexOf("Statistics request")) == -1) {
                try {
                    Object[] testArgs = mf1.parse(o[i]);
                    if (testArgs[0].toString().startsWith("UoW Stress Status")) {
                        r = new Object[]{testArgs[0].toString(), new SSCellValue(Long.valueOf(testArgs[1].toString()), "Error", 1L, 100L)};
                    } else if (testArgs[0].toString().compareTo("UoW") == 0) {
                        testArgs = mf1a.parse(o[i]);
                        r = new String[]{"UoW " + testArgs[0].toString(), testArgs[1].toString()};
                    } else {
                        r = new String[]{testArgs[0].toString(), testArgs[1].toString()};
                    }
                    this.addRow(r);
                }
                catch (ParseException e) {
                    System.err.println("Message Format Error(): " + e.getMessage() + " " + o[i]);
                }
            }
            if (o[i].startsWith("SXS0850I")) {
                try {
                    Object[] testArgs = mf2.parse(o[i]);
                    r = new Object[]{new SSCellValue("Interface", "Head"), testArgs[0].toString().trim()};
                    this.addRow(r);
                }
                catch (ParseException e) {
                    System.err.println("Message Format Error(): " + e.getMessage() + " " + o[i]);
                }
            }
            if (o[i].startsWith("SXS0851I")) {
                try {
                    Object[] testArgs = mf3.parse(o[i]);
                    r = new String[]{testArgs[0].toString(), testArgs[1].toString()};
                    this.addRow(r);
                }
                catch (ParseException e) {
                    System.err.println("Message Format Error(): " + e.getMessage() + " " + o[i]);
                }
            }
            if (!o[i].startsWith("SXA1008I")) continue;
            try {
                Object[] testArgs = mf4.parse(o[i]);
                r = new Object[]{new SSCellValue("SubStation ID", "Head"), testArgs[0].toString()};
                this.addRow(r);
                r = new Object[]{new SSCellValue("Installed Version", "Head"), testArgs[1].toString()};
                this.addRow(r);
                continue;
            }
            catch (ParseException e) {
                System.err.println("Message Format Error(): " + e.getMessage() + " " + o[i]);
            }
        }
    }

    public void populateSSActive(GemsConnectionNode cn, GemsSSNode ssn, String Mode, String Interface) {
        if (cn == null || cn.m_adminConn == null) {
            return;
        }
        this.setRowCount(0);
        if (this.getColumnCount() != 3 || !this.getColumnName(0).equals("Identifier")) {
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(0);
            this.setColumnIdentifiers(s_ssactive_cols);
            this.setupColumnWidths();
        }
        MessageFormat mf1 = new MessageFormat("SXT5587I Since Date:{1} Time:{2} RID:{3}");
        MessageFormat mf1a = new MessageFormat("SXT5587I IId:{0} Since Date:{1} Time:{2} RID:{3}");
        MessageFormat mf2 = new MessageFormat("SXT5589I Since Date:{1} Time:{2} TID:{3}");
        MessageFormat mf2a = new MessageFormat("SXT5589I IId:{0} Since Date:{1} Time:{2} TID:{3}");
        String[] o = ssn.RunCommand("SHOW,ACT," + Mode + ",INTF=" + Interface).split("\n");
        for (int i = 1; i < o.length; ++i) {
            try {
                Object[] r;
                Object[] testArgs;
                if (o[i].startsWith("SXT5587I Since")) {
                    testArgs = mf1.parse(o[i]);
                    r = new String[]{testArgs[3].toString(), testArgs[1].toString(), testArgs[2].toString().substring(0, 8)};
                    this.addRow(r);
                }
                if (o[i].startsWith("SXT5587I IId")) {
                    testArgs = mf1a.parse(o[i]);
                    r = new String[]{testArgs[3].toString(), testArgs[1].toString(), testArgs[2].toString().substring(0, 8)};
                    this.addRow(r);
                }
                if (o[i].startsWith("SXT5589I Since")) {
                    testArgs = mf2.parse(o[i]);
                    r = new String[]{testArgs[3].toString(), testArgs[1].toString(), testArgs[2].toString().substring(0, 8)};
                    this.addRow(r);
                }
                if (!o[i].startsWith("SXT5589I IId")) continue;
                testArgs = mf2a.parse(o[i]);
                r = new String[]{testArgs[3].toString(), testArgs[1].toString(), testArgs[2].toString().substring(0, 8)};
                this.addRow(r);
                continue;
            }
            catch (ParseException e) {
                System.err.println("Message Format Error(): " + e.getMessage() + " " + o[i]);
            }
        }
    }

    public void populateSSSuspend(GemsConnectionNode cn, GemsSSNode ssn, String Interface) {
        if (cn == null || cn.m_adminConn == null) {
            return;
        }
        this.setRowCount(0);
        if (this.getColumnCount() != 3 || !this.getColumnName(0).equals("Identifier")) {
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(0);
            this.setColumnIdentifiers(s_sssuspend_cols);
            this.setupColumnWidths();
        }
        MessageFormat mf1 = new MessageFormat("SXT5594I SUSPENDED Date:{1} Time:{2} RID:{3} ");
        String[] o = ssn.RunCommand("SHOW,SUSPENDED").split("\n");
        if (o[1].startsWith("SXT5595I No Suspended recipes found")) {
            return;
        }
        for (int i = 1; i < o.length; ++i) {
            try {
                if (!o[i].startsWith("SXT5594I SUS")) continue;
                Object[] testArgs = mf1.parse(o[i]);
                Object[] r = new String[]{testArgs[3].toString(), testArgs[1].toString(), testArgs[2].toString().substring(0, 8)};
                this.addRow(r);
                continue;
            }
            catch (ParseException e) {
                System.err.println("Message Format Error(): " + e.getMessage() + " " + o[i]);
            }
        }
    }

    public void populateSSListeners(GemsConnectionNode cn, GemsSSNode ssn, String Interface) {
        if (cn == null || cn.m_adminConn == null) {
            return;
        }
        this.setRowCount(0);
        if (this.getColumnCount() != 1 || !this.getColumnName(0).equals("Destination")) {
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(0);
            if (ssn.m_ver.equals("2.7") || ssn.m_ver.equals("2.8") || ssn.m_ver.equals("2.9")) {
                this.setColumnIdentifiers(s_ssactiveL_cols27);
            } else {
                this.setColumnIdentifiers(s_ssactiveL_cols);
            }
            this.setupColumnWidths();
        }
        MessageFormat mf1 = new MessageFormat("SXT5585I Dest:{0}");
        MessageFormat mf1a = new MessageFormat("SXT5585I IId:{1} Dest:{0}");
        MessageFormat mf2 = new MessageFormat("SXT5585I      {0}");
        MessageFormat mf2a = new MessageFormat("SXT5585I IId:{1}      {0}");
        String[] o = ssn.RunCommand("SHOW,ACT,LISTENERS,INTF=" + Interface).split("\n");
        String Dest = "";
        for (int i = 1; i < o.length; ++i) {
            Object[] r;
            Object[] testArgs;
            if (o[i].contains("SXT5585I") && o[i].contains("Dest:")) {
                try {
                    testArgs = null;
                    testArgs = o[i].contains("IId") ? mf1a.parse(o[i]) : mf1.parse(o[i]);
                    if (ssn.m_ver.equals("2.7") || ssn.m_ver.equals("2.8") || ssn.m_ver.equals("2.9")) {
                        Dest = testArgs[0].toString();
                    } else {
                        r = new String[]{testArgs[0].toString()};
                        this.addRow(r);
                    }
                }
                catch (ParseException e) {
                    System.err.println("Message Format Error(): " + e.getMessage() + " " + o[i]);
                }
            }
            if (!o[i].contains("SXT5585I") || o[i].contains("Dest:")) continue;
            try {
                testArgs = null;
                testArgs = o[i].contains("IId") ? mf2a.parse(o[i]) : mf2.parse(o[i]);
                r = new String[]{testArgs[0].toString(), Dest};
                this.addRow(r);
                continue;
            }
            catch (ParseException e) {
                System.err.println("Message Format Error(): " + e.getMessage() + " " + o[i]);
            }
        }
    }

    public void populateSSInActive(GemsConnectionNode cn, GemsSSNode ssn, String Interface) {
        this.setRowCount(0);
        if (this.getColumnCount() != 5 || !this.getColumnName(0).equals("Identifier")) {
            if (cn == null || ssn == null) {
                return;
            }
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(0);
            this.setColumnIdentifiers(s_ssinactive_cols);
            this.setupColumnWidths();
        }
        MessageFormat mf1 = new MessageFormat("SXT5594I Disabled Date:{1} Time:{2} {3}:{4}, Rsn: {5}");
        MessageFormat mf1a = new MessageFormat("SXT5594I IId:{0} Disabled Date:{1} Time:{2} {3}:{4}, Rsn: {5}");
        MessageFormat mf1b = new MessageFormat("SXT5594I IId:{0} DISABLED Date:{1} Time:{2} {3}:{4} {5}");
        String[] o = ssn.RunCommand("SHOW,DISABLED,INTF=" + Interface).split("\n");
        String objType = "";
        String objDate = "";
        String objTime = "";
        for (int i = 1; i < o.length; ++i) {
            if (!o[i].startsWith("SXT5594I")) continue;
            try {
                Object[] testArgs = null;
                testArgs = o[i].contains("IId") ? (ssn.m_ver.equals("2.9") ? mf1b.parse(o[i]) : mf1a.parse(o[i])) : mf1.parse(o[i]);
                objType = testArgs[3].toString().startsWith("RID") ? "Recipe" : "Trigger";
                objDate = testArgs[1].toString().startsWith("<None>") ? "" : testArgs[1].toString();
                objTime = testArgs[2].toString().equals("") ? "" : testArgs[2].toString().substring(0, 8);
                Object[] r = new String[]{testArgs[4].toString(), objType, testArgs[5].toString(), objDate, objTime};
                this.addRow(r);
                continue;
            }
            catch (ParseException e) {
                System.err.println("Error(): " + e.getMessage() + " " + o[i]);
            }
        }
    }

    public void populateSSCounters(GemsConnectionNode cn, GemsSSNode ssn) {
        if (cn == null || ssn == null) {
            return;
        }
        this.setRowCount(0);
        if (this.getColumnCount() != 2 || !this.getColumnName(0).equals("Property")) {
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(2);
            this.setColumnIdentifiers(s_prop_cols);
        }
        MessageFormat mf1 = new MessageFormat("SXS0960I {3} IId:{0} Type:{1} Vers:{2}");
        MessageFormat mf2 = new MessageFormat("SXS0965I - {3}:{0} - Used:{1} Errors:{2}");
        MessageFormat mf3 = null;
        MessageFormat mf4 = new MessageFormat("SXT5840I {3}:{0} - Used:{1} Errors:{2}");
        MessageFormat mf4a = new MessageFormat("SXT5840I   {3}:{0}  Used:{1} Errors:{2} Active:{4}");
        MessageFormat mf4b = new MessageFormat("SXT5840I {5}:{6}   {3}:{0}  Used:{1} Errors:{2} Active:{4}");
        MessageFormat mf5 = new MessageFormat("SXS0962I No counter information recorded for IId:{0}");
        mf3 = !ssn.m_ver.equals("2.4") ? new MessageFormat("SXS0961I {0}:{1}") : new MessageFormat("SXS0961I - {0}:{1}");
        String[] o = ssn.RunCommand("SHOW,COUNTERS").split("\n");
        for (int i = 0; i < o.length; ++i) {
            Object[] r;
            Object[] testArgs;
            if (o[i].startsWith("SXS0960I")) {
                try {
                    testArgs = mf1.parse(o[i]);
                    r = new Object[]{new SSCellValue("Interface Name", "Head"), testArgs[0].toString().trim()};
                    this.addRow(r);
                    r = new String[]{"Interface Type", testArgs[1].toString()};
                    this.addRow(r);
                    r = new String[]{"Interface Version", testArgs[2].toString()};
                    this.addRow(r);
                }
                catch (ParseException e) {
                    System.err.println("Message Format Error(): " + e.getMessage() + " " + o[i]);
                }
            }
            if (o[i].startsWith("SXS0962I")) {
                try {
                    testArgs = mf5.parse(o[i]);
                    r = new Object[]{new SSCellValue("Interface Name", "Head"), testArgs[0].toString().trim()};
                    this.addRow(r);
                    r = new String[]{"State", "No counters collected yet"};
                    this.addRow(r);
                }
                catch (ParseException e) {
                    System.err.println("Message Format Error(): " + e.getMessage() + " " + o[i]);
                }
            }
            if (o[i].startsWith("SXS0965I")) {
                try {
                    testArgs = mf2.parse(o[i]);
                    r = testArgs[3].toString().equals("RID") ? new Object[]{new SSCellValue("Recipe Name", "Head"), testArgs[0].toString()} : new Object[]{new SSCellValue("Trigger Name", "Head"), testArgs[0].toString()};
                    this.addRow(r);
                    r = new Object[]{"Used", new SSCellValue(Long.valueOf(testArgs[1].toString()), "Large", Gems.getGems().getSSCountersWarnTH(), Gems.getGems().getSSCountersHighTH())};
                    this.addRow(r);
                    r = new Object[]{"Errors", new SSCellValue(Long.valueOf(testArgs[2].toString()), "Error", 1L, Gems.getGems().getSSCountersErrorTH())};
                    this.addRow(r);
                }
                catch (ParseException e) {
                    System.err.println("Message Format Error(): " + e.getMessage() + " " + o[i]);
                }
            }
            if (o[i].startsWith("SXT5840I")) {
                try {
                    testArgs = null;
                    if (o[i].contains("Used")) {
                        testArgs = mf4.parse(o[i]);
                    } else {
                        testArgs = o[i].contains("IId") ? mf4b.parse(o[i] + o[i + 1]) : mf4a.parse(o[i] + o[i + 1]);
                        ++i;
                    }
                    r = testArgs[3].toString().trim().equals("RID") ? new Object[]{new SSCellValue("Recipe Name", "Head"), testArgs[0].toString()} : new Object[]{new SSCellValue("Trigger Name", "Head"), testArgs[0].toString()};
                    this.addRow(r);
                    r = new Object[]{"Used", new SSCellValue(Long.valueOf(testArgs[1].toString()), "Large", Gems.getGems().getSSCountersWarnTH(), Gems.getGems().getSSCountersHighTH())};
                    this.addRow(r);
                    r = new Object[]{"Errors", new SSCellValue(Long.valueOf(testArgs[2].toString()), "Error", 1L, Gems.getGems().getSSCountersErrorTH())};
                    this.addRow(r);
                    if (testArgs.length == 5) {
                        r = new String[]{"Active", testArgs[4].toString()};
                        this.addRow(r);
                    }
                }
                catch (ParseException e) {
                    System.err.println("Message Format Error(): " + e.getMessage() + " " + o[i]);
                }
            }
            if (!o[i].startsWith("SXS0961I")) continue;
            try {
                testArgs = mf3.parse(o[i]);
                r = new String[]{testArgs[0].toString(), testArgs[1].toString()};
                this.addRow(r);
                continue;
            }
            catch (ParseException e) {
                System.err.println("Error: " + e.getMessage());
            }
        }
    }

    public void populateSSInterface(GemsConnectionNode cn, GemsSSNode ssn) {
        int i;
        if (cn == null || ssn == null) {
            return;
        }
        this.setRowCount(0);
        if (this.getColumnCount() != 6 || !this.getColumnName(0).equals("Interface ID")) {
            if (cn == null || ssn == null) {
                return;
            }
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(0);
            if (ssn.m_ver.equals("2.7") || ssn.m_ver.equals("2.8") || ssn.m_ver.equals("2.9")) {
                this.setColumnIdentifiers(s_ssinterface_cols27);
            } else {
                this.setColumnIdentifiers(s_ssinterface_cols);
            }
            this.setupColumnWidths();
        }
        MessageFormat mf1 = null;
        mf1 = ssn.m_ver.equals("2.4") || ssn.m_ver.equals("2.3") || ssn.m_ver.equals("2.2") || ssn.m_ver.equals("2.1") || ssn.m_ver.equals("2.0") ? new MessageFormat("SXS0951I - IId:{0} Type:{1} TCB:{2} Vers:{3} Start Date:{4}  Time:{5} All Workers Busy:{6} Times") : new MessageFormat("SXS0951I - IId:{0} Type:{1} TCB:{2} Vers:{3} All Workers Busy:{6} Times");
        MessageFormat mf1a = new MessageFormat("SXS0951I - IId:{0} Type:{1} TCB:{2} Vers:{3}   All Workers Busy    :{6} Times    All Workers EOT Busy:{7} Times  ");
        MessageFormat mf2 = new MessageFormat("SXS0990I - IId:{0} Type:{1} Applid:{2} Connection:{3}");
        MessageFormat mf3 = new MessageFormat("SXS0951I - IId:{0} Type:{1} TCB:{2} Vers:{3}   Start Date:{4}  Time:{5}    All Workers Busy:{6} Times");
        MessageFormat mf3a = new MessageFormat("SXS0951I - IId:{0} Type:{1} TCB:{2} Vers:{3}   Start Date:{4}  Time:{5}    All Workers Busy    :{6} Times   All Workers EOT Busy:{7} Times");
        MessageFormat mf4 = new MessageFormat("SXS0951I - IId:{0} Type:{1} TCB:{2} Vers:{3} All Workers Busy:{6} Times    Connection:{7} (UP/DOWN)");
        MessageFormat mf5 = new MessageFormat("  Endpoint State:{0}");
        MessageFormat mf6 = new MessageFormat("  Endpoint:{1} State:{0}");
        MessageFormat mf7 = new MessageFormat("  Connection:{0} State:{1} Endpoint:{2}");
        String[] o = ssn.RunCommand("SHOW,INTF").split("\n");
        Vector<String> o2 = new Vector<String>();
        int lPos = -1;
        for (i = 1; i < o.length; ++i) {
            String last;
            if (o[i].startsWith("SXA1008I") || o[i].startsWith("SXS0950I")) continue;
            if (o[i].startsWith("SXS0951I")) {
                ++lPos;
                o2.add(o[i]);
                continue;
            }
            if (o[i].startsWith("SXS0990I") || o[i].startsWith("  Endpoint")) {
                last = "";
                last = ssn.m_ver.equals("2.9") ? o2.get(lPos).toString() + o[i] : o2.get(lPos).toString() + "\n" + o[i];
                o2.setElementAt(last, lPos);
                continue;
            }
            if (o[i].startsWith("  Connection") && ssn.m_ver.equals("2.9")) {
                last = "";
                last = o2.get(lPos).toString() + "\n" + o[i];
                o2.setElementAt(last, lPos);
                continue;
            }
            last = o2.get(lPos).toString() + o[i];
            o2.setElementAt(last, lPos);
        }
        for (i = 0; i < o2.size(); ++i) {
            String data = o2.get(i).toString();
            if (!data.startsWith("SXS0951I")) continue;
            String[] w = data.split("\n");
            try {
                Object[] r;
                Object[] testArgs;
                if (w.length > 1) {
                    if (ssn.m_ver.equals("2.7") || ssn.m_ver.equals("2.8") || ssn.m_ver.equals("2.9")) {
                        Object[] testArgs2;
                        testArgs = null;
                        testArgs = w[0].contains("All Workers EOT") ? mf1a.parse(w[0]) : mf1.parse(w[0]);
                        String SSType = testArgs[1].toString();
                        if ((SSType = SSType.trim()).equals("CICS") || testArgs[1].equals("IMS")) {
                            testArgs2 = mf5.parse(w[1]);
                            r = new Object[]{testArgs[0].toString(), testArgs[1].toString(), "", "", new SSCellValue(Long.valueOf(testArgs[6].toString()), "Error", Gems.getGems().getSSBusyWarnTH(), Gems.getGems().getSSBusyErrorTH()), "", new SSCellValue(testArgs2[0].toString(), "Status", "DOWN")};
                        } else {
                            testArgs2 = null;
                            if (ssn.m_ver.equals("2.9")) {
                                testArgs2 = mf7.parse(w[1]);
                                r = new Object[]{testArgs[0].toString(), testArgs[1].toString(), "", "", new SSCellValue(Long.valueOf(testArgs[6].toString()), "Error", Gems.getGems().getSSBusyWarnTH(), Gems.getGems().getSSBusyErrorTH()), testArgs2[0].toString() + " " + testArgs2[2].toString(), new SSCellValue(testArgs2[1].toString(), "Status", "DOWN")};
                            } else {
                                testArgs2 = mf6.parse(w[1]);
                                r = new Object[]{testArgs[0].toString(), testArgs[1].toString(), "", "", new SSCellValue(Long.valueOf(testArgs[6].toString()), "Error", Gems.getGems().getSSBusyWarnTH(), Gems.getGems().getSSBusyErrorTH()), testArgs2[1].toString(), new SSCellValue(testArgs2[0].toString(), "Status", "DOWN")};
                            }
                            if (w.length > 2) {
                                int rowToProcess = 2;
                                do {
                                    this.addRow(r);
                                    if (ssn.m_ver.equals("2.9")) {
                                        testArgs2 = mf7.parse(w[rowToProcess]);
                                        r = new Object[]{"", "", "", "", "", testArgs2[0].toString() + " " + testArgs2[2].toString(), new SSCellValue(testArgs2[1].toString(), "Status", "DOWN")};
                                        continue;
                                    }
                                    testArgs2 = mf6.parse(w[rowToProcess]);
                                    r = new Object[]{"", "", "", "", "", testArgs2[1].toString(), new SSCellValue(testArgs2[0].toString(), "Status", "DOWN")};
                                } while (++rowToProcess < w.length);
                            }
                        }
                    } else {
                        testArgs = mf1.parse(w[0]);
                        Object[] testArgs2 = mf2.parse(w[1]);
                        r = new Object[]{testArgs[0].toString(), testArgs[1].toString(), testArgs[4].toString(), testArgs[5].toString(), new SSCellValue(Long.valueOf(testArgs[6].toString()), "Error", Gems.getGems().getSSBusyWarnTH(), Gems.getGems().getSSBusyErrorTH()), testArgs2[2].toString(), new SSCellValue(testArgs2[3].toString(), "Status", "DOWN")};
                    }
                } else {
                    testArgs = null;
                    if (data.contains("Type:Master")) {
                        testArgs = w[0].contains("All Workers EOT") ? mf3a.parse(w[0]) : mf3.parse(w[0]);
                        r = new Object[]{testArgs[0].toString(), testArgs[1].toString(), testArgs[4].toString(), testArgs[5].toString(), new SSCellValue(Long.valueOf(testArgs[6].toString()), "Error", 10L, 100L)};
                    } else if (data.contains("Connection:")) {
                        testArgs = mf4.parse(w[0]);
                        r = new Object[]{testArgs[0].toString(), testArgs[1].toString(), "", "", new SSCellValue(Long.valueOf(testArgs[6].toString()), "Error", Gems.getGems().getSSBusyWarnTH(), Gems.getGems().getSSBusyErrorTH()), "", new SSCellValue(testArgs[7].toString(), "Status", "DOWN")};
                    } else {
                        testArgs = mf1.parse(w[0]);
                        r = ssn.m_ver.equals("2.4") ? new Object[]{testArgs[0].toString(), testArgs[1].toString(), testArgs[4].toString(), testArgs[5].toString(), new SSCellValue(Long.valueOf(testArgs[6].toString()), "Error", Gems.getGems().getSSBusyWarnTH(), Gems.getGems().getSSBusyErrorTH())} : new Object[]{testArgs[0].toString(), testArgs[1].toString(), "", "", new SSCellValue(Long.valueOf(testArgs[6].toString()), "Error", Gems.getGems().getSSBusyWarnTH(), Gems.getGems().getSSBusyErrorTH())};
                    }
                }
                this.addRow(r);
                continue;
            }
            catch (ParseException e) {
                System.err.println("Message Format Error(): " + e.getMessage() + " " + data);
            }
        }
    }

    public void populateSSDetails(GemsConnectionNode cn, GemsSSNode ssn, String type, String ssname, String intf) {
        if (cn == null || ssn == null) {
            return;
        }
        this.setRowCount(0);
        if (this.getColumnCount() != 1 || !this.getColumnName(0).equals("Details")) {
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(0);
            this.setColumnIdentifiers(s_ssdetails_cols);
            this.setupColumnWidths();
        }
        MessageFormat mf1a = new MessageFormat("SXS0951I - IId:{0} Type:{1} TCB:{2} Vers:{3}   All Workers Busy    :{6} Times    All Workers EOT Busy:{7} Times  ");
        String[] o = null;
        o = type == "Recipe" ? ssn.RunCommand("SHOW,RID=" + ssname + ",INTF=" + intf).split("\n") : ssn.RunCommand("SHOW,TID=" + ssname + ",INTF=" + intf).split("\n");
        int lPos = -1;
        for (int i = 1; i < o.length; ++i) {
            Object[] r = new String[]{o[i].toString()};
            this.addRow(r);
        }
    }

    public void populateSSTransport(GemsConnectionNode cn, GemsSSNode ssn) {
        if (cn == null || ssn == null) {
            return;
        }
        this.setRowCount(0);
        if (this.getColumnCount() != 2 || !this.getColumnName(0).equals("Property")) {
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(2);
            this.setColumnIdentifiers(s_prop_cols);
        }
        MessageFormat mf1 = new MessageFormat("SXT5670I Transports active {1}, in-error {2}, unused {3}, disabled {4}");
        MessageFormat mf1a = new MessageFormat("SXT5670I IId:{5} Transports active {1}, in-error {2}, unused {3}, disabled {4}");
        MessageFormat mf2 = new MessageFormat("SXT5669I Transport {1} used {2}, state={3}, process-err={4}");
        MessageFormat mf2a = new MessageFormat("SXT5669I Endpoint {1} used {2}, state={3}, process-err={4}");
        MessageFormat mf2b = new MessageFormat("SXT5669I Endpoint {1} state:{3}");
        MessageFormat mf2c = new MessageFormat("SXT5669I IId:{0} Endpoint {1} state:{3}");
        MessageFormat mf3 = new MessageFormat("SXT5669I IId:{5} Transport {1} used {2}, state={3}, process-err={4}");
        MessageFormat mf4 = new MessageFormat("SXT5670I Endpoints UP {0}, RETRY {1}, UNUSED {2}, DOWN {3}");
        MessageFormat mf4a = new MessageFormat("SXT5670I IId:{4} Endpoints UP {0}, RETRY {1}, UNUSED {2}, DOWN {3}");
        MessageFormat mf5 = new MessageFormat("Services:{0}, AC:{1}, AR:{2}");
        MessageFormat mf6 = new MessageFormat("AC:{1}, AR:{2}");
        String[] o = ssn.RunCommand("SHOW,TPORT").split("\n");
        for (int i = 0; i < o.length; ++i) {
            Object[] r;
            Object[] testArgs;
            if (o[i].startsWith("SXT5670I IId:")) {
                try {
                    if (o[i].contains("Transports active")) {
                        testArgs = mf1a.parse(o[i]);
                        r = new Object[]{new SSCellValue("Summary", "Head"), "Interface: " + testArgs[5].toString()};
                        this.addRow(r);
                        r = new String[]{"Active", testArgs[1].toString()};
                        this.addRow(r);
                        r = new String[]{"Unused", testArgs[3].toString()};
                        this.addRow(r);
                        r = new Object[]{"Disabled", new SSCellValue(Long.valueOf(testArgs[4].toString()), "Error", 1L, 10L)};
                        this.addRow(r);
                        r = new Object[]{"In Error", new SSCellValue(Long.valueOf(testArgs[2].toString()), "Error", 1L, 10L)};
                        this.addRow(r);
                    }
                    if (o[i].contains("Endpoints")) {
                        testArgs = mf4a.parse(o[i]);
                        r = new Object[]{new SSCellValue("Summary", "Head"), testArgs[4].toString()};
                        this.addRow(r);
                        r = new String[]{"Up", testArgs[0].toString()};
                        this.addRow(r);
                        r = new String[]{"Unused", testArgs[2].toString()};
                        this.addRow(r);
                        r = new Object[]{"Retry", new SSCellValue(Long.valueOf(testArgs[1].toString()), "Error", 1L, 10L)};
                        this.addRow(r);
                        r = new Object[]{"Down", new SSCellValue(Long.valueOf(testArgs[3].toString()), "Error", 1L, 10L)};
                        this.addRow(r);
                    }
                }
                catch (ParseException e) {
                    System.err.println("Message Format Error(): " + e.getMessage() + " " + o[i]);
                }
            }
            if (o[i].startsWith("SXT5670I End")) {
                try {
                    testArgs = mf4.parse(o[i]);
                    r = new Object[]{new SSCellValue("Summary", "Head"), ""};
                    this.addRow(r);
                    r = new String[]{"Up", testArgs[0].toString()};
                    this.addRow(r);
                    r = new String[]{"Unused", testArgs[2].toString()};
                    this.addRow(r);
                    r = new Object[]{"Retry", new SSCellValue(Long.valueOf(testArgs[1].toString()), "Error", 1L, 10L)};
                    this.addRow(r);
                    r = new Object[]{"Down", new SSCellValue(Long.valueOf(testArgs[3].toString()), "Error", 1L, 10L)};
                    this.addRow(r);
                }
                catch (ParseException e) {
                    System.err.println("Message Format Error(): " + e.getMessage() + " " + o[i]);
                }
            }
            if (o[i].startsWith("SXT5670I Trans")) {
                try {
                    testArgs = mf1.parse(o[i]);
                    r = new Object[]{new SSCellValue("Summary", "Head"), ""};
                    this.addRow(r);
                    r = new String[]{"Active", testArgs[1].toString()};
                    this.addRow(r);
                    r = new String[]{"Unused", testArgs[3].toString()};
                    this.addRow(r);
                    r = new Object[]{"Disabled", new SSCellValue(Long.valueOf(testArgs[4].toString()), "Error", 1L, 10L)};
                    this.addRow(r);
                    r = new Object[]{"In Error", new SSCellValue(Long.valueOf(testArgs[2].toString()), "Error", 1L, 10L)};
                    this.addRow(r);
                }
                catch (ParseException e) {
                    System.err.println("Message Format Error(): " + e.getMessage() + " " + o[i]);
                }
            }
            if (o[i].startsWith("SXT5669I IId:")) {
                try {
                    testArgs = null;
                    if (o[i].contains(" Endpoint ")) {
                        testArgs = mf2c.parse(o[i]);
                        r = new Object[]{new SSCellValue("Transport", "Head"), testArgs[0].toString().trim()};
                        this.addRow(r);
                        r = new String[]{"Server", testArgs[1].toString()};
                        this.addRow(r);
                        r = new String[]{"State", testArgs[3].toString()};
                        this.addRow(r);
                        if (o[i + 1].contains("Services")) {
                            testArgs = mf5.parse(o[i + 1]);
                            r = new String[]{"Services", testArgs[0].toString()};
                            this.addRow(r);
                        } else {
                            testArgs = mf6.parse(o[i + 1]);
                        }
                        r = new String[]{"Connection Attempts", testArgs[1].toString()};
                        this.addRow(r);
                        r = new String[]{"Reconnection Attempts", testArgs[2].toString()};
                        this.addRow(r);
                        ++i;
                    } else {
                        testArgs = mf3.parse(o[i]);
                        r = new Object[]{new SSCellValue("Transport", "Head"), testArgs[1].toString().trim()};
                        this.addRow(r);
                        r = new String[]{"Used", testArgs[2].toString()};
                        this.addRow(r);
                        r = new String[]{"State", testArgs[3].toString()};
                        this.addRow(r);
                        r = new Object[]{"Error", testArgs[4].toString()};
                        this.addRow(r);
                    }
                }
                catch (ParseException e) {
                    System.err.println("Message Format Error(): " + e.getMessage() + " " + o[i]);
                }
            }
            if (o[i].startsWith("SXT5669I Tran")) {
                try {
                    testArgs = mf2.parse(o[i]);
                    r = new Object[]{new SSCellValue("Transport", "Head"), testArgs[1].toString().trim()};
                    this.addRow(r);
                    r = new String[]{"Used", testArgs[2].toString()};
                    this.addRow(r);
                    r = new String[]{"State", testArgs[3].toString()};
                    this.addRow(r);
                    r = new Object[]{"Error", testArgs[4].toString()};
                    this.addRow(r);
                }
                catch (ParseException e) {
                    System.err.println("Message Format Error(): " + e.getMessage() + " " + o[i]);
                }
            }
            if (!o[i].startsWith("SXT5669I Endpoint")) continue;
            try {
                testArgs = null;
                if (o[i].contains("process-err")) {
                    testArgs = mf2a.parse(o[i]);
                    r = new Object[]{new SSCellValue("Transport", "Head"), testArgs[1].toString().trim()};
                    this.addRow(r);
                    r = new String[]{"Used", testArgs[2].toString()};
                    this.addRow(r);
                    r = new String[]{"State", testArgs[3].toString()};
                    this.addRow(r);
                    r = new Object[]{"Error", testArgs[4].toString()};
                    this.addRow(r);
                    continue;
                }
                testArgs = mf2b.parse(o[i]);
                r = new Object[]{new SSCellValue("Transport", "Head"), testArgs[1].toString().trim()};
                this.addRow(r);
                r = new String[]{"State", testArgs[3].toString()};
                this.addRow(r);
                if (o[i + 1].contains("Services")) {
                    testArgs = mf5.parse(o[i + 1]);
                    r = new String[]{"Services", testArgs[0].toString()};
                    this.addRow(r);
                } else {
                    testArgs = mf6.parse(o[i + 1]);
                }
                r = new String[]{"Connection Attempts", testArgs[1].toString()};
                this.addRow(r);
                r = new String[]{"Reconnection Attempts", testArgs[2].toString()};
                this.addRow(r);
                ++i;
                continue;
            }
            catch (ParseException e) {
                System.err.println("Message Format Error(): " + e.getMessage() + " " + o[i]);
            }
        }
    }

    public void populateSSIMSStats(GemsConnectionNode cn, GemsSSNode ssn, String intf) {
        if (cn == null || ssn == null) {
            return;
        }
        this.setRowCount(0);
        if (this.getColumnCount() != 6 || !this.getColumnName(0).equals("Interface ID")) {
            if (cn == null || ssn == null) {
                return;
            }
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(0);
            this.setColumnIdentifiers(s_ssimsstats_cols);
            this.setupColumnWidths();
        }
        MessageFormat mf1 = new MessageFormat("SXI4967I Count {0} - {1}");
        MessageFormat mf0 = new MessageFormat("SXG2077I Operational Request Feedback for IId:{0}");
        String[] o = ssn.RunCommand("SHOW,IMS,STATS").split("\n");
        for (int i = 0; i < o.length; ++i) {
            Object[] r;
            Object[] testArgs;
            if (o[i].startsWith("SXG2077I")) {
                try {
                    testArgs = mf0.parse(o[i]);
                    r = new Object[]{new SSCellValue("Interface Name", "Head"), testArgs[0].toString().trim()};
                    this.addRow(r);
                }
                catch (ParseException e) {
                    System.err.println("Message Format Error(): " + e.getMessage() + " " + o[i]);
                }
            }
            if (!o[i].startsWith("SXI4967I")) continue;
            try {
                testArgs = mf1.parse(o[i]);
                r = new String[]{testArgs[1].toString(), testArgs[0].toString().trim()};
                this.addRow(r);
                continue;
            }
            catch (ParseException e) {
                System.err.println("Message Format Error(): " + e.getMessage() + " " + o[i]);
            }
        }
    }

    public void populateSSIMSBuffers(GemsConnectionNode cn, GemsSSNode ssn, String intf) {
        if (cn == null || ssn == null) {
            return;
        }
        this.setRowCount(0);
        if (this.getColumnCount() != 6 || !this.getColumnName(0).equals("Interface ID")) {
            if (cn == null || ssn == null) {
                return;
            }
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(0);
            this.setColumnIdentifiers(s_ssimsbuffs_cols);
            this.setupColumnWidths();
        }
        MessageFormat mf1 = new MessageFormat("SXI4969I Have {0} active buffers - {1} SRB, {2} GRP {3} TRN");
        MessageFormat mf0 = new MessageFormat("SXG2077I Operational Request Feedback for IId:{0}");
        String[] o = ssn.RunCommand("SHOW,IMS,BUFFERS").split("\n");
        for (int i = 0; i < o.length; ++i) {
            Object[] r;
            Object[] testArgs;
            if (o[i].startsWith("SXG2077I")) {
                try {
                    testArgs = mf0.parse(o[i]);
                    r = new Object[]{new SSCellValue("Interface Name", "Head"), testArgs[0].toString().trim()};
                    this.addRow(r);
                }
                catch (ParseException e) {
                    System.err.println("Message Format Error(): " + e.getMessage() + " " + o[i]);
                }
            }
            if (!o[i].startsWith("SXI4969I")) continue;
            try {
                testArgs = mf1.parse(o[i]);
                r = new String[]{"Total Active", testArgs[0].toString().trim()};
                this.addRow(r);
                r = new String[]{"SRB", testArgs[1].toString().trim()};
                this.addRow(r);
                r = new String[]{"GRP", testArgs[2].toString().trim()};
                this.addRow(r);
                r = new String[]{"TRN", testArgs[3].toString().trim()};
                this.addRow(r);
                continue;
            }
            catch (ParseException e) {
                System.err.println("Message Format Error(): " + e.getMessage() + " " + o[i]);
            }
        }
    }

    public void populateSSSXTH(GemsConnectionNode cn, GemsSSNode ssn, String intf) {
        if (cn == null || ssn == null) {
            return;
        }
        this.setRowCount(0);
        if (this.getColumnCount() != 1 || !this.getColumnName(0).equals("Details")) {
            if (cn == null || ssn == null) {
                return;
            }
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(0);
            this.setColumnIdentifiers(s_sssxth_cols);
            this.setupColumnWidths();
        }
        String[] o = ssn.RunCommand("SHOW,CICS,\"SXTH\",INTF=" + intf).split("\n");
        for (int i = 0; i < o.length; ++i) {
            if (o[i].startsWith("SXA1008I") || o[i].startsWith("SXG2077I")) continue;
            Object[] r = new Object[]{new SSCellFFValue(o[i].toString())};
            this.addRow(r);
        }
    }

    public void populateSSCEMT(GemsConnectionNode cn, GemsSSNode ssn, String intf) {
        if (cn == null || ssn == null) {
            return;
        }
        this.setRowCount(0);
        if (this.getColumnCount() != 6 || !this.getColumnName(0).equals("Details")) {
            if (cn == null || ssn == null) {
                return;
            }
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(0);
            this.setColumnIdentifiers(s_sscemt_cols);
            this.setupColumnWidths();
        }
        String[] o = ssn.RunCommand("SHOW,CICS,\"CEMT I TAS\",INTF=" + intf).split("\n");
        String p = ssn.RunCommand("SHOW,CICS,\"CEMT I TAS\"");
        o[2] = " " + o[2].toString();
        for (int i = 2; i < o.length; ++i) {
            Object[] r = new Object[]{new SSCellFFValue(o[i].toString())};
            this.addRow(r);
        }
    }

    public void populateSSIMSGen(GemsConnectionNode cn, GemsSSNode ssn) {
        Object[] r;
        Object[] testArgs;
        int i;
        if (cn == null || ssn == null) {
            return;
        }
        this.setRowCount(0);
        if (this.getColumnCount() != 6 || !this.getColumnName(0).equals("Interface ID")) {
            if (cn == null || ssn == null) {
                return;
            }
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(0);
            this.setColumnIdentifiers(s_ssimsgen_cols);
            this.setupColumnWidths();
        }
        MessageFormat mf0 = new MessageFormat("SXG2077I Operational Request Feedback for IId:{0}");
        MessageFormat mf1 = new MessageFormat("SXI4965I Group:{0}, SS:{1}  , IMS:{2}");
        MessageFormat mf1a = new MessageFormat("SXI4965I Group:{0}, SS:{1}, IMS:{2}");
        MessageFormat mf2 = new MessageFormat("SXI4964I Connecton status: {0}");
        MessageFormat mf2a = new MessageFormat("SXI4964I Endpoint State:{0}");
        String[] o = ssn.RunCommand("SHOW,IMS,CONNAME").split("\n");
        String[] o2 = ssn.RunCommand("SHOW,IMS,CONNECT").split("\n");
        for (i = 0; i < o.length; ++i) {
            if (o[i].startsWith("SXG2077I")) {
                try {
                    testArgs = mf0.parse(o[i]);
                    r = new Object[]{new SSCellValue("Interface Name", "Head"), testArgs[0].toString().trim()};
                    this.addRow(r);
                }
                catch (ParseException e) {
                    System.err.println("Message Format Error(): " + e.getMessage() + " " + o[i]);
                }
            }
            if (!o[i].startsWith("SXI4965I")) continue;
            try {
                testArgs = ssn.m_ver.equals("2.7") || ssn.m_ver.equals("2.8") || ssn.m_ver.equals("2.9") ? mf1a.parse(o[i]) : mf1.parse(o[i]);
                r = new String[]{"Group Name", testArgs[0].toString().trim()};
                this.addRow(r);
                r = new String[]{"Member Name", testArgs[1].toString().trim()};
                this.addRow(r);
                r = new String[]{"IMS Name", testArgs[2].toString().trim()};
                this.addRow(r);
                continue;
            }
            catch (ParseException e) {
                System.err.println("Message Format Error(): " + e.getMessage() + " " + o[i]);
            }
        }
        for (i = 0; i < o2.length; ++i) {
            if (o[i].startsWith("SXG2077I")) {
                try {
                    testArgs = mf0.parse(o2[i]);
                    r = new Object[]{new SSCellValue("Interface Name", "Head"), testArgs[0].toString().trim()};
                    this.addRow(r);
                }
                catch (ParseException e) {
                    System.err.println("Message Format Error(): " + e.getMessage() + " " + o[i]);
                }
            }
            if (!o2[i].startsWith("SXI4964I")) continue;
            try {
                if (ssn.m_ver.equals("2.7") || ssn.m_ver.equals("2.8") || ssn.m_ver.equals("2.9")) {
                    testArgs = mf2a.parse(o2[i]);
                    r = new String[]{"Endpoint Status", testArgs[0].toString().trim()};
                } else {
                    testArgs = mf2.parse(o2[i]);
                    r = new String[]{"Connection Status", testArgs[0].toString().trim()};
                }
                this.addRow(r);
                continue;
            }
            catch (ParseException e) {
                System.err.println("Message Format Error(): " + e.getMessage() + " " + o[i]);
            }
        }
    }

    @Override
    public void initColumnWidths() {
        if (this.m_colWidths == null) {
            this.m_colWidths = new Hashtable();
        }
        this.m_colWidths.put(new String("Identifier"), new Integer(280));
        this.m_colWidths.put(new String("Date"), new Integer(100));
        this.m_colWidths.put(new String("Time"), new Integer(110));
        this.m_colWidths.put(new String("Reason"), new Integer(110));
        this.m_colWidths.put(new String("SSType"), new Integer(80));
        this.m_colWidths.put(new String("Disable Date"), new Integer(100));
        this.m_colWidths.put(new String("Disable Time"), new Integer(100));
        this.m_colWidths.put(new String("Interface ID"), new Integer(80));
        this.m_colWidths.put(new String("Type"), new Integer(80));
        this.m_colWidths.put(new String("Busy"), new Integer(80));
        this.m_colWidths.put(new String("Applid"), new Integer(100));
        this.m_colWidths.put(new String("ESB Endpoint"), new Integer(160));
        this.m_colWidths.put(new String("Status"), new Integer(200));
        this.m_colWidths.put(new String("Destination"), new Integer(400));
        this.m_colWidths.put(new String("Recipe Name"), new Integer(400));
        this.m_colWidths.put(new String("Details"), new Integer(900));
        this.m_colWidths.put(new String("IMS Property"), new Integer(200));
        this.m_colWidths.put(new String("IMS Buffer"), new Integer(200));
        this.m_colWidths.put(new String("IMS Connection Property"), new Integer(300));
        this.m_colWidths.put(new String("Con Value"), new Integer(300));
        super.initColumnWidths();
    }
}

