/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsIconNode;
import com.tibco.tibjms.TibjmsQueueConnectionFactory;
import java.util.Hashtable;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;

public class GemsSSNode
extends GemsIconNode {
    static Hashtable props = null;
    public String m_name = null;
    public String m_queueName = null;
    public String m_ver = null;
    QueueConnection m_connection = null;
    public QueueSession m_session = null;
    Queue m_queue = null;
    Queue m_replyQueue = null;
    QueueSender m_sender = null;
    QueueReceiver m_receiver = null;
    int m_seqno = 0;
    long TIMEOUT = Gems.getGems().getSSTimeout();
    GemsConnectionNode m_cn = null;

    public synchronized void init(GemsConnectionNode cn) {
        try {
            TibjmsQueueConnectionFactory factory = new TibjmsQueueConnectionFactory(cn.m_url, null, cn.m_sslParams);
            this.m_connection = factory.createQueueConnection(cn.m_user, cn.m_password);
            this.m_session = this.m_connection.createQueueSession(false, 22);
            this.m_queue = this.m_session.createQueue(this.m_queueName);
            this.m_sender = this.m_session.createSender(this.m_queue);
            this.m_sender.setDeliveryMode(22);
            this.m_replyQueue = this.m_session.createTemporaryQueue();
            this.m_receiver = this.m_session.createReceiver(this.m_replyQueue);
            this.m_connection.start();
        }
        catch (JMSException e) {
            System.err.println("JMSException: " + e.getMessage());
            this.m_receiver = null;
            this.m_sender = null;
            this.m_session = null;
            this.m_connection = null;
            return;
        }
    }

    public synchronized void destroy(boolean force) {
        try {
            if (force) {
                if (this.m_receiver != null) {
                    this.m_receiver.close();
                }
                if (this.m_sender != null) {
                    this.m_sender.close();
                }
                if (this.m_session != null) {
                    this.m_session.close();
                }
                if (this.m_connection != null) {
                    this.m_connection.close();
                }
            }
            this.m_receiver = null;
            this.m_sender = null;
            this.m_session = null;
            this.m_connection = null;
        }
        catch (JMSException e) {
            this.m_receiver = null;
            this.m_sender = null;
            this.m_session = null;
            this.m_connection = null;
            return;
        }
    }

    public GemsSSNode(String name, String queue, String version2, GemsConnectionNode cn) {
        super(name, true);
        this.m_name = name;
        this.m_queueName = queue;
        this.m_cn = cn;
        this.m_ver = version2;
        if (Gems.getGems().m_useMetalIcons) {
            this.setIconName("substation");
        }
    }

    public synchronized String RunCommand(String Cmd) {
        if (this.m_connection == null) {
            this.init(this.m_cn);
        }
        if (this.m_connection == null) {
            return "Error: EMS server connection error";
        }
        try {
            MapMessage message = this.m_session.createMapMessage();
            String text = Cmd;
            message.setString("SXS-COMMAND", text);
            message.setJMSReplyTo((Destination)this.m_replyQueue);
            int j = ++this.m_seqno;
            message.setJMSCorrelationID(String.valueOf(j));
            this.m_sender.send((Message)message, 22, 4, 4L * this.TIMEOUT);
            MapMessage resp_Message = this.receiveReply(j);
            if (resp_Message != null) {
                Gems.debug("SubStation returned: " + resp_Message.getString("SXS-RESULT"));
                return resp_Message.getString("SXS-RESULT");
            }
            System.err.println("Error: Timeout waiting for SubStation response");
        }
        catch (JMSException e) {
            System.err.println("JMSException: " + e.getMessage());
            this.destroy(true);
        }
        return "Error: Timeout waiting for SubStation reply (timeout value may be set in gems.props file)";
    }

    synchronized MapMessage receiveReply(int i) throws JMSException {
        MapMessage mapmessage = null;
        long l = this.TIMEOUT;
        do {
            long l1 = System.currentTimeMillis();
            mapmessage = (MapMessage)this.m_receiver.receive(l);
            if (mapmessage == null) {
                return mapmessage;
            }
            String cid = mapmessage.getJMSCorrelationID();
            try {
                if (cid != null && Integer.valueOf(cid) == i) {
                    break;
                }
            }
            catch (NumberFormatException e) {
                System.err.println("Error: " + e.getMessage());
            }
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l1;
            if (l3 <= 200L) continue;
            l -= l3;
        } while (l > 10L);
        return mapmessage;
    }
}

