/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.GemsDateTimePicker;
import com.tibco.gems.GemsUtilities;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public class GemsSelectorWizardDialog
extends JDialog {
    protected JComboBox m_ba;
    protected Date m_start = null;
    protected Frame m_frame = null;
    protected boolean m_cancelled = false;
    protected JTextField m_st;
    public String m_selector = new String();

    public GemsSelectorWizardDialog(Frame frame, String title, String labelPrefix) {
        super(frame, title, true);
        this.m_frame = frame;
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel spanel = new JPanel(new SpringLayout(), true);
        mainPanel.add(spanel);
        JLabel l1 = new JLabel(labelPrefix + " messages with timestamps ", 11);
        l1.setMaximumSize(new Dimension(0, 24));
        this.m_ba = new JComboBox();
        this.m_ba.addItem(" After ");
        this.m_ba.addItem(" Before ");
        l1.setLabelFor(this.m_ba);
        spanel.add(l1);
        spanel.add(this.m_ba);
        this.m_start = new Date(System.currentTimeMillis() - 600000L);
        this.m_st = new JTextField(this.m_start.toString(), 20);
        this.m_st.setEditable(false);
        JButton sb = new JButton("Select...");
        sb.addActionListener(new DatePickerAction());
        spanel.add(this.m_st);
        spanel.add(sb);
        GemsUtilities.makeCompactGrid(spanel, 2, 2, 5, 5, 8, 8);
        JPanel holdbut = new JPanel();
        holdbut.setLayout(new FlowLayout());
        JButton a3 = new JButton("OK ");
        JButton b3 = new JButton("Cancel ");
        holdbut.add(a3);
        holdbut.add(b3);
        a3.addActionListener(new OkPressed());
        b3.addActionListener(new CancelPressed());
        mainPanel.add(holdbut);
        this.setContentPane(mainPanel);
        this.setLocationRelativeTo(frame);
        this.pack();
        this.show();
    }

    class CancelPressed
    implements ActionListener {
        CancelPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsSelectorWizardDialog.this.m_cancelled = true;
            GemsSelectorWizardDialog.this.dispose();
        }
    }

    class OkPressed
    implements ActionListener {
        OkPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsSelectorWizardDialog.this.m_selector = "JMSTimestamp ";
            String sel = (String)GemsSelectorWizardDialog.this.m_ba.getSelectedItem();
            GemsSelectorWizardDialog.this.m_selector = sel.equals(" Before ") ? GemsSelectorWizardDialog.this.m_selector + "< " : GemsSelectorWizardDialog.this.m_selector + "> ";
            GemsSelectorWizardDialog.this.m_selector = GemsSelectorWizardDialog.this.m_selector + GemsSelectorWizardDialog.this.m_start.getTime();
            GemsSelectorWizardDialog.this.dispose();
        }
    }

    class DatePickerAction
    implements ActionListener {
        DatePickerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsDateTimePicker dp = new GemsDateTimePicker(GemsSelectorWizardDialog.this.m_frame, "Select Date and Time:");
            dp.setLocationRelativeTo(GemsSelectorWizardDialog.this.m_frame);
            Date newdate = dp.select(GemsSelectorWizardDialog.this.m_start);
            if (newdate != null) {
                GemsSelectorWizardDialog.this.m_start = newdate;
                GemsSelectorWizardDialog.this.m_st.setText(GemsSelectorWizardDialog.this.m_start.toString());
            }
            dp.dispose();
        }
    }
}

