/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsTraceDialog;
import com.tibco.gems.GemsUtilities;
import com.tibco.tibjms.admin.LDAPParams;
import com.tibco.tibjms.admin.ServerInfo;
import com.tibco.tibjms.admin.StateInfo;
import java.awt.Color;
import java.awt.Component;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class GemsServerInfoTableModel
extends DefaultTableModel {
    JTable m_table;
    Object m_obj = new Object();
    MyRenderer m_renderer = new MyRenderer();
    GemsConnectionNode m_cn = null;
    ServerInfo m_s = null;

    public GemsServerInfoTableModel() {
        this.addColumn("Property");
        this.addColumn("Value");
    }

    public void setTable(JTable table) {
        this.m_table = table;
        if (!Gems.getGems().getViewOnlyMode()) {
            this.m_table.setDefaultRenderer(this.m_obj.getClass(), this.m_renderer);
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public String getSelectedCol1() {
        if (this.m_table.getSelectedRow() < 0) {
            return null;
        }
        Object val = this.m_table.getValueAt(this.m_table.getSelectedRow(), 0);
        if (val instanceof Long) {
            return String.valueOf((Long)val);
        }
        return (String)val;
    }

    public void populateTable(ServerInfo s, StateInfo st, HashMap ldapParams, boolean isRestartRequired, GemsConnectionNode cn) {
        Object[] r;
        Date d = new Date();
        String us = "";
        boolean isLdap = false;
        this.m_cn = cn;
        this.m_s = s;
        this.setRowCount(0);
        if (s == null) {
            if (st != null) {
                try {
                    Object[] r2 = new String[]{"State", st.getState().toString()};
                    this.addRow(r2);
                    r2 = new String[]{"ServerName", st.getServerName()};
                    this.addRow(r2);
                    r2 = new String[]{"VersionInfo", st.getVersionInfo().toString()};
                    this.addRow(r2);
                    r2 = new String[]{"ProcessId", String.valueOf(st.getProcessId())};
                    this.addRow(r2);
                    r2 = new String[]{"isAppliance", String.valueOf(st.isAppliance())};
                    this.addRow(r2);
                    if (st.isAppliance()) {
                        r2 = new String[]{"OverallSyncProgress", st.getOverallSyncProgress() == -1 ? "N/A" : String.valueOf(st.getOverallSyncProgress())};
                        this.addRow(r2);
                    }
                    r2 = new String[]{"isRestartRequired", String.valueOf(isRestartRequired)};
                    this.addRow(r2);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return;
        }
        try {
            int[] ua = s.getUserAuthLocations();
            for (int i = 0; ua != null && i < ua.length; ++i) {
                if (ua[i] == 3) {
                    us = us + "Local";
                } else if (ua[i] == 1) {
                    isLdap = true;
                    us = us + "LDAP";
                } else {
                    us = ua[i] == 4 ? us + "JAAS" : us + "System";
                }
                if (i >= ua.length - 1) continue;
                us = us + ",";
            }
        }
        catch (Throwable ua) {
            // empty catch block
        }
        try {
            r = new String[]{"State", s.getStateObj().toString()};
            this.addRow(r);
        }
        catch (Throwable t) {
            r = new String[]{"State", s.getState() == 4 ? "active" : "standby"};
            this.addRow(r);
        }
        r = new String[]{"ServerName", s.getServerName()};
        this.addRow(r);
        r = new String[]{"VersionInfo", s.getVersionInfo().toString()};
        this.addRow(r);
        r = new String[]{"ProcessId", String.valueOf(s.getProcessId())};
        this.addRow(r);
        try {
            r = new String[]{"isAppliance", String.valueOf(s.isAppliance())};
            this.addRow(r);
            if (s.isAppliance()) {
                r = new String[]{"OverallSyncProgress", s.getOverallSyncProgress() == -1 ? "N/A" : String.valueOf(s.getOverallSyncProgress())};
                this.addRow(r);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        r = new String[]{"isRestartRequired", String.valueOf(isRestartRequired)};
        this.addRow(r);
        try {
            r = new String[]{"isAlwaysExitOnDiskErrorEnabled", String.valueOf(s.isAlwaysExitOnDiskErrorEnabled())};
            this.addRow(r);
        }
        catch (Throwable t) {
            // empty catch block
        }
        r = new String[]{"isAuthorizationEnabled", String.valueOf(s.isAuthorizationEnabled())};
        this.addRow(r);
        r = new String[]{"isClientTraceEnabled", String.valueOf(s.isClientTraceEnabled())};
        this.addRow(r);
        r = new String[]{"isEvaluation", String.valueOf(s.isEvaluation())};
        this.addRow(r);
        r = new String[]{"isFlowControlEnabled", String.valueOf(s.isFlowControlEnabled())};
        this.addRow(r);
        r = new String[]{"isFSyncEnabled", String.valueOf(s.isFSyncEnabled())};
        this.addRow(r);
        r = new String[]{"isMessageSwappingEnabled", String.valueOf(s.isMessageSwappingEnabled())};
        this.addRow(r);
        try {
            r = new String[]{"isMulticastEnabled", String.valueOf(s.isMulticastEnabled())};
            this.addRow(r);
        }
        catch (Throwable t) {
            // empty catch block
        }
        r = new String[]{"isRoutingEnabled", String.valueOf(s.isRoutingEnabled())};
        this.addRow(r);
        r = new String[]{"isSSLRequireClientCert", String.valueOf(s.isSSLRequireClientCert())};
        this.addRow(r);
        try {
            r = new String[]{"isSSLRequireRouteCertOnly", String.valueOf(s.isSSLRequireRouteCertOnly())};
            this.addRow(r);
        }
        catch (Throwable t) {
            // empty catch block
        }
        r = new String[]{"isSSLUserCertUsername", String.valueOf(s.isSSLUserCertUsername())};
        this.addRow(r);
        r = new String[]{"isStatisticsEnabled", String.valueOf(s.isStatisticsEnabled())};
        this.addRow(r);
        r = new String[]{"isStoreCRCEnabled", String.valueOf(s.isStoreCRCEnabled())};
        this.addRow(r);
        r = new String[]{"isStoreTruncateEnabled", String.valueOf(s.isStoreTruncateEnabled())};
        this.addRow(r);
        r = new String[]{"isTibrvTransportsEnabled", String.valueOf(s.isTibrvTransportsEnabled())};
        this.addRow(r);
        r = new String[]{"isTibssTransportsEnabled", String.valueOf(s.isTibssTransportsEnabled())};
        this.addRow(r);
        r = new String[]{"isTrackCorrelationIds", String.valueOf(s.isTrackCorrelationIds())};
        this.addRow(r);
        r = new String[]{"isTrackMsgIds", String.valueOf(s.isTrackMsgIds())};
        this.addRow(r);
        try {
            r = new String[]{"AdminConnectionCount", String.valueOf(s.getAdminConnectionCount())};
            this.addRow(r);
        }
        catch (Throwable t) {
            // empty catch block
        }
        r = new String[]{"ACLsFile", s.getACLsFile()};
        this.addRow(r);
        r = new String[]{"AsyncDBSize", GemsUtilities.getHumanReadableSize(s.getAsyncDBSize())};
        this.addRow(r);
        r = new String[]{"BackupName", s.getBackupName()};
        this.addRow(r);
        r = new String[]{"BridgesFile", s.getBridgesFile()};
        this.addRow(r);
        try {
            r = new String[]{"ChannelsFile", s.getChannelsFile()};
            this.addRow(r);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            r = new String[]{"ClientConnectionCount", String.valueOf(s.getClientConnectionCount())};
            this.addRow(r);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            r = new String[]{"ClientHeartbeatServerInterval", String.valueOf(s.getClientHeartbeatServerInterval())};
            this.addRow(r);
            r = new String[]{"ClientTimeoutServerConnection", String.valueOf(s.getClientTimeoutServerConnection())};
            this.addRow(r);
        }
        catch (Throwable t) {
            // empty catch block
        }
        short ft = s.getClientTraceFilterType();
        String ctft = "";
        if (ft == 0) {
            ctft = ctft + "None";
        } else if (ft == 1) {
            ctft = ctft + "User";
        } else if (ft == 2) {
            ctft = ctft + "Client";
        } else if (ft == 3) {
            ctft = ctft + "Connection";
        }
        r = new String[]{"ClientTraceFilterType", ctft};
        this.addRow(r);
        short tt = s.getClientTraceTarget();
        String ctt = "";
        if (tt == 1) {
            ctt = ctt + "stdout";
        } else if (tt == 2) {
            ctt = ctt + "stderr";
        }
        Object vl = s.getClientTraceFilterValue();
        String sv = "";
        if (vl instanceof String) {
            sv = (String)vl;
        } else if (vl instanceof Long) {
            sv = String.valueOf((Long)vl);
        }
        r = new String[]{"ClientTraceFilterValue", sv};
        this.addRow(r);
        r = new String[]{"ClientTraceTarget", ctt};
        this.addRow(r);
        try {
            r = new String[]{"ClockSyncInterval", String.valueOf(s.getClockSyncInterval())};
            this.addRow(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        r = new String[]{"ConfigFile", s.getConfigFile()};
        this.addRow(r);
        r = new String[]{"ConnectionCount", String.valueOf(s.getConnectionCount())};
        this.addRow(r);
        r = new String[]{"ConsoleTraceInfo", GemsTraceDialog.TraceInfoToString(s.getConsoleTraceInfo())};
        this.addRow(r);
        try {
            r = new String[]{"ConsumerCount", String.valueOf(s.getConsumerCount())};
            this.addRow(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            r = new String[]{"DbStoreClasspath", s.getDbStoreClasspath()};
            this.addRow(r);
            r = new String[]{"DbStoreJDBCDriverName", s.getDbStoreJDBCDriverName()};
            this.addRow(r);
            r = new String[]{"DbStoreJDBCDialect", s.getDbStoreJDBCDialect()};
            this.addRow(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            r = new String[]{"DestinationBacklogSwapout", String.valueOf(s.getDestinationBacklogSwapout())};
            this.addRow(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        r = new String[]{"DetailedStatistics", String.valueOf(s.getDetailedStatistics())};
        this.addRow(r);
        r = new String[]{"DiskReadRate", GemsUtilities.getHumanReadableSize(s.getDiskReadRate())};
        this.addRow(r);
        r = new String[]{"DiskWriteRate", GemsUtilities.getHumanReadableSize(s.getDiskWriteRate())};
        this.addRow(r);
        try {
            r = new String[]{"DiskReadOperationsRate", String.valueOf(s.getDiskReadOperationsRate())};
            this.addRow(r);
            r = new String[]{"DiskWriteOperationsRate", String.valueOf(s.getDiskWriteOperationsRate())};
            this.addRow(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        r = new String[]{"DurableCount", String.valueOf(s.getDurableCount())};
        this.addRow(r);
        r = new String[]{"DurablesFile", s.getDurablesFile()};
        this.addRow(r);
        r = new String[]{"FactoriesFile", s.getFactoriesFile()};
        this.addRow(r);
        r = new String[]{"FaultTolerantActivation", String.valueOf(s.getFaultTolerantActivation())};
        this.addRow(r);
        r = new String[]{"FaultTolerantFailoverReread", String.valueOf(s.getFaultTolerantFailoverReread())};
        this.addRow(r);
        r = new String[]{"FaultTolerantHeartbeat", String.valueOf(s.getFaultTolerantHeartbeat())};
        this.addRow(r);
        r = new String[]{"FaultTolerantReconnectTimeout", String.valueOf(s.getFaultTolerantReconnectTimeout())};
        this.addRow(r);
        r = new String[]{"FaultTolerantURL", s.getFaultTolerantURL()};
        this.addRow(r);
        try {
            r = new String[]{"FTLParams", s.getFTLParams().toString()};
            this.addRow(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        r = new String[]{"GroupsFile", s.getGroupsFile()};
        this.addRow(r);
        try {
            r = new String[]{"HealthCheckListen", s.getHealthCheckListen()};
            this.addRow(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        r = new String[]{"InboundBytesRate", String.valueOf(s.getInboundBytesRate())};
        this.addRow(r);
        r = new String[]{"InboundMessageCount", String.valueOf(s.getInboundMessageCount())};
        this.addRow(r);
        r = new String[]{"InboundMessageRate", String.valueOf(s.getInboundMessageRate())};
        this.addRow(r);
        try {
            r = new String[]{"JRELibrary", s.getJRELibrary()};
            this.addRow(r);
            r = new String[]{"JREOptions", GemsUtilities.arrayToString(s.getJREOptions())};
            this.addRow(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            r = new String[]{"LargeDestCount", String.valueOf(s.getLargeDestCount())};
            this.addRow(r);
            r = new String[]{"LargeDestMemory", String.valueOf(s.getLargeDestMemory())};
            this.addRow(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        LDAPParams ld = s.getLDAPParams();
        if (ld != null) {
            String lds = ld.toString();
            String v = GemsUtilities.getPropValueFromString("ldapalgfilt", lds, ldapParams);
            if (v != null && v.length() != 0 && !v.equals("null")) {
                r = new String[]{"LDAP_AllGroupsFilter", v};
                this.addRow(r);
            }
            if ((v = GemsUtilities.getPropValueFromString("ldapalufilt", lds, ldapParams)) != null && v.length() != 0 && !v.equals("null")) {
                r = new String[]{"LDAP_AllUsersFilter", v};
                this.addRow(r);
            }
            if ((v = GemsUtilities.getPropValueFromString("ldapcache", lds, ldapParams)) != null && v.length() != 0 && !v.equals("null")) {
                r = new String[]{"LDAP_CacheEnabled", v};
                this.addRow(r);
            }
            if ((v = GemsUtilities.getPropValueFromString("ldapcttl", lds, ldapParams)) != null && v.length() != 0 && !v.equals("null")) {
                r = new String[]{"LDAP_CacheTTL", v};
                this.addRow(r);
            }
            if ((v = GemsUtilities.getPropValueFromString("ldapconntp", lds, ldapParams)) != null && v.length() != 0 && !v.equals("null")) {
                r = new String[]{"LDAP_ConnectionType", v};
                this.addRow(r);
            }
            if ((v = GemsUtilities.getPropValueFromString("ldapdgnmatr", lds, ldapParams)) != null && v.length() != 0 && !v.equals("null")) {
                r = new String[]{"LDAP_DynamicGroupAttribute", v};
                this.addRow(r);
            }
            if ((v = GemsUtilities.getPropValueFromString("ldapdgclass", lds, ldapParams)) != null && v.length() != 0 && !v.equals("null")) {
                r = new String[]{"LDAP_DynamicGroupClass", v};
                this.addRow(r);
            }
            if ((v = GemsUtilities.getPropValueFromString("ldapdmuatr", lds, ldapParams)) != null && v.length() != 0 && !v.equals("null")) {
                r = new String[]{"LDAP_DynamicMemURLAttribute", v};
                this.addRow(r);
            }
            if ((v = GemsUtilities.getPropValueFromString("ldapgbasedn", lds, ldapParams)) != null && v.length() != 0 && !v.equals("null")) {
                r = new String[]{"LDAP_GroupBaseDN", v};
                this.addRow(r);
            }
            if ((v = GemsUtilities.getPropValueFromString("ldapgnmfilt", lds, ldapParams)) != null && v.length() != 0 && !v.equals("null")) {
                r = new String[]{"LDAP_GroupNameFilter", v};
                this.addRow(r);
            }
            if ((v = GemsUtilities.getPropValueFromString("ldapgscope", lds, ldapParams)) != null && v.length() != 0 && !v.equals("null")) {
                r = new String[]{"LDAP_GroupScope", v};
                this.addRow(r);
            }
            if ((v = GemsUtilities.getPropValueFromString("ldapprinc", lds, ldapParams)) != null && v.length() != 0 && !v.equals("null")) {
                r = new String[]{"LDAP_Principal", v};
                this.addRow(r);
            }
            if ((v = GemsUtilities.getPropValueFromString("ldapsgnmatr", lds, ldapParams)) != null && v.length() != 0 && !v.equals("null")) {
                r = new String[]{"LDAP_StaticGroupAttribute", v};
                this.addRow(r);
            }
            if ((v = GemsUtilities.getPropValueFromString("ldapsgclass", lds, ldapParams)) != null && v.length() != 0 && !v.equals("null")) {
                r = new String[]{"LDAP_StaticGroupClass", v};
                this.addRow(r);
            }
            if ((v = GemsUtilities.getPropValueFromString("ldapsmematr", lds, ldapParams)) != null && v.length() != 0 && !v.equals("null")) {
                r = new String[]{"LDAP_StaticMemberAttribute", v};
                this.addRow(r);
            }
            if ((v = GemsUtilities.getPropValueFromString("ldapsgmfilt", lds, ldapParams)) != null && v.length() != 0 && !v.equals("null")) {
                r = new String[]{"LDAP_StaticMemberFilter", v};
                this.addRow(r);
            }
            if ((v = GemsUtilities.getPropValueFromString("ldapcadir", lds, ldapParams)) != null && v.length() != 0 && !v.equals("null")) {
                r = new String[]{"LDAP_TLSCACertDir", v};
                this.addRow(r);
            }
            if ((v = GemsUtilities.getPropValueFromString("ldapcafile", lds, ldapParams)) != null && v.length() != 0 && !v.equals("null")) {
                r = new String[]{"LDAP_TLSCACertFile", v};
                this.addRow(r);
            }
            if ((v = GemsUtilities.getPropValueFromString("ldapcipher", lds, ldapParams)) != null && v.length() != 0 && !v.equals("null")) {
                r = new String[]{"LDAP_TLSCiphers", v};
                this.addRow(r);
            }
            if ((v = GemsUtilities.getPropValueFromString("ldapcert", lds, ldapParams)) != null && v.length() != 0 && !v.equals("null")) {
                r = new String[]{"LDAP_TLSClientCert", v};
                this.addRow(r);
            }
            if ((v = GemsUtilities.getPropValueFromString("ldapkey", lds, ldapParams)) != null && v.length() != 0 && !v.equals("null")) {
                r = new String[]{"LDAP_TLSClientKey", v};
                this.addRow(r);
            }
            if ((v = GemsUtilities.getPropValueFromString("ldaprand", lds, ldapParams)) != null && v.length() != 0 && !v.equals("null")) {
                r = new String[]{"LDAP_TLSRandFile", v};
                this.addRow(r);
            }
            if ((v = GemsUtilities.getPropValueFromString("ldapurl", lds, ldapParams)) != null && v.length() != 0 && !v.equals("null")) {
                r = new String[]{"LDAP_URL", v};
                this.addRow(r);
            }
            if ((v = GemsUtilities.getPropValueFromString("ldapunmatr", lds, ldapParams)) != null && v.length() != 0 && !v.equals("null")) {
                r = new String[]{"LDAP_UserAttribute", v};
                this.addRow(r);
            }
            if ((v = GemsUtilities.getPropValueFromString("ldapubasedn", lds, ldapParams)) != null && v.length() != 0 && !v.equals("null")) {
                r = new String[]{"LDAP_UserBaseDN", v};
                this.addRow(r);
            }
            if ((v = GemsUtilities.getPropValueFromString("ldapuclass", lds, ldapParams)) != null && v.length() != 0 && !v.equals("null")) {
                r = new String[]{"LDAP_UserClass", v};
                this.addRow(r);
            }
            if ((v = GemsUtilities.getPropValueFromString("ldapunmfilt", lds, ldapParams)) != null && v.length() != 0 && !v.equals("null")) {
                r = new String[]{"LDAP_UserNameFilter", v};
                this.addRow(r);
            }
            if ((v = GemsUtilities.getPropValueFromString("ldapuscope", lds, ldapParams)) != null && v.length() != 0 && !v.equals("null")) {
                r = new String[]{"LDAP_UserScope", v};
                this.addRow(r);
            }
        }
        r = new String[]{"ListenPorts", GemsUtilities.arrayToString(s.getListenPorts())};
        this.addRow(r);
        r = new String[]{"LogFileMaxSize", GemsUtilities.getHumanReadableSize(s.getLogFileMaxSize())};
        this.addRow(r);
        r = new String[]{"LogFileName", s.getLogFileName()};
        this.addRow(r);
        r = new String[]{"LogTraceInfo", GemsTraceDialog.TraceInfoToString(s.getLogTraceInfo())};
        this.addRow(r);
        try {
            r = new String[]{"MaxClientMsgSize", GemsUtilities.getHumanReadableSize(s.getMaxClientMsgSize())};
            this.addRow(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        r = new String[]{"MaxConnections", String.valueOf(s.getMaxConnections())};
        this.addRow(r);
        r = new String[]{"MaxMsgMemory", GemsUtilities.getHumanReadableSize(s.getMaxMsgMemory())};
        this.addRow(r);
        r = new String[]{"MaxStatisticsMemory", GemsUtilities.getHumanReadableSize(s.getMaxStatisticsMemory())};
        this.addRow(r);
        try {
            r = new String[]{"MessagePoolBlockSize", String.valueOf(s.getMessagePoolBlockSize())};
            this.addRow(r);
            r = new String[]{"MessagePoolSize", String.valueOf(s.getMessagePoolSize())};
            this.addRow(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        r = new String[]{"MsgMem", GemsUtilities.getHumanReadableSize(s.getMsgMem())};
        this.addRow(r);
        r = new String[]{"MsgMemPooled", GemsUtilities.getHumanReadableSize(s.getMsgMemPooled())};
        this.addRow(r);
        try {
            r = new String[]{"MulticastStatisticsInterval", String.valueOf(s.getMulticastStatisticsInterval())};
            this.addRow(r);
            r = new String[]{"NPSendCheckMode", String.valueOf(s.getNPSendCheckMode())};
            this.addRow(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        r = new String[]{"OutboundMessageCount", String.valueOf(s.getOutboundMessageCount())};
        this.addRow(r);
        r = new String[]{"OutboundMessageRate", String.valueOf(s.getOutboundMessageRate())};
        this.addRow(r);
        r = new String[]{"PendingMessageCount", String.valueOf(s.getPendingMessageCount())};
        this.addRow(r);
        r = new String[]{"PendingMessageSize", GemsUtilities.getHumanReadableSize(s.getPendingMessageSize())};
        this.addRow(r);
        try {
            r = new String[]{"ProducerCount", String.valueOf(s.getProducerCount())};
            this.addRow(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        r = new String[]{"QueueCount", String.valueOf(s.getQueueCount())};
        this.addRow(r);
        r = new String[]{"QueuesFile", s.getQueuesFile()};
        this.addRow(r);
        r = new String[]{"RateInterval", String.valueOf(s.getRateInterval())};
        this.addRow(r);
        try {
            r = new String[]{"ReserveMemory", GemsUtilities.getHumanReadableSize(s.getReserveMemory())};
            this.addRow(r);
            r = new String[]{"RouteRecoverInterval", String.valueOf(s.getRouteRecoverInterval())};
            this.addRow(r);
            r = new String[]{"RouteRecoverCount", String.valueOf(s.getRouteRecoverCount())};
            this.addRow(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        r = new String[]{"RoutesFile", s.getRoutesFile()};
        this.addRow(r);
        try {
            r = new String[]{"RuntimeModulePath", String.valueOf(s.getRuntimeModulePath())};
            this.addRow(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            r = new String[]{"SecondaryHealthCheckListen", s.getSecondaryHealthCheckListen()};
            this.addRow(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            r = new String[]{"ServerConfigurationMode", s.getServerConfigurationMode() == 0 ? "Conf" : "XML"};
            this.addRow(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            r = new String[]{"ServerHeartbeatClientInterval", String.valueOf(s.getServerHeartbeatClientInterval())};
            this.addRow(r);
            r = new String[]{"ServerHeartbeatServerInterval", String.valueOf(s.getServerHeartbeatServerInterval())};
            this.addRow(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            r = new String[]{"ServerHostname", s.getServerHostname()};
            this.addRow(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        r = new String[]{"ServerRateInterval", String.valueOf(s.getServerRateInterval())};
        this.addRow(r);
        try {
            r = new String[]{"ServerTimeoutClientConnection", String.valueOf(s.getServerTimeoutClientConnection())};
            this.addRow(r);
            r = new String[]{"ServerTimeoutServerConnection", String.valueOf(s.getServerTimeoutServerConnection())};
            this.addRow(r);
            r = new String[]{"SessionCount", String.valueOf(s.getSessionCount())};
            this.addRow(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        r = new String[]{"SSLCertUserSpecname", String.valueOf(s.getSSLCertUserSpecname())};
        this.addRow(r);
        r = new String[]{"SSLDHSize", String.valueOf(s.getSSLDHSize())};
        this.addRow(r);
        r = new String[]{"SSLParams", s.getSSLParams() == null ? "" : s.getSSLParams().toString()};
        this.addRow(r);
        d.setTime(s.getStartTime());
        r = new String[]{"StartTime", d.toString()};
        this.addRow(r);
        r = new String[]{"StatisticsCleanupInterval", String.valueOf(s.getStatisticsCleanupInterval())};
        this.addRow(r);
        r = new String[]{"StoreAsyncMinimum", GemsUtilities.getHumanReadableSize(s.getStoreAsyncMinimum())};
        this.addRow(r);
        r = new String[]{"StoreDirectory", s.getStoreDirectory()};
        this.addRow(r);
        try {
            r = new String[]{"StoresFile", s.getStoresFile()};
            this.addRow(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        r = new String[]{"StoreMinimum", GemsUtilities.getHumanReadableSize(s.getStoreMinimum())};
        this.addRow(r);
        r = new String[]{"StoreSyncMinimum", GemsUtilities.getHumanReadableSize(s.getStoreSyncMinimum())};
        this.addRow(r);
        r = new String[]{"SyncDBSize", GemsUtilities.getHumanReadableSize(s.getSyncDBSize())};
        this.addRow(r);
        r = new String[]{"TibrvcmFile", s.getTibrvcmFile()};
        this.addRow(r);
        r = new String[]{"TopicCount", String.valueOf(s.getTopicCount())};
        this.addRow(r);
        r = new String[]{"TopicsFile", s.getTopicsFile()};
        this.addRow(r);
        r = new String[]{"TransportsFile", s.getTransportsFile()};
        this.addRow(r);
        r = new String[]{"UpTime", GemsUtilities.getFullHumanReadableTime(s.getUpTime())};
        this.addRow(r);
        r = new String[]{"URL", String.valueOf(s.getURL())};
        this.addRow(r);
        r = new String[]{"UserAuthLocations", us};
        this.addRow(r);
        r = new String[]{"UsersFile", s.getUsersFile()};
        this.addRow(r);
        try {
            r = new String[]{"XADefaultTimeout", String.valueOf(s.getXADefaultTimeout())};
            this.addRow(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    class MyRenderer
    extends DefaultTableCellRenderer {
        public MyRenderer() {
            this.setToolTipText("Double-click to set property");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (column == 1 && value instanceof String) {
                Object v = table.getValueAt(row, column - 1);
                if (v instanceof String && ((String)v).equals("State")) {
                    if (!(((String)value).equals("active") || ((String)value).equals("active-replicating") || ((String)value).equals("standby") || ((String)value).equals("standby-replicating"))) {
                        cell.setBackground(Color.orange);
                        cell.setForeground(table.getForeground());
                        return cell;
                    }
                } else if (v instanceof String && ((String)v).equals("isRestartRequired")) {
                    if (((String)value).equals("true")) {
                        cell.setBackground(Color.orange);
                        cell.setForeground(table.getForeground());
                        return cell;
                    }
                } else if (v instanceof String && ((String)v).equals("isClientTraceEnabled")) {
                    if (((String)value).equals("true")) {
                        cell.setBackground(Color.orange);
                        cell.setForeground(table.getForeground());
                        return cell;
                    }
                } else if (v instanceof String && ((String)v).equals("MsgMem")) {
                    if (GemsServerInfoTableModel.this.m_s != null && GemsServerInfoTableModel.this.m_cn != null) {
                        Long lim = GemsServerInfoTableModel.this.m_cn.getErrorLimit((String)v);
                        if (lim != null && GemsServerInfoTableModel.this.m_s.getMsgMem() > lim) {
                            cell.setBackground(Color.red);
                            cell.setForeground(table.getForeground());
                            return cell;
                        }
                        lim = GemsServerInfoTableModel.this.m_cn.getWarnLimit((String)v);
                        if (lim != null && GemsServerInfoTableModel.this.m_s.getMsgMem() > lim) {
                            cell.setBackground(Color.orange);
                            cell.setForeground(table.getForeground());
                            return cell;
                        }
                    }
                } else if (v instanceof String && ((String)v).equals("AsyncDBSize")) {
                    if (GemsServerInfoTableModel.this.m_s != null && GemsServerInfoTableModel.this.m_cn != null) {
                        Long lim = GemsServerInfoTableModel.this.m_cn.getErrorLimit((String)v);
                        if (lim != null && GemsServerInfoTableModel.this.m_s.getAsyncDBSize() > lim) {
                            cell.setBackground(Color.red);
                            cell.setForeground(table.getForeground());
                            return cell;
                        }
                        lim = GemsServerInfoTableModel.this.m_cn.getWarnLimit((String)v);
                        if (lim != null && GemsServerInfoTableModel.this.m_s.getAsyncDBSize() > lim) {
                            cell.setBackground(Color.orange);
                            cell.setForeground(table.getForeground());
                            return cell;
                        }
                    }
                } else if (v instanceof String && ((String)v).equals("SyncDBSize")) {
                    if (GemsServerInfoTableModel.this.m_s != null && GemsServerInfoTableModel.this.m_cn != null) {
                        Long lim = GemsServerInfoTableModel.this.m_cn.getErrorLimit((String)v);
                        if (lim != null && GemsServerInfoTableModel.this.m_s.getSyncDBSize() > lim) {
                            cell.setBackground(Color.red);
                            cell.setForeground(table.getForeground());
                            return cell;
                        }
                        lim = GemsServerInfoTableModel.this.m_cn.getWarnLimit((String)v);
                        if (lim != null && GemsServerInfoTableModel.this.m_s.getSyncDBSize() > lim) {
                            cell.setBackground(Color.orange);
                            cell.setForeground(table.getForeground());
                            return cell;
                        }
                    }
                } else if (v instanceof String && ((String)v).equals("PendingMessageCount")) {
                    if (GemsServerInfoTableModel.this.m_s != null && GemsServerInfoTableModel.this.m_cn != null) {
                        Long lim = GemsServerInfoTableModel.this.m_cn.getErrorLimit("PendingMsgs");
                        if (lim != null && GemsServerInfoTableModel.this.m_s.getPendingMessageCount() > lim) {
                            cell.setBackground(Color.red);
                            cell.setForeground(table.getForeground());
                            return cell;
                        }
                        lim = GemsServerInfoTableModel.this.m_cn.getWarnLimit("PendingMsgs");
                        if (lim != null && GemsServerInfoTableModel.this.m_s.getPendingMessageCount() > lim) {
                            cell.setBackground(Color.orange);
                            cell.setForeground(table.getForeground());
                            return cell;
                        }
                    }
                } else if (v instanceof String && ((String)v).equals("PendingMessageSize")) {
                    if (GemsServerInfoTableModel.this.m_s != null && GemsServerInfoTableModel.this.m_cn != null) {
                        Long lim = GemsServerInfoTableModel.this.m_cn.getErrorLimit("PendingMsgSize");
                        if (lim != null && GemsServerInfoTableModel.this.m_s.getPendingMessageSize() > lim) {
                            cell.setBackground(Color.red);
                            cell.setForeground(table.getForeground());
                            return cell;
                        }
                        lim = GemsServerInfoTableModel.this.m_cn.getWarnLimit("PendingMsgSize");
                        if (lim != null && GemsServerInfoTableModel.this.m_s.getPendingMessageSize() > lim) {
                            cell.setBackground(Color.orange);
                            cell.setForeground(table.getForeground());
                            return cell;
                        }
                    }
                } else if (v instanceof String && ((String)v).equals("InboundMessageRate")) {
                    if (GemsServerInfoTableModel.this.m_s != null && GemsServerInfoTableModel.this.m_cn != null) {
                        Long lim = GemsServerInfoTableModel.this.m_cn.getErrorLimit("InMsgRate");
                        if (lim != null && GemsServerInfoTableModel.this.m_s.getInboundMessageRate() > lim) {
                            cell.setBackground(Color.red);
                            cell.setForeground(table.getForeground());
                            return cell;
                        }
                        lim = GemsServerInfoTableModel.this.m_cn.getWarnLimit("InMsgRate");
                        if (lim != null && GemsServerInfoTableModel.this.m_s.getInboundMessageRate() > lim) {
                            cell.setBackground(Color.orange);
                            cell.setForeground(table.getForeground());
                            return cell;
                        }
                    }
                } else if (v instanceof String && ((String)v).equals("OutboundMessageRate")) {
                    if (GemsServerInfoTableModel.this.m_s != null && GemsServerInfoTableModel.this.m_cn != null) {
                        Long lim = GemsServerInfoTableModel.this.m_cn.getErrorLimit("OutMsgRate");
                        if (lim != null && GemsServerInfoTableModel.this.m_s.getOutboundMessageRate() > lim) {
                            cell.setBackground(Color.red);
                            cell.setForeground(table.getForeground());
                            return cell;
                        }
                        lim = GemsServerInfoTableModel.this.m_cn.getWarnLimit("OutMsgRate");
                        if (lim != null && GemsServerInfoTableModel.this.m_s.getOutboundMessageRate() > lim) {
                            cell.setBackground(Color.orange);
                            cell.setForeground(table.getForeground());
                            return cell;
                        }
                    }
                } else if (v instanceof String && ((String)v).equals("InboundMessageCount")) {
                    if (GemsServerInfoTableModel.this.m_s != null && GemsServerInfoTableModel.this.m_cn != null) {
                        Long lim = GemsServerInfoTableModel.this.m_cn.getErrorLimit("InMsgCount");
                        if (lim != null && GemsServerInfoTableModel.this.m_s.getInboundMessageCount() > lim) {
                            cell.setBackground(Color.red);
                            cell.setForeground(table.getForeground());
                            return cell;
                        }
                        lim = GemsServerInfoTableModel.this.m_cn.getWarnLimit("InMsgCount");
                        if (lim != null && GemsServerInfoTableModel.this.m_s.getInboundMessageCount() > lim) {
                            cell.setBackground(Color.orange);
                            cell.setForeground(table.getForeground());
                            return cell;
                        }
                    }
                } else if (v instanceof String && ((String)v).equals("OutboundMessageCount")) {
                    if (GemsServerInfoTableModel.this.m_s != null && GemsServerInfoTableModel.this.m_cn != null) {
                        Long lim = GemsServerInfoTableModel.this.m_cn.getErrorLimit("OutMsgCount");
                        if (lim != null && GemsServerInfoTableModel.this.m_s.getOutboundMessageCount() > lim) {
                            cell.setBackground(Color.red);
                            cell.setForeground(table.getForeground());
                            return cell;
                        }
                        lim = GemsServerInfoTableModel.this.m_cn.getWarnLimit("OutMsgCount");
                        if (lim != null && GemsServerInfoTableModel.this.m_s.getOutboundMessageCount() > lim) {
                            cell.setBackground(Color.orange);
                            cell.setForeground(table.getForeground());
                            return cell;
                        }
                    }
                } else if (v instanceof String && ((String)v).equals("DiskReadRate")) {
                    if (GemsServerInfoTableModel.this.m_s != null && GemsServerInfoTableModel.this.m_cn != null) {
                        Long lim = GemsServerInfoTableModel.this.m_cn.getErrorLimit("DiskReadRate");
                        if (lim != null && GemsServerInfoTableModel.this.m_s.getDiskReadRate() > lim) {
                            cell.setBackground(Color.red);
                            cell.setForeground(table.getForeground());
                            return cell;
                        }
                        lim = GemsServerInfoTableModel.this.m_cn.getWarnLimit("DiskReadRate");
                        if (lim != null && GemsServerInfoTableModel.this.m_s.getDiskReadRate() > lim) {
                            cell.setBackground(Color.orange);
                            cell.setForeground(table.getForeground());
                            return cell;
                        }
                    }
                } else if (v instanceof String && ((String)v).equals("DiskWriteRate")) {
                    if (GemsServerInfoTableModel.this.m_s != null && GemsServerInfoTableModel.this.m_cn != null) {
                        Long lim = GemsServerInfoTableModel.this.m_cn.getErrorLimit("DiskWriteRate");
                        if (lim != null && GemsServerInfoTableModel.this.m_s.getDiskWriteRate() > lim) {
                            cell.setBackground(Color.red);
                            cell.setForeground(table.getForeground());
                            return cell;
                        }
                        lim = GemsServerInfoTableModel.this.m_cn.getWarnLimit("DiskWriteRate");
                        if (lim != null && GemsServerInfoTableModel.this.m_s.getDiskWriteRate() > lim) {
                            cell.setBackground(Color.orange);
                            cell.setForeground(table.getForeground());
                            return cell;
                        }
                    }
                } else if (v instanceof String && GemsServerInfoTableModel.this.m_cn != null) {
                    Long lim;
                    String sv = (String)v;
                    int i = sv.indexOf("Count");
                    if (i > 0) {
                        sv = sv.substring(0, i);
                        sv = sv + "s";
                    }
                    if ((lim = GemsServerInfoTableModel.this.m_cn.getErrorLimit(sv)) != null) {
                        Long lv = null;
                        try {
                            lv = Long.parseLong((String)value);
                        }
                        catch (Exception e) {
                            System.err.println(sv + " " + e.getMessage());
                        }
                        if (lv != null && lv > lim) {
                            cell.setBackground(Color.red);
                            cell.setForeground(table.getForeground());
                            return cell;
                        }
                        lim = GemsServerInfoTableModel.this.m_cn.getWarnLimit(sv);
                        if (lv != null && lv > lim) {
                            cell.setBackground(Color.orange);
                            cell.setForeground(table.getForeground());
                            return cell;
                        }
                    }
                }
            }
            if (isSelected) {
                cell.setBackground(table.getSelectionBackground());
            } else {
                cell.setBackground(Color.white);
            }
            return cell;
        }
    }
}

