/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsCellValue;
import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsUtilities;
import com.tibco.tibjms.admin.ServerInfo;
import java.awt.Color;
import java.awt.Component;
import java.util.Enumeration;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class GemsServerMonitorTableModel
extends DefaultTableModel {
    JTable m_table;
    MyRenderer m_renderer = new MyRenderer();
    Object m_obj = new Object();
    long[] totals = new long[18];
    String[] m_colPositions = null;
    final int MAX_COLS = 22;
    GemsConnectionNode m_cn = null;
    static String[] cols = new String[]{"Alias", "State", "ServerName", "FaultTolerantState", "Connections", "Sessions", "Queues", "Topics", "Durables", "PendingMsgs", "PendingMsgSize", "MsgMem", "InMsgRate", "OutMsgRate", "DiskReadRate", "DiskWriteRate", "AsyncDBSize", "SyncDBSize", "RespTime"};
    static String[] cols1 = new String[]{"Alias", "State", "ServerName", "FaultTolerantState", "Events", "Connections", "Sessions", "Queues", "Topics", "Durables", "PendingMsgs", "PendingMsgSize", "MsgMem", "InMsgRate", "OutMsgRate", "DiskReadRate", "DiskWriteRate", "AsyncDBSize", "SyncDBSize", "RespTime"};

    public GemsServerMonitorTableModel() {
        this.initColumnPositions();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public String getSelectedCol1() {
        if (this.m_table.getSelectedRow() < 0) {
            return null;
        }
        Object c = this.m_table.getValueAt(this.m_table.getSelectedRow(), 0);
        if (c instanceof GemsCellValue) {
            return ((GemsCellValue)c).m_cellValue;
        }
        return null;
    }

    public boolean populateTable(DefaultMutableTreeNode n, boolean doConnect, boolean showEvents) {
        this.setRowCount(0);
        if (n instanceof GemsConnectionNode) {
            this.m_cn = (GemsConnectionNode)n;
        }
        for (int i = 0; i < 18; ++i) {
            this.totals[i] = 0L;
        }
        int numCols = cols.length;
        if (showEvents) {
            ++numCols;
        }
        if (this.getColumnCount() != numCols) {
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(0);
            this.m_table.setDefaultRenderer(this.m_obj.getClass(), this.m_renderer);
            if (showEvents) {
                this.setColumnIdentifiers(cols1);
            } else {
                this.setColumnIdentifiers(cols);
            }
            this.m_table.getColumn("Alias").setPreferredWidth(100);
            this.m_table.getColumn("ServerName").setPreferredWidth(100);
            this.m_table.getColumn("FaultTolerantState").setPreferredWidth(140);
            this.m_table.getColumn("State").setPreferredWidth(65);
            this.m_table.getColumn("PendingMsgs").setPreferredWidth(80);
            this.m_table.getColumn("PendingMsgSize").setPreferredWidth(100);
            this.m_table.getColumn("InMsgRate").setPreferredWidth(70);
            this.m_table.getColumn("OutMsgRate").setPreferredWidth(80);
            this.m_table.getColumn("MsgMem").setPreferredWidth(70);
            this.m_table.getColumn("Topics").setPreferredWidth(50);
            this.m_table.getColumn("Queues").setPreferredWidth(55);
            this.m_table.getColumn("Durables").setPreferredWidth(60);
            this.m_table.getColumn("Sessions").setPreferredWidth(60);
            this.m_table.getColumn("Connections").setPreferredWidth(80);
            this.m_table.getColumn("DiskReadRate").setPreferredWidth(90);
            this.m_table.getColumn("DiskWriteRate").setPreferredWidth(90);
            this.m_table.getColumn("RespTime").setPreferredWidth(70);
            if (showEvents) {
                this.m_table.getColumn("Events").setPreferredWidth(55);
            }
        }
        if (n != null) {
            boolean ret = this.findServers(n, false, false, showEvents);
            if (this.m_table.getRowCount() == 0) {
                return true;
            }
            if (Gems.getGems().getShowTotals() && GemsConnectionNode.getConnectionsCount() > 1) {
                if (showEvents) {
                    Object[] r = new String[]{new String("Total"), new String(""), new String(""), new String(""), new String(String.valueOf(this.totals[0])), new String(String.valueOf(this.totals[1])), new String(String.valueOf(this.totals[2])), new String(String.valueOf(this.totals[3])), new String(String.valueOf(this.totals[4])), new String(String.valueOf(this.totals[5])), new String(String.valueOf(this.totals[6])), new String(GemsUtilities.getHumanReadableSize(this.totals[7])), new String(GemsUtilities.getHumanReadableSize(this.totals[8])), new String(String.valueOf(this.totals[12])), new String(String.valueOf(this.totals[14])), new String(GemsUtilities.getHumanReadableSize(this.totals[15])), new String(GemsUtilities.getHumanReadableSize(this.totals[16])), new String(GemsUtilities.getHumanReadableSize(this.totals[9])), new String(GemsUtilities.getHumanReadableSize(this.totals[10])), new String(String.valueOf(this.totals[17]))};
                    this.addRow(r);
                } else {
                    Object[] r = new String[]{new String("Total"), new String(""), new String(""), new String(""), new String(String.valueOf(this.totals[1])), new String(String.valueOf(this.totals[2])), new String(String.valueOf(this.totals[3])), new String(String.valueOf(this.totals[4])), new String(String.valueOf(this.totals[5])), new String(String.valueOf(this.totals[6])), new String(GemsUtilities.getHumanReadableSize(this.totals[7])), new String(GemsUtilities.getHumanReadableSize(this.totals[8])), new String(String.valueOf(this.totals[12])), new String(String.valueOf(this.totals[14])), new String(GemsUtilities.getHumanReadableSize(this.totals[15])), new String(GemsUtilities.getHumanReadableSize(this.totals[16])), new String(GemsUtilities.getHumanReadableSize(this.totals[9])), new String(GemsUtilities.getHumanReadableSize(this.totals[10])), new String(String.valueOf(this.totals[17]))};
                    this.addRow(r);
                }
            }
            this.setupColumnPositions();
            return ret;
        }
        return false;
    }

    public void setupColumnPositions() {
        if (this.m_colPositions == null) {
            return;
        }
        for (int i = 0; i < 22; ++i) {
            if (this.m_colPositions[i] == null) continue;
            int ci = this.m_table.getColumnModel().getColumnIndex(this.m_colPositions[i]);
            this.m_table.moveColumn(ci, i);
        }
    }

    public void initColumnPositions() {
        String colw = Gems.getGems().getServerInfoColPositions();
        if (colw == null || colw.length() == 0) {
            return;
        }
        this.m_colPositions = new String[22];
        for (int i = 0; i < 22; ++i) {
            this.m_colPositions[i] = null;
        }
        String[] colv = colw.split(",");
        for (int i = 0; i < colv.length; ++i) {
            try {
                int x = colv[i].indexOf(58);
                if (x <= 0) continue;
                String p = colv[i].substring(0, x);
                String v = colv[i].substring(x + 1);
                int ci = Integer.valueOf(v);
                if (ci == 0 || p.equals("Alias")) continue;
                if (ci >= 22) {
                    ci = 21;
                }
                this.m_colPositions[ci] = p;
                continue;
            }
            catch (NumberFormatException e) {
                System.err.println("NumberFormatException: " + e.getMessage());
                return;
            }
        }
    }

    public boolean findServers(DefaultMutableTreeNode n, boolean doConnect, boolean forceConnect, boolean showEvents) {
        boolean done = false;
        Enumeration<TreeNode> e = n.children();
        if (e != null) {
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode n1 = (DefaultMutableTreeNode)e.nextElement();
                if (n1 == null) {
                    return done;
                }
                if (n1 instanceof GemsConnectionNode) {
                    GemsConnectionNode cn = (GemsConnectionNode)n1;
                    if (doConnect) {
                        if (!cn.isConnected() && (forceConnect || cn.isAutoConnect() && !cn.isManualDisconnect())) {
                            cn.connect();
                            cn.reconnectToActiveIfStandby();
                            done = true;
                        } else if (cn.getJmsServerInfo(true) == null) {
                            done = true;
                        }
                    } else {
                        ServerInfo s = cn.getJmsServerInfo(false);
                        this.populateServer((String)n1.getUserObject(), s, cn, showEvents);
                    }
                }
                if (!this.findServers(n1, doConnect, forceConnect, showEvents)) continue;
                done = true;
            }
        }
        return done;
    }

    public void populateServer(String name, ServerInfo s, GemsConnectionNode cn, boolean showEvents) {
        if (s == null) {
            String st = "Unknown";
            String ftst = "";
            String sn = "";
            if (cn != null) {
                if (cn.m_stateInfo != null) {
                    st = (cn.m_stateInfo.getState().get() & 4) != 0 ? "Active" : "Standby";
                    sn = cn.m_stateInfo.getServerName();
                    if (cn.m_stateInfo.isAppliance()) {
                        ftst = cn.getInstanceState();
                    }
                } else if (cn.isStandbyMode()) {
                    st = "Standby";
                }
            }
            Object[] r = showEvents ? new GemsCellValue[]{new GemsCellValue(name), new GemsCellValue(st, -1), new GemsCellValue(sn), new GemsCellValue(ftst, -2), new GemsCellValue(""), new GemsCellValue(""), new GemsCellValue(""), new GemsCellValue(""), new GemsCellValue(""), new GemsCellValue(""), new GemsCellValue(""), new GemsCellValue(""), new GemsCellValue(""), new GemsCellValue(""), new GemsCellValue(""), new GemsCellValue(""), new GemsCellValue(""), new GemsCellValue(""), new GemsCellValue(""), new GemsCellValue("")} : new GemsCellValue[]{new GemsCellValue(name), new GemsCellValue(st, -1), new GemsCellValue(sn), new GemsCellValue(ftst, -2), new GemsCellValue(""), new GemsCellValue(""), new GemsCellValue(""), new GemsCellValue(""), new GemsCellValue(""), new GemsCellValue(""), new GemsCellValue(""), new GemsCellValue(""), new GemsCellValue(""), new GemsCellValue(""), new GemsCellValue(""), new GemsCellValue(""), new GemsCellValue(""), new GemsCellValue(""), new GemsCellValue("")};
            this.addRow(r);
            return;
        }
        try {
            Object[] r;
            GemsCellValue ftcv = null;
            if (cn.isAppliance()) {
                String is = cn.getInstanceState();
                ftcv = is != null ? new GemsCellValue(is, -2) : new GemsCellValue("", -2);
            }
            boolean isFt = cn.isServerFt();
            if (ftcv == null) {
                ftcv = isFt && s.getState() == 4 ? (s.getBackupName() == null || s.getBackupName().length() == 0 ? new GemsCellValue("STANDALONE", -2) : new GemsCellValue("FULLY_OPERATIONAL", -2)) : new GemsCellValue("", -2);
            }
            String scs = "?";
            long sc = 0L;
            try {
                scs = String.valueOf(s.getSessionCount());
                sc = s.getSessionCount();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!showEvents) {
                r = new GemsCellValue[]{new GemsCellValue(name), new GemsCellValue(s.getState() == 4 ? "Active" : "Standby", -1), new GemsCellValue(s.getServerName()), ftcv, new GemsCellValue(String.valueOf(s.getConnectionCount()), s.getConnectionCount(), cn.getWarnLimit("Connections"), cn.getErrorLimit("Connections")), new GemsCellValue(scs, sc, cn.getWarnLimit("Sessions"), cn.getErrorLimit("Sessions")), new GemsCellValue(String.valueOf(s.getQueueCount()), s.getQueueCount(), cn.getWarnLimit("Queues"), cn.getErrorLimit("Queues")), new GemsCellValue(String.valueOf(s.getTopicCount()), s.getTopicCount(), cn.getWarnLimit("Topics"), cn.getErrorLimit("Topics")), new GemsCellValue(String.valueOf(s.getDurableCount()), s.getDurableCount(), cn.getWarnLimit("Durables"), cn.getErrorLimit("Durables")), new GemsCellValue(String.valueOf(s.getPendingMessageCount()), s.getPendingMessageCount(), cn.getWarnLimit("PendingMsgs"), cn.getErrorLimit("PendingMsgs")), new GemsCellValue(GemsUtilities.getHumanReadableSize(s.getPendingMessageSize()), s.getPendingMessageSize(), cn.getWarnLimit("PendingMsgSize"), cn.getErrorLimit("PendingMsgSize")), new GemsCellValue(GemsUtilities.getHumanReadableSize(s.getMsgMem()), s.getMsgMem(), cn.getWarnLimit("MsgMem"), cn.getErrorLimit("MsgMem")), new GemsCellValue(String.valueOf(s.getInboundMessageRate()), s.getInboundMessageRate(), cn.getWarnLimit("InMsgRate"), cn.getErrorLimit("InMsgRate")), new GemsCellValue(String.valueOf(s.getOutboundMessageRate()), s.getOutboundMessageRate(), cn.getWarnLimit("OutMsgRate"), cn.getErrorLimit("OutMsgRate")), new GemsCellValue(GemsUtilities.getHumanReadableSize(s.getDiskReadRate()), s.getDiskReadRate(), cn.getWarnLimit("DiskReadRate"), cn.getErrorLimit("DiskReadRate")), new GemsCellValue(GemsUtilities.getHumanReadableSize(s.getDiskWriteRate()), s.getDiskWriteRate(), cn.getWarnLimit("DiskWriteRate"), cn.getErrorLimit("DiskWriteRate")), new GemsCellValue(GemsUtilities.getHumanReadableSize(s.getAsyncDBSize()), s.getAsyncDBSize(), cn.getWarnLimit("AsyncDBSize"), cn.getErrorLimit("AsyncDBSize")), new GemsCellValue(GemsUtilities.getHumanReadableSize(s.getSyncDBSize()), s.getSyncDBSize(), cn.getWarnLimit("SyncDBSize"), cn.getErrorLimit("SyncDBSize")), new GemsCellValue(String.valueOf(cn.getRespTime()), cn.getRespTime(), cn.getWarnLimit("RespTime"), cn.getErrorLimit("RespTime"))};
            } else {
                this.totals[0] = this.totals[0] + (long)cn.getEventCount();
                Long l1 = cn.getWarnLimit("Events");
                Long l2 = cn.getErrorLimit("Events");
                r = new GemsCellValue[]{new GemsCellValue(name), new GemsCellValue(s.getState() == 4 ? "Active" : "Standby", -1), new GemsCellValue(s.getServerName()), ftcv, new GemsCellValue(String.valueOf(cn.getEventCount()), cn.getEventCount(), l1 == null ? new Long(0L) : l1, l2 == null ? new Long(0L) : l2), new GemsCellValue(String.valueOf(s.getConnectionCount()), s.getConnectionCount(), cn.getWarnLimit("Connections"), cn.getErrorLimit("Connections")), new GemsCellValue(scs, sc, cn.getWarnLimit("Sessions"), cn.getErrorLimit("Sessions")), new GemsCellValue(String.valueOf(s.getQueueCount()), s.getQueueCount(), cn.getWarnLimit("Queues"), cn.getErrorLimit("Queues")), new GemsCellValue(String.valueOf(s.getTopicCount()), s.getTopicCount(), cn.getWarnLimit("Topics"), cn.getErrorLimit("Topics")), new GemsCellValue(String.valueOf(s.getDurableCount()), s.getDurableCount(), cn.getWarnLimit("Durables"), cn.getErrorLimit("Durables")), new GemsCellValue(String.valueOf(s.getPendingMessageCount()), s.getPendingMessageCount(), cn.getWarnLimit("PendingMsgs"), cn.getErrorLimit("PendingMsgs")), new GemsCellValue(GemsUtilities.getHumanReadableSize(s.getPendingMessageSize()), s.getPendingMessageSize(), cn.getWarnLimit("PendingMsgSize"), cn.getErrorLimit("PendingMsgSize")), new GemsCellValue(GemsUtilities.getHumanReadableSize(s.getMsgMem()), s.getMsgMem(), cn.getWarnLimit("MsgMem"), cn.getErrorLimit("MsgMem")), new GemsCellValue(String.valueOf(s.getInboundMessageRate()), s.getInboundMessageRate(), cn.getWarnLimit("InMsgRate"), cn.getErrorLimit("InMsgRate")), new GemsCellValue(String.valueOf(s.getOutboundMessageRate()), s.getOutboundMessageRate(), cn.getWarnLimit("OutMsgRate"), cn.getErrorLimit("OutMsgRate")), new GemsCellValue(String.valueOf(s.getDiskReadRate()), s.getDiskReadRate(), cn.getWarnLimit("DiskReadRate"), cn.getErrorLimit("DiskReadRate")), new GemsCellValue(String.valueOf(s.getDiskWriteRate()), s.getDiskWriteRate(), cn.getWarnLimit("DiskWriteRate"), cn.getErrorLimit("DiskWriteRate")), new GemsCellValue(GemsUtilities.getHumanReadableSize(s.getAsyncDBSize()), s.getAsyncDBSize(), cn.getWarnLimit("AsyncDBSize"), cn.getErrorLimit("AsyncDBSize")), new GemsCellValue(GemsUtilities.getHumanReadableSize(s.getSyncDBSize()), s.getSyncDBSize(), cn.getWarnLimit("SyncDBSize"), cn.getErrorLimit("SyncDBSize")), new GemsCellValue(String.valueOf(cn.getRespTime()), cn.getRespTime(), cn.getWarnLimit("RespTime"), cn.getErrorLimit("RespTime"))};
            }
            if (Gems.getGems().getShowTotals()) {
                this.totals[1] = this.totals[1] + (long)s.getConnectionCount();
                this.totals[2] = this.totals[2] + sc;
                this.totals[3] = this.totals[3] + (long)s.getQueueCount();
                this.totals[4] = this.totals[4] + (long)s.getTopicCount();
                this.totals[5] = this.totals[5] + (long)s.getDurableCount();
                this.totals[6] = this.totals[6] + s.getPendingMessageCount();
                this.totals[7] = this.totals[7] + s.getPendingMessageSize();
                this.totals[8] = this.totals[8] + s.getMsgMem();
                this.totals[9] = this.totals[9] + s.getAsyncDBSize();
                this.totals[10] = this.totals[10] + s.getSyncDBSize();
                this.totals[12] = this.totals[12] + s.getInboundMessageRate();
                this.totals[14] = this.totals[14] + s.getOutboundMessageRate();
                this.totals[15] = this.totals[15] + s.getDiskReadRate();
                this.totals[16] = this.totals[16] + s.getDiskWriteRate();
                this.totals[17] = this.totals[17] + cn.getRespTime();
            }
            this.addRow(r);
        }
        catch (Exception e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    class MyRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            cell.setForeground(Color.black);
            if (value instanceof GemsCellValue) {
                GemsCellValue v = (GemsCellValue)value;
                this.setText(v.toString());
                if (v.m_value < -2L) {
                    this.setHorizontalAlignment(2);
                    cell.setBackground(Color.white);
                } else if (v.m_value == -1L) {
                    this.setHorizontalAlignment(2);
                    if (v.m_cellValue.equals("Active")) {
                        cell.setBackground(Color.green);
                    } else if (v.m_cellValue.equals("Standby")) {
                        cell.setBackground(Color.yellow);
                    } else if (v.m_cellValue.equals("Unknown")) {
                        cell.setBackground(Color.red);
                    } else {
                        cell.setBackground(Color.white);
                    }
                } else if (v.m_value == -2L) {
                    this.setHorizontalAlignment(2);
                    cell.setBackground(Color.white);
                    if (v.m_cellValue != null && (v.m_cellValue.equals("FULLY_OPERATIONAL") || v.m_cellValue.equals("REPLICATING"))) {
                        cell.setBackground(Color.green);
                    } else if (v.m_cellValue != null && v.m_cellValue.equals("ERROR")) {
                        cell.setBackground(Color.red);
                    } else if (v.m_cellValue != null && v.m_cellValue.length() > 0) {
                        cell.setBackground(Color.orange);
                    }
                } else {
                    this.setHorizontalAlignment(4);
                    if (v.m_errorLimit != null && v.m_value > v.m_errorLimit) {
                        cell.setBackground(Color.red);
                    } else if (v.m_warnLimit != null && v.m_value > v.m_warnLimit) {
                        cell.setBackground(Color.orange);
                    } else {
                        cell.setBackground(Color.white);
                    }
                }
            } else if (value instanceof String) {
                if (column > 3) {
                    this.setHorizontalAlignment(4);
                } else {
                    this.setHorizontalAlignment(2);
                }
                cell.setBackground(Color.cyan);
            }
            return cell;
        }
    }
}

