/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsServiceTable;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public class GemsService {
    public String m_name = null;
    public String m_reqDest = null;
    public String m_respDest = null;
    public long m_hits = 0L;
    public long m_responses = 0L;
    public long m_totalLatency = 0L;
    public long m_minLatency = 0L;
    public long m_maxLatency = 0L;
    public long m_faults = 0L;
    public long m_started = 0L;
    public long m_totalReqSize = 0L;
    public long m_minReqSize = 0L;
    public long m_maxReqSize = 0L;
    public long m_totalRespSize = 0L;
    public long m_minRespSize = 0L;
    public long m_maxRespSize = 0L;
    public long m_respLimit = 0L;
    public long m_overLimitCount = 0L;
    public long m_lastRequest = 0L;
    public boolean m_reqIsQueue = true;
    public boolean m_respIsQueue = true;
    protected TopicSubscriber m_reqsub = null;
    protected TopicSubscriber m_respsub = null;
    protected GemsServiceTable m_table = null;
    public Hashtable m_requests = new Hashtable();
    protected boolean m_useCache = true;
    protected int m_cacheIndex = 0;
    public Hashtable m_cacheResp = null;
    public cacheResp[] m_cacheRespArray = null;

    public GemsService(String name, String reqDest, boolean reqIsQueue, String respDest, boolean respIsQueue, long respLimit, GemsServiceTable table) {
        this.m_reqIsQueue = reqIsQueue;
        this.m_respIsQueue = respIsQueue;
        this.m_respLimit = respLimit;
        if (this.m_useCache) {
            this.m_cacheResp = new Hashtable();
            this.m_cacheRespArray = new cacheResp[500];
            this.m_cacheIndex = 0;
        }
        this.m_name = name;
        this.m_reqDest = reqIsQueue ? "$sys.monitor.q.r." + reqDest : "$sys.monitor.t.r." + reqDest;
        if (respDest != null && respDest.length() > 0) {
            this.m_respDest = respIsQueue ? "$sys.monitor.q.r." + respDest : "$sys.monitor.t.r." + respDest;
        }
        this.m_started = System.currentTimeMillis();
        this.m_table = table;
        Gems.debug("GemsService: " + name + " " + this.m_reqDest + " " + this.m_respDest);
    }

    public synchronized void reset() {
        this.m_hits = 0L;
        this.m_responses = 0L;
        this.m_totalLatency = 0L;
        this.m_minLatency = 0L;
        this.m_maxLatency = 0L;
        this.m_faults = 0L;
        this.m_totalReqSize = 0L;
        this.m_minReqSize = 0L;
        this.m_maxReqSize = 0L;
        this.m_totalRespSize = 0L;
        this.m_minRespSize = 0L;
        this.m_maxRespSize = 0L;
        this.m_overLimitCount = 0L;
        this.m_lastRequest = 0L;
        this.m_started = System.currentTimeMillis();
        this.m_requests.clear();
        this.m_cacheResp.clear();
    }

    public synchronized void addToCache(String cid, long t) {
        cacheResp cr = this.m_cacheRespArray[this.m_cacheIndex];
        if (cr != null) {
            cacheResp cr1 = null;
            if (cr.m_cid != null && cr.m_cid.length() > 0) {
                cr1 = (cacheResp)this.m_cacheResp.remove(cr.m_cid);
            }
            if (cr1 != null) {
                Gems.debug("GemsService.addToCache: Warning cache full, removed:  " + cr1.m_cid + " " + cr1.m_timestamp + " " + this.m_cacheIndex);
            }
        }
        this.m_cacheRespArray[this.m_cacheIndex] = new cacheResp(cid, t);
        this.m_cacheResp.put(cid, this.m_cacheRespArray[this.m_cacheIndex]);
        if (++this.m_cacheIndex >= this.m_cacheRespArray.length) {
            this.m_cacheIndex = 0;
        }
    }

    public synchronized void newRequest(long t1, long msgSize) {
        ++this.m_hits;
        if (msgSize < this.m_minReqSize) {
            this.m_minReqSize = msgSize;
        }
        if (msgSize > this.m_maxReqSize) {
            this.m_maxReqSize = msgSize;
        }
        this.m_totalReqSize += msgSize;
        this.m_lastRequest = t1;
    }

    public synchronized void newResponse(long t1, long t2, long msgSize) {
        if (t2 < t1) {
            Gems.debug("GemsService:newResponse: Error response timestamp before request");
            return;
        }
        long latency = t2 - t1;
        ++this.m_responses;
        if (latency < this.m_minLatency) {
            this.m_minLatency = latency;
        }
        if (latency > this.m_maxLatency) {
            this.m_maxLatency = latency;
        }
        this.m_totalLatency += latency;
        if (msgSize < this.m_minRespSize) {
            this.m_minRespSize = msgSize;
        }
        if (msgSize > this.m_maxRespSize) {
            this.m_maxRespSize = msgSize;
        }
        this.m_totalRespSize += msgSize;
        if (latency > this.m_respLimit) {
            ++this.m_overLimitCount;
        }
    }

    public synchronized void start(TopicSession reqSess, TopicSession respSess) {
        try {
            Gems.debug("GemsService:start " + this.m_name);
            Topic t = reqSess.createTopic(this.m_reqDest);
            this.m_reqsub = reqSess.createSubscriber(t);
            this.m_reqsub.setMessageListener((MessageListener)new OnReqMessage());
            if (this.m_respDest != null && this.m_respDest.length() > 0) {
                t = reqSess.createTopic(this.m_respDest);
                this.m_respsub = reqSess.createSubscriber(t);
                this.m_respsub.setMessageListener((MessageListener)new OnRespMessage());
            }
        }
        catch (Exception e) {
            Gems.debug("GemsService.start: Exception: " + e.getMessage());
        }
    }

    public synchronized void stop() {
        try {
            if (this.m_reqsub != null) {
                this.m_reqsub.close();
                this.m_reqsub = null;
            }
            if (this.m_respsub != null) {
                this.m_respsub.close();
                this.m_respsub = null;
            }
        }
        catch (Exception e) {
            Gems.debug("GemsService.stop: Exception: " + e.getMessage());
        }
    }

    class OnRespMessage
    implements MessageListener {
        OnRespMessage() {
        }

        public void onMessage(Message msg) {
            try {
                String cid = msg.getStringProperty("msg_correlation_id");
                if (cid == null || cid.length() == 0) {
                    Gems.debug("GemsService.onRespMessage: No correlationID ");
                    return;
                }
                long t2 = msg.getLongProperty("msg_timestamp");
                Long t1 = (Long)GemsService.this.m_requests.remove(cid);
                if (t1 == null) {
                    if (GemsService.this.m_useCache) {
                        GemsService.this.addToCache(cid, t2);
                        return;
                    }
                    Gems.debug("GemsService.onRespMessage: No request found for CID: " + cid);
                }
                GemsService.this.newResponse(t1, t2, 0L);
            }
            catch (JMSException jMSException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    class OnReqMessage
    implements MessageListener {
        OnReqMessage() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(Message msg) {
            block19: {
                try {
                    if (!msg.propertyExists("msg_timestamp")) {
                        Gems.debug("GemsService.onReqMessage: No msg_timestamp!");
                        return;
                    }
                    long t1 = msg.getLongProperty("msg_timestamp");
                    String cid = msg.getStringProperty("msg_correlation_id");
                    String rpt = msg.getStringProperty("replyTo");
                    if (rpt == null || rpt.length() == 0) {
                        Gems.debug("GemsServiceTable.onReqMessage: No replyTo");
                        return;
                    }
                    if (rpt.startsWith("$TMP$")) {
                        if (cid == null || cid.length() == 0) {
                            cid = rpt;
                        }
                        Object object = GemsService.this.m_table.m_lock;
                        synchronized (object) {
                            if (GemsService.this.m_table.m_useCache) {
                                GemsServiceTable.cacheResp cr = (GemsServiceTable.cacheResp)GemsService.this.m_table.m_cacheResp.remove(cid);
                                if (cr == null && cid != rpt) {
                                    cr = (GemsServiceTable.cacheResp)GemsService.this.m_table.m_cacheResp.remove(rpt);
                                }
                                if (cr != null) {
                                    GemsService.this.newRequest(t1, 0L);
                                    GemsService.this.newResponse(t1, cr.m_timestamp, 0L);
                                    return;
                                }
                            }
                            GemsService.this.m_table.newSyncRequest(GemsService.this, cid, t1);
                            GemsService.this.newRequest(t1, 0L);
                            break block19;
                        }
                    }
                    if (cid == null || cid.length() == 0) {
                        String mid = msg.getStringProperty("msg_id");
                        Gems.debug("GemsServiceTable.onReqMessage: No correlationId using MsgId");
                        if (mid != null && mid.length() > 0) {
                            cid = mid;
                        } else {
                            Gems.debug("GemsServiceTable.onReqMessage: No correlationId or MsgId");
                            return;
                        }
                    }
                    if (GemsService.this.m_useCache) {
                        cacheResp cr = (cacheResp)GemsService.this.m_cacheResp.remove(cid);
                        if (cr == null) {
                            cr = (cacheResp)GemsService.this.m_cacheResp.remove(cid);
                        }
                        if (cr != null) {
                            GemsService.this.newRequest(t1, 0L);
                            GemsService.this.newResponse(t1, cr.m_timestamp, 0L);
                            return;
                        }
                    }
                    GemsService.this.m_requests.put(cid, new Long(t1));
                    GemsService.this.newRequest(t1, 0L);
                }
                catch (JMSException e) {
                    Gems.debug("GemsService.onReqMessage: Exception: " + e.toString());
                }
                catch (NumberFormatException f) {
                    Gems.debug("GemsService.onReqMessage: Exception: " + f.toString());
                }
            }
        }
    }

    class cacheResp {
        String m_cid;
        long m_timestamp;

        public cacheResp(String cid, long t) {
            this.m_timestamp = t;
            this.m_cid = cid;
        }
    }

    class request {
        long m_timestamp;
        String m_cid;

        public request(long t, String c) {
            this.m_timestamp = t;
            this.m_cid = c;
        }
    }
}

