/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsService;
import com.tibco.tibjms.TibjmsTopicConnectionFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public class GemsServiceTable
implements ActionListener {
    public Hashtable m_services = new Hashtable();
    public boolean m_running = false;
    public boolean m_enabled = false;
    public long m_period;
    public boolean m_useQTemps;
    boolean m_useTTemps;
    protected PeriodThread m_timer = null;
    protected GemsConnectionNode m_cn;
    protected TopicSession m_reqSess = null;
    protected TopicSession m_respSess = null;
    protected TopicConnection m_connection = null;
    protected TopicSubscriber m_tempQueueSubscriber = null;
    protected TopicSubscriber m_tempTopicSubscriber = null;
    protected Random m_random = new Random();
    protected boolean m_useCache = true;
    protected int m_cacheIndex = 0;
    public Object m_lock = new Object();
    public Hashtable m_syncRequests = new Hashtable();
    public Hashtable m_cacheResp = null;
    public cacheResp[] m_cacheRespArray = null;

    public GemsServiceTable(GemsConnectionNode cn, long period, boolean useTempQueues, boolean useTempTopics, boolean enabled) {
        this.m_cn = cn;
        this.m_period = period;
        this.m_useQTemps = useTempQueues;
        this.m_useTTemps = useTempTopics;
        this.m_enabled = enabled;
        if (this.m_useCache) {
            this.m_cacheResp = new Hashtable();
            this.m_cacheRespArray = new cacheResp[1000];
            this.m_cacheIndex = 0;
        }
    }

    public synchronized void addToCache(String tar, String cid, long t) {
        cacheResp cr = this.m_cacheRespArray[this.m_cacheIndex];
        if (cr != null) {
            cacheResp cr1 = null;
            if (cr.m_cid != null && cr.m_cid.length() > 0) {
                cr1 = (cacheResp)this.m_cacheResp.remove(cr.m_cid);
            }
            if (cr1 == null && cr.m_target != null && cr.m_target.length() > 0) {
                cr1 = (cacheResp)this.m_cacheResp.remove(cr.m_target);
            }
            if (cr1 != null) {
                Gems.debug("GemsService.addToCache: Warning cache full, removed: " + cr1.m_target + " " + cr1.m_cid + " " + cr1.m_timestamp + " " + this.m_cacheIndex);
            }
        }
        this.m_cacheRespArray[this.m_cacheIndex] = new cacheResp(tar, cid, t);
        if (cid != null && cid.length() > 0) {
            this.m_cacheResp.put(cid, this.m_cacheRespArray[this.m_cacheIndex]);
        } else {
            this.m_cacheResp.put(tar, this.m_cacheRespArray[this.m_cacheIndex]);
        }
        if (++this.m_cacheIndex >= this.m_cacheRespArray.length) {
            this.m_cacheIndex = 0;
        }
    }

    public synchronized void systemStart() {
        if (this.m_enabled) {
            this.userStart();
        }
    }

    public synchronized void userStart() {
        this.stopServices();
        this.reset();
        if (this.m_timer != null) {
            this.m_timer.interrupt();
        }
        this.m_timer = new PeriodThread(this.m_period * 60000L);
        this.m_timer.start();
    }

    public synchronized void systemStop(boolean force) {
        if (force) {
            this.m_running = false;
            if (this.m_timer != null) {
                this.m_timer.interrupt();
            }
            this.m_reqSess = null;
            this.m_respSess = null;
            this.m_connection = null;
            this.m_timer = null;
            this.reset();
        } else {
            this.userStop();
        }
    }

    public synchronized void userStop() {
        this.m_running = false;
        this.stopServices();
        this.reset();
        if (this.m_timer != null) {
            this.m_timer.interrupt();
        }
        this.m_timer = null;
    }

    public synchronized void reset() {
        Enumeration e = this.m_services.keys();
        while (e.hasMoreElements()) {
            GemsService s = (GemsService)this.m_services.get(e.nextElement());
            s.reset();
        }
        this.m_syncRequests.clear();
        this.m_cacheResp.clear();
    }

    public synchronized void startServices() {
        if (this.m_services.size() == 0) {
            Gems.debug("GemsServiceTable:startServices: No services found");
            return;
        }
        try {
            Topic t;
            Gems.debug("GemsServiceTable:startServices: Connecting to: " + this.m_cn.m_url);
            TibjmsTopicConnectionFactory factory = new TibjmsTopicConnectionFactory(this.m_cn.m_url, null, this.m_cn.m_sslParams);
            this.m_connection = factory.createTopicConnection(this.m_cn.m_user, this.m_cn.m_password);
            this.m_reqSess = this.m_connection.createTopicSession(false, 22);
            this.m_respSess = this.m_connection.createTopicSession(false, 22);
            boolean useQTemps = false;
            boolean useTTemps = false;
            Enumeration e = this.m_services.keys();
            while (e.hasMoreElements()) {
                GemsService s = (GemsService)this.m_services.get(e.nextElement());
                s.start(this.m_reqSess, this.m_respSess);
            }
            if (this.m_useQTemps) {
                t = this.m_reqSess.createTopic("$sys.monitor.q.r.$TMP$.>");
                this.m_tempQueueSubscriber = this.m_respSess.createSubscriber(t);
                this.m_tempQueueSubscriber.setMessageListener((MessageListener)new OnSyncRespMessage());
                Gems.debug("GemsServiceTable:startServices: Adding queue $TMP$.>");
            }
            if (this.m_useTTemps) {
                t = this.m_reqSess.createTopic("$sys.monitor.t.r.$TMP$.>");
                this.m_tempTopicSubscriber = this.m_respSess.createSubscriber(t);
                this.m_tempTopicSubscriber.setMessageListener((MessageListener)new OnSyncRespMessage());
                Gems.debug("GemsServiceTable:startServices: Adding topic $TMP$.>");
            }
            this.m_connection.start();
        }
        catch (JMSException e) {
            Gems.debug("GemsServiceTable:startServices: Exception: " + e.getMessage());
            return;
        }
    }

    public synchronized void stopServices() {
        try {
            if (this.m_connection == null) {
                return;
            }
            this.m_connection.stop();
            Enumeration e = this.m_services.keys();
            while (e.hasMoreElements()) {
                GemsService s = (GemsService)this.m_services.get(e.nextElement());
                s.stop();
            }
            if (this.m_reqSess != null) {
                this.m_reqSess.close();
                this.m_reqSess = null;
            }
            if (this.m_respSess != null) {
                this.m_respSess.close();
                this.m_respSess = null;
            }
            this.m_connection.close();
            this.m_connection = null;
        }
        catch (Exception e) {
            Gems.debug("GemsServiceTable:stop: Exception: " + e.toString());
            return;
        }
    }

    public synchronized void addService(String name, String reqDest, boolean reqIsQueue, String respDest, boolean respIsQueue, long respLimit) {
        this.m_services.put(name, new GemsService(name, reqDest, reqIsQueue, respDest, respIsQueue, respLimit, this));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.reset();
    }

    public synchronized void newSyncRequest(GemsService service, String id, long timestamp) {
        this.m_syncRequests.put(id, new syncRequest(service, timestamp));
    }

    class OnSyncRespMessage
    implements MessageListener {
        OnSyncRespMessage() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(Message msg) {
            try {
                String cid = msg.getStringProperty("msg_correlation_id");
                String tar = msg.getStringProperty("target_dest_name");
                long t2 = msg.getLongProperty("msg_timestamp");
                if (t2 == 0L) {
                    return;
                }
                if (tar == null || !tar.startsWith("$TMP$")) {
                    Gems.debug("GemsServiceTable.onSyncRespMessage: No $TMP target");
                    return;
                }
                Object object = GemsServiceTable.this.m_lock;
                synchronized (object) {
                    syncRequest sr = null;
                    if (cid != null && cid.length() > 0) {
                        sr = (syncRequest)GemsServiceTable.this.m_syncRequests.remove(cid);
                    }
                    if (sr == null && tar != null && tar.length() > 0) {
                        sr = (syncRequest)GemsServiceTable.this.m_syncRequests.remove(tar);
                    }
                    if (sr != null) {
                        sr.m_service.newResponse(sr.m_timestamp, t2, 0L);
                    } else if (GemsServiceTable.this.m_useCache) {
                        GemsServiceTable.this.addToCache(tar, cid, t2);
                    }
                }
            }
            catch (JMSException jMSException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    class PeriodThread
    extends Thread {
        long m_delay;

        PeriodThread(long delay) {
            this.m_delay = delay;
        }

        @Override
        public void run() {
            GemsServiceTable.this.m_running = true;
            try {
                PeriodThread.sleep(2000 + GemsServiceTable.this.m_random.nextInt(5000));
            }
            catch (Exception ie) {
                Gems.debug("PeriodThread.Exception: " + ie.getMessage());
                return;
            }
            GemsServiceTable.this.startServices();
            while (this.m_delay > 0L && GemsServiceTable.this.m_running) {
                try {
                    PeriodThread.sleep(this.m_delay);
                    if (!GemsServiceTable.this.m_running) continue;
                    GemsServiceTable.this.reset();
                }
                catch (Exception ie) {
                    Gems.debug("PeriodThread.Exception: " + ie.getMessage());
                    return;
                }
            }
        }
    }

    class cacheResp {
        String m_cid;
        String m_target;
        long m_timestamp;

        public cacheResp(String tar, String cid, long t) {
            this.m_target = tar;
            this.m_timestamp = t;
            this.m_cid = cid;
        }
    }

    class syncRequest {
        long m_timestamp;
        GemsService m_service;

        public syncRequest(GemsService s, long t) {
            this.m_timestamp = t;
            this.m_service = s;
        }
    }
}

