/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.GemsProperty;
import com.tibco.gems.GemsUtilities;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public class GemsSetPropDialog
extends JDialog {
    protected JComboBox m_props = null;
    protected JTextField m_prop = null;
    protected JTextField m_type = null;
    protected JTextField m_value = null;
    protected JLabel m_help = null;
    protected boolean m_simple = false;
    protected boolean m_password = false;
    protected boolean m_cancelled = true;
    protected String m_selProp = null;
    protected Hashtable m_propList = null;
    Comparator<GemsProperty> propertyComparator = new Comparator<GemsProperty>(){

        @Override
        public int compare(GemsProperty p1, GemsProperty p2) {
            return p1.getName().compareTo(p2.getName());
        }
    };

    public GemsSetPropDialog(Frame frame, String title) {
        super(frame, title, true);
        this.init();
        if (frame != null) {
            this.setLocationRelativeTo(frame);
        }
    }

    public GemsSetPropDialog(Dialog frame, String title, boolean simple, boolean password) {
        super(frame, title, true);
        this.m_simple = simple;
        this.m_password = password;
        this.init();
        if (frame != null) {
            this.setLocationRelativeTo(frame);
        }
    }

    void init() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel spanel = new JPanel(new SpringLayout(), true);
        mainPanel.add(spanel);
        JLabel l1 = new JLabel("Property:", 11);
        if (!this.m_simple) {
            this.m_props = new JComboBox();
            this.m_props.addActionListener(new PropSelected());
            l1.setLabelFor(this.m_props);
            spanel.add(l1);
            spanel.add(this.m_props);
            if (!this.m_password) {
                JLabel l2 = new JLabel("Type:", 11);
                this.m_type = new JTextField("", 28);
                this.m_type.setEditable(false);
                l2.setLabelFor(this.m_type);
                spanel.add(l2);
                spanel.add(this.m_type);
            } else {
                l1.setText("User:");
            }
        } else {
            this.m_prop = new JTextField();
            this.m_prop.setEditable(false);
            l1.setLabelFor(this.m_prop);
            spanel.add(l1);
            spanel.add(this.m_prop);
        }
        JLabel l3 = new JLabel("Value:", 11);
        this.m_value = this.m_password ? new JPasswordField(30) : new JTextField("", 40);
        l3.setLabelFor(this.m_value);
        spanel.add(l3);
        spanel.add(this.m_value);
        JLabel l4 = new JLabel("<html><br><br><br></html>");
        spanel.add(l4);
        this.m_help = new JLabel("");
        l4.setLabelFor(this.m_help);
        spanel.add(this.m_help);
        GemsUtilities.makeCompactGrid(spanel, this.m_simple || this.m_password ? 3 : 4, 2, 5, 5, 5, 5);
        JPanel holdbut = new JPanel();
        holdbut.setLayout(new FlowLayout());
        JButton a3 = new JButton("OK ");
        JButton b3 = new JButton("Cancel ");
        holdbut.add(a3);
        holdbut.add(b3);
        a3.addActionListener(new OkPressed());
        b3.addActionListener(new CancelPressed());
        mainPanel.add(holdbut);
        this.setContentPane(mainPanel);
    }

    public String getValue(Hashtable props, String prop, String val, boolean sort) {
        this.m_propList = props;
        if (sort) {
            ArrayList al = new ArrayList(props.values());
            GemsProperty[] arr = al.toArray(new GemsProperty[al.size()]);
            Arrays.sort(arr, this.propertyComparator);
            for (int i = 0; i < arr.length; ++i) {
                this.m_props.addItem(arr[i].getName());
            }
        } else {
            Enumeration pe = props.keys();
            while (pe.hasMoreElements()) {
                this.m_props.addItem((String)pe.nextElement());
            }
        }
        if (prop != null) {
            this.m_props.setSelectedItem(prop);
            GemsProperty p = (GemsProperty)props.get(prop);
            if (p != null) {
                if (this.m_type != null) {
                    this.m_type.setText(p.type.getName());
                }
                this.m_help.setText(p.help);
            }
        }
        this.m_selProp = (String)this.m_props.getSelectedItem();
        if (val != null) {
            this.m_value.setText(val);
        }
        this.pack();
        this.show();
        if (this.m_cancelled) {
            return null;
        }
        return this.m_value.getText();
    }

    public String getValue(Hashtable props, String prop, String val) {
        return this.getValue(props, prop, val, false);
    }

    public String getValue(GemsProperty prop, String val) {
        this.m_prop.setText(prop.getName());
        this.m_help.setText(prop.help);
        this.m_selProp = prop.getName();
        if (!this.m_password) {
            if (val != null) {
                this.m_value.setText(val);
            } else {
                this.m_value.setText(prop.getDefValue());
            }
        }
        this.pack();
        this.show();
        if (this.m_cancelled) {
            return null;
        }
        return this.m_value.getText();
    }

    public String getSelectedProp() {
        return this.m_selProp;
    }

    class CancelPressed
    implements ActionListener {
        CancelPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsSetPropDialog.this.m_cancelled = true;
            GemsSetPropDialog.this.dispose();
        }
    }

    class OkPressed
    implements ActionListener {
        OkPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsSetPropDialog.this.m_cancelled = false;
            GemsSetPropDialog.this.dispose();
        }
    }

    class PropSelected
    implements ActionListener {
        PropSelected() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GemsSetPropDialog.this.m_propList != null) {
                GemsSetPropDialog.this.m_selProp = (String)GemsSetPropDialog.this.m_props.getSelectedItem();
                GemsProperty p = (GemsProperty)GemsSetPropDialog.this.m_propList.get(GemsSetPropDialog.this.m_selProp);
                GemsSetPropDialog.this.m_value.setText("");
                if (p != null) {
                    if (GemsSetPropDialog.this.m_type != null) {
                        GemsSetPropDialog.this.m_type.setText(p.type.getName());
                    }
                    GemsSetPropDialog.this.m_help.setText(p.help);
                } else {
                    if (GemsSetPropDialog.this.m_type != null) {
                        GemsSetPropDialog.this.m_type.setText("");
                    }
                    GemsSetPropDialog.this.m_help.setText("");
                }
                GemsSetPropDialog.this.invalidate();
            }
        }
    }
}

