/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.plaf.metal.MetalIconFactory;

class GemsTextIcons
extends MetalIconFactory.TreeLeafIcon {
    protected String label;
    private static Hashtable labels;
    private Color foreground = null;

    protected GemsTextIcons() {
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        super.paintIcon(c, g, x, y);
        if (this.label != null) {
            g.setFont(c.getFont());
            if (this.foreground == null) {
                this.foreground = c.getForeground();
            }
            g.setColor(this.foreground);
            FontMetrics fm = g.getFontMetrics();
            int offsetX = (this.getIconWidth() - fm.stringWidth(this.label)) / 2;
            int offsetY = (this.getIconHeight() - fm.getHeight()) / 2 - 2;
            g.drawString(this.label, x + offsetX, y + offsetY + fm.getHeight());
        }
    }

    public static Icon getIcon(String str) {
        if (labels == null) {
            labels = new Hashtable();
            GemsTextIcons.setDefaultSet();
        }
        GemsTextIcons icon = new GemsTextIcons();
        icon.label = (String)labels.get(str);
        return icon;
    }

    public static void setLabelSet(String ext, String label) {
        if (labels == null) {
            labels = new Hashtable();
            GemsTextIcons.setDefaultSet();
        }
        labels.put(ext, label);
    }

    private static void setDefaultSet() {
        labels.put("queue", "Q");
        labels.put("topic", "T");
        labels.put("routedqueue", "q");
    }
}

