/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsBrowserOptionsDialog;
import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsDestination;
import com.tibco.gems.GemsDestinationPicker;
import com.tibco.gems.GemsMessageFrame;
import com.tibco.gems.GemsMessageTableModel;
import com.tibco.gems.GemsMonitorMessageTableModel;
import com.tibco.gems.GemsUtilities;
import com.tibco.gems.TableSorter;
import com.tibco.tibjms.Tibjms;
import com.tibco.tibjms.TibjmsTopicConnectionFactory;
import com.tibco.tibjms.admin.TibjmsAdmin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.Timer;
import javax.swing.text.DefaultEditorKit;

public class GemsTopicSubscriber
extends JFrame {
    JFrame m_frame;
    JPanel m_panel;
    boolean m_running = false;
    int m_msgs = 0;
    int m_maxMsgs = 10;
    Message m_msg = null;
    TibjmsAdmin m_admin = null;
    TopicSession m_session = null;
    GemsConnectionNode m_cn;
    TopicConnection m_connection = null;
    TopicSubscriber m_subscriber = null;
    Timer m_timer = new Timer(Gems.getGems().getMsgReadDelay(), new RefreshTimerAction());
    protected JTextField m_conn;
    protected JTextField m_topic;
    protected JButton m_destwiz;
    protected JTextField m_msgsRead;
    protected JTextField m_msgsDisplay;
    protected JTextField m_selector;
    protected JButton m_startButton;
    protected JButton m_stopButton;
    protected JCheckBox m_noLimit;
    JTable m_table;
    protected GemsMessageTableModel m_tableModel;
    protected boolean m_viewoldestFirst = Gems.getGems().getViewOldMessagesFirst();
    protected JMenuItem m_optMenuItem;
    protected JMenuItem m_dumpMenuItem;
    TableSorter m_sorter;
    protected boolean m_isMonitor = false;

    public GemsTopicSubscriber(GemsConnectionNode cn, String topic, String title) {
        super(Gems.getGems().getTitlePrefix() + title);
        this.setLocation(400, 175);
        this.setDefaultCloseOperation(2);
        this.m_frame = this;
        this.m_cn = cn;
        if (topic == null) {
            topic = new String();
        }
        if (topic.startsWith("$sys.monitor")) {
            this.m_isMonitor = true;
            this.m_tableModel = new GemsMonitorMessageTableModel(false, false);
        } else {
            this.m_tableModel = new GemsMessageTableModel(false, false);
        }
        JMenuBar menuBar = this.constructMenuBar();
        this.setJMenuBar(menuBar);
        JPanel m_panel = new JPanel(true);
        m_panel.setLayout(new BorderLayout());
        this.getContentPane().add("Center", m_panel);
        JPanel panel = new JPanel(new SpringLayout(), true);
        m_panel.add((Component)panel, "North");
        JLabel l1 = new JLabel("Server:", 11);
        this.m_conn = new JTextField(cn.getName(), 20);
        this.m_conn.setEditable(false);
        this.m_conn.setMaximumSize(new Dimension(0, 24));
        l1.setLabelFor(this.m_conn);
        panel.add(l1);
        panel.add(this.m_conn);
        JPanel qpanel = new JPanel(true);
        qpanel.setLayout(new BoxLayout(qpanel, 0));
        JLabel l2 = new JLabel("Topic Name:", 11);
        this.m_topic = new JTextField(topic, 20);
        if (this.m_isMonitor) {
            this.m_topic.setEnabled(false);
        }
        if (cn.getTopicNamePattern().length() > 1 && Gems.getGems().getViewOnlyMode()) {
            this.m_topic.setEditable(false);
        }
        l2.setLabelFor(this.m_topic);
        panel.add(l2);
        qpanel.add(this.m_topic);
        this.m_destwiz = new JButton("...");
        this.m_destwiz.setPreferredSize(new Dimension(18, 16));
        this.m_destwiz.addActionListener(new DestinationWizardAction());
        if (this.m_isMonitor) {
            this.m_destwiz.setEnabled(false);
        }
        qpanel.add(this.m_destwiz);
        panel.add(qpanel);
        JLabel l5 = new JLabel("Selector:", 11);
        this.m_selector = new JTextField("", 20);
        l5.setLabelFor(this.m_selector);
        panel.add(l5);
        panel.add(this.m_selector);
        JPanel mpanel = new JPanel(true);
        mpanel.setLayout(new BoxLayout(mpanel, 0));
        JLabel l9 = this.m_isMonitor ? new JLabel("Events to Read:", 11) : new JLabel("Msgs to Read:", 11);
        this.m_msgsRead = new JTextField("10", 20);
        this.m_msgsRead.setMinimumSize(new Dimension(40, 24));
        l9.setLabelFor(this.m_msgsRead);
        panel.add(l9);
        panel.add(this.m_msgsRead);
        this.m_noLimit = new JCheckBox("No Limit", false);
        this.m_sorter = new TableSorter(this.m_tableModel);
        this.m_table = new JTable(this.m_sorter);
        this.m_table.getTableHeader().setReorderingAllowed(false);
        this.m_sorter.setTableHeader(this.m_table.getTableHeader());
        this.m_table.setSelectionMode(0);
        this.m_tableModel.m_table = this.m_table;
        this.addMouseListenerToTable(this.m_table);
        JScrollPane spane = new JScrollPane(this.m_table);
        spane.setPreferredSize(new Dimension(650, 300));
        m_panel.add((Component)spane, "Center");
        JPanel bpanel = new JPanel(true);
        bpanel.setLayout(new BoxLayout(bpanel, 0));
        Component bx = Box.createRigidArea(new Dimension(250, 10));
        bpanel.add(bx);
        this.m_startButton = new JButton("Start");
        this.m_startButton.addActionListener(new StartPressed());
        this.m_stopButton = new JButton("Stop");
        this.m_stopButton.addActionListener(new StopPressed());
        this.m_stopButton.setEnabled(false);
        bpanel.add(this.m_startButton);
        bx = Box.createRigidArea(new Dimension(20, 10));
        bpanel.add(bx);
        bpanel.add(this.m_stopButton);
        m_panel.add((Component)bpanel, "South");
        GemsUtilities.makeCompactGrid(panel, 2, 4, 5, 5, 5, 5);
        this.m_frame.setIconImage(Gems.getGems().m_icon.getImage());
        this.pack();
        this.show();
    }

    public void start() {
        this.m_running = true;
        this.m_msgs = 0;
        this.m_topic.setEnabled(false);
        this.m_msgsRead.setEnabled(false);
        this.m_startButton.setEnabled(false);
        this.m_stopButton.setEnabled(true);
        this.m_noLimit.setEnabled(false);
        this.m_selector.setEnabled(false);
        this.m_destwiz.setEnabled(false);
        this.m_optMenuItem.setEnabled(false);
        this.m_dumpMenuItem.setEnabled(false);
        try {
            this.m_maxMsgs = Integer.parseInt(this.m_msgsRead.getText());
        }
        catch (Exception ie) {
            this.m_maxMsgs = 10;
        }
        if (this.m_maxMsgs > Gems.getGems().getMaxMonitorEvents()) {
            JOptionPane.showMessageDialog(this.m_frame, "Max monitor events is " + Gems.getGems().getMaxMonitorEvents(), "Error", 1);
            this.m_maxMsgs = Gems.getGems().getMaxMonitorEvents();
            this.m_msgsRead.setText(String.valueOf(this.m_maxMsgs));
        }
        this.m_tableModel.buildColumnHeaders();
        try {
            TibjmsTopicConnectionFactory factory = new TibjmsTopicConnectionFactory(this.m_cn.m_url, null, this.m_cn.m_sslParams);
            this.m_connection = factory.createTopicConnection(this.m_cn.m_user, this.m_cn.m_password);
            this.m_session = this.m_connection.createTopicSession(false, 1);
            Topic topic = this.m_session.createTopic(this.m_topic.getText());
            this.m_subscriber = this.m_selector != null && this.m_selector.getText().length() > 0 ? this.m_session.createSubscriber(topic, this.m_selector.getText(), false) : this.m_session.createSubscriber(topic);
            this.m_connection.start();
            this.m_timer.start();
        }
        catch (JMSException e) {
            JOptionPane.showMessageDialog(this.m_frame, e.getMessage(), "Error", 1);
            this.stop();
        }
    }

    public void stop() {
        this.m_timer.stop();
        this.m_running = false;
        try {
            if (this.m_subscriber != null) {
                this.m_subscriber.close();
                this.m_subscriber = null;
            }
            if (this.m_session != null) {
                this.m_session.close();
                this.m_session = null;
            }
            if (this.m_connection != null) {
                this.m_connection.close();
                this.m_connection = null;
            }
        }
        catch (JMSException e) {
            System.err.println("Exception: " + e.getMessage());
        }
        if (!this.m_isMonitor) {
            this.m_topic.setEnabled(true);
        }
        this.m_msgsRead.setEnabled(true);
        this.m_startButton.setEnabled(true);
        this.m_stopButton.setEnabled(false);
        this.m_noLimit.setEnabled(true);
        this.m_selector.setEnabled(true);
        if (!this.m_isMonitor) {
            this.m_destwiz.setEnabled(true);
        }
        this.m_optMenuItem.setEnabled(true);
        this.m_dumpMenuItem.setEnabled(true);
    }

    public void addMouseListenerToTable(JTable table) {
        MouseAdapter listMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    GemsTopicSubscriber.this.showMessageFrame();
                }
            }
        };
        table.addMouseListener(listMouseListener);
    }

    private JMenuBar constructMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menuBar.add(menu);
        this.m_dumpMenuItem = this.m_isMonitor ? new JMenuItem("Save Monitor Events To File...") : new JMenuItem("Save Messages To File...");
        this.m_dumpMenuItem.addActionListener(new DumpToFile());
        menu.add(this.m_dumpMenuItem);
        JMenuItem menuItem = menu.add(new JMenuItem("Exit"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemsTopicSubscriber.this.dispose();
            }
        });
        menu = new JMenu("Edit");
        menu.setMnemonic(69);
        menuItem = new JMenuItem(new DefaultEditorKit.CutAction());
        menuItem.setText("Cut");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        menu.add(menuItem);
        menuItem = new JMenuItem(new DefaultEditorKit.CopyAction());
        menuItem.setText("Copy");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        menu.add(menuItem);
        menuItem = new JMenuItem(new DefaultEditorKit.PasteAction());
        menuItem.setText("Paste");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        menu.add(menuItem);
        menu.addSeparator();
        this.m_optMenuItem = menu.add(new JMenuItem("Options..."));
        this.m_optMenuItem.addActionListener(new EditOptionsAction());
        menuBar.add(menu);
        menu = new JMenu("Message");
        menu.setMnemonic(77);
        menuBar.add(menu);
        menuItem = this.m_isMonitor ? menu.add(new JMenuItem("View Monitor Event...")) : menu.add(new JMenuItem("View Message..."));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemsTopicSubscriber.this.showMessageFrame();
            }
        });
        return menuBar;
    }

    public void showMessageFrame() {
        Message m = this.m_tableModel.getSelectedMessage();
        if (m != null) {
            GemsMessageFrame f = new GemsMessageFrame(this.m_cn, false, null, true, null, this.m_topic.getText().startsWith("$sys.monitor."));
            f.populate(m);
        } else {
            JOptionPane.showMessageDialog(this.m_frame, "Select a Message to view!", "View Message", 1);
        }
    }

    public void showOrigMessageFrame() {
        Message m = this.m_tableModel.getSelectedMessage();
        if (m != null && m instanceof MapMessage) {
            try {
                MapMessage mapMsg = (MapMessage)m;
                if (mapMsg.itemExists("message_bytes")) {
                    Message msg = Tibjms.createFromBytes((byte[])mapMsg.getBytes("message_bytes"));
                    GemsMessageFrame f = new GemsMessageFrame(this.m_cn, false, null, false, null, false);
                    f.populate(msg);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            JOptionPane.showMessageDialog(null, "There is no original message associated with this monitor message", "Error", 1);
        } else {
            JOptionPane.showMessageDialog(this.m_frame, "Select a Message to view!", "View Message", 1);
        }
    }

    @Override
    public void dispose() {
        this.stop();
        super.dispose();
    }

    class DumpToFile
    implements ActionListener {
        DumpToFile() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JFileChooser chooser = new JFileChooser(new File("."));
                chooser.setApproveButtonText("Save");
                chooser.setDialogTitle("Save Messages To File (appends)");
                int returnVal = chooser.showOpenDialog(GemsTopicSubscriber.this.m_frame);
                if (returnVal == 0) {
                    File f = chooser.getSelectedFile();
                    GemsTopicSubscriber.this.m_tableModel.dumpMsgsToFile(f, GemsTopicSubscriber.this.m_viewoldestFirst);
                }
            }
            catch (IOException ie) {
                JOptionPane.showMessageDialog(GemsTopicSubscriber.this.m_frame, ie.getMessage(), "Error", 1);
                return;
            }
        }
    }

    class DestinationWizardAction
    implements ActionListener {
        DestinationWizardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsDestinationPicker dp = new GemsDestinationPicker(GemsTopicSubscriber.this.m_frame, GemsTopicSubscriber.this.m_cn, GemsDestination.DEST_TYPE.Topic);
            if (dp.m_retDest != null) {
                GemsTopicSubscriber.this.m_topic.setText(dp.m_retDest.m_destName);
            }
        }
    }

    class EditOptionsAction
    implements ActionListener {
        EditOptionsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new GemsBrowserOptionsDialog((Frame)GemsTopicSubscriber.this.m_frame, "Edit Options");
            GemsTopicSubscriber.this.m_timer.setDelay(Gems.getGems().getMsgReadDelay());
            GemsTopicSubscriber.this.m_viewoldestFirst = Gems.getGems().getViewOldMessagesFirst();
        }
    }

    class StopPressed
    implements ActionListener {
        StopPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsTopicSubscriber.this.stop();
        }
    }

    class StartPressed
    implements ActionListener {
        StartPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsTopicSubscriber.this.start();
        }
    }

    class RefreshTimerAction
    implements ActionListener {
        RefreshTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GemsTopicSubscriber.this.m_running) {
                try {
                    Message message = GemsTopicSubscriber.this.m_subscriber.receiveNoWait();
                    if (message != null) {
                        GemsTopicSubscriber.this.m_tableModel.addMessage(message, GemsTopicSubscriber.this.m_viewoldestFirst);
                        if (!GemsTopicSubscriber.this.m_noLimit.isSelected() && ++GemsTopicSubscriber.this.m_msgs >= GemsTopicSubscriber.this.m_maxMsgs) {
                            GemsTopicSubscriber.this.stop();
                        }
                    }
                }
                catch (JMSException ex) {
                    System.err.println("Exception: " + ex.getMessage());
                    GemsTopicSubscriber.this.stop();
                }
            }
        }
    }
}

