/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsTracePopup;
import com.tibco.gems.GemsUtilities;
import com.tibco.tibjms.admin.TraceInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.border.EtchedBorder;

public class GemsTraceDialog
extends JDialog {
    JFrame m_frame;
    JPanel m_panel;
    GemsConnectionNode m_cn;
    TraceInfo m_ti;
    protected JTextField m_traceText;
    protected JButton m_setButton;
    protected JButton m_addButton;
    protected JButton m_removeButton;
    protected JButton m_clearButton;
    protected JButton m_applyButton;
    protected JButton m_closeButton;
    protected JRadioButton m_consoleButton;
    protected JRadioButton m_logfileButton;
    boolean m_isLogTrace = true;

    public GemsTraceDialog(JFrame f, GemsConnectionNode cn) {
        super(f, "Configure Server Trace: (" + cn.getName() + ")", true);
        this.m_frame = f;
        this.m_cn = cn;
        this.init();
        this.reset();
        this.pack();
        this.show();
    }

    public void init() {
        this.setLocationRelativeTo(this.m_frame);
        this.setDefaultCloseOperation(2);
        JPanel m_panel = new JPanel(true);
        m_panel.setLayout(new BorderLayout());
        this.getContentPane().add("Center", m_panel);
        JPanel panel = new JPanel(new SpringLayout(), true);
        panel.setBorder(new EtchedBorder());
        m_panel.add((Component)panel, "North");
        JPanel rpanel = new JPanel(true);
        rpanel.setLayout(new BoxLayout(rpanel, 0));
        panel.add(rpanel);
        this.m_consoleButton = new JRadioButton("Console Trace");
        this.m_consoleButton.addActionListener(new consolePressed());
        this.m_logfileButton = new JRadioButton("Log Trace");
        this.m_logfileButton.setSelected(true);
        this.m_logfileButton.addActionListener(new logPressed());
        Component bx = Box.createRigidArea(new Dimension(100, 10));
        rpanel.add(bx);
        rpanel.add(this.m_consoleButton);
        bx = Box.createRigidArea(new Dimension(70, 10));
        rpanel.add(bx);
        rpanel.add(this.m_logfileButton);
        ButtonGroup group = new ButtonGroup();
        group.add(this.m_consoleButton);
        group.add(this.m_logfileButton);
        JLabel l1 = new JLabel("Current Trace Setting:");
        panel.add(l1);
        this.m_traceText = new JTextField("", 30);
        this.m_traceText.setEditable(false);
        panel.add(this.m_traceText);
        JPanel spanel = new JPanel(true);
        spanel.setLayout(new BoxLayout(spanel, 0));
        panel.add(spanel);
        bx = Box.createRigidArea(new Dimension(70, 10));
        spanel.add(bx);
        this.m_setButton = new JButton("Set...");
        this.m_setButton.addActionListener(new setPressed());
        spanel.add(this.m_setButton);
        bx = Box.createRigidArea(new Dimension(30, 10));
        spanel.add(bx);
        this.m_addButton = new JButton("Add...");
        this.m_addButton.addActionListener(new addPressed());
        spanel.add(this.m_addButton);
        bx = Box.createRigidArea(new Dimension(30, 10));
        spanel.add(bx);
        this.m_removeButton = new JButton("Remove...");
        this.m_removeButton.addActionListener(new removePressed());
        spanel.add(this.m_removeButton);
        bx = Box.createRigidArea(new Dimension(30, 10));
        spanel.add(bx);
        this.m_clearButton = new JButton("Clear");
        this.m_clearButton.addActionListener(new clearPressed());
        spanel.add(this.m_clearButton);
        bx = Box.createRigidArea(new Dimension(30, 10));
        spanel.add(bx);
        Font font = new Font("Serif", 0, 11);
        JLabel l2 = new JLabel("DEFAULT includes ACL, ADMIN, CONFIG, CONNECT_ERROR, INFO, LIMITS, MSG, ROUTE, RVADV, WARNING");
        l2.setFont(font);
        panel.add(l2);
        bx = Box.createRigidArea(new Dimension(20, 10));
        panel.add(bx);
        JPanel bpanel = new JPanel(true);
        bpanel.setLayout(new BoxLayout(bpanel, 0));
        bx = Box.createRigidArea(new Dimension(190, 10));
        bpanel.add(bx);
        this.m_applyButton = new JButton("Apply");
        this.m_applyButton.addActionListener(new applyPressed());
        this.m_closeButton = new JButton("Close");
        this.m_closeButton.addActionListener(new closePressed());
        bpanel.add(this.m_applyButton);
        bx = Box.createRigidArea(new Dimension(20, 10));
        bpanel.add(bx);
        bpanel.add(this.m_closeButton);
        m_panel.add((Component)bpanel, "South");
        GemsUtilities.makeCompactGrid(panel, 6, 1, 10, 10, 10, 10);
    }

    public void update() {
        this.m_traceText.setText(GemsTraceDialog.TraceInfoToString(this.m_ti));
    }

    public void reset() {
        this.m_ti = this.m_cn.getServerTrace(this.m_isLogTrace);
        this.update();
    }

    public void cancel() {
        this.dispose();
    }

    public void doSetTrace() {
        GemsTracePopup p = new GemsTracePopup(this, this.m_setButton);
        Vector items = p.getSelectedTraceItems();
        if (items != null) {
            long l = 0L;
            for (int i = 0; i < items.size(); ++i) {
                l |= ((Trace)((Object)items.get((int)i))).id;
            }
            this.m_ti.setTraceItems(l);
            this.update();
        }
    }

    public void doAddTrace() {
        GemsTracePopup p = new GemsTracePopup(this, this.m_addButton);
        Vector items = p.getSelectedTraceItems();
        if (items != null) {
            long l = 0L;
            for (int i = 0; i < items.size(); ++i) {
                l |= ((Trace)((Object)items.get((int)i))).id;
            }
            this.m_ti.clearAddTraceItems();
            this.m_ti.addTraceItems(l);
            this.update();
        }
    }

    public void doRemoveTrace() {
        GemsTracePopup p = new GemsTracePopup(this, this.m_removeButton);
        Vector items = p.getSelectedTraceItems();
        if (items != null) {
            long l = 0L;
            for (int i = 0; i < items.size(); ++i) {
                l |= ((Trace)((Object)items.get((int)i))).id;
            }
            this.m_ti.clearRemoveTraceItems();
            this.m_ti.removeTraceItems(l);
            this.update();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public static String TraceInfoToString(TraceInfo ti) {
        String r = "set=";
        long s = ti.getTraceSetItems();
        r = r + GemsTraceDialog.TraceItemsToString(s, "");
        r = r + ";add=";
        s = ti.getTraceAddItems();
        r = r + GemsTraceDialog.TraceItemsToString(s, "+");
        r = r + ";remove=";
        s = ti.getTraceRemoveItems();
        r = r + GemsTraceDialog.TraceItemsToString(s, "-");
        return r;
    }

    void debugDump() {
        System.out.println("TRACE_MEMORY 2097152");
        System.out.println("TRACE_MEMORY_DEBUG 4194304");
        System.out.println("TRACE_JAAS 536870912");
        System.out.println("TRACE_JVM 268435456");
        System.out.println("TRACE_JVMERR 4294967296");
        System.out.println("TRACE_DBSTORE 2147483648");
        System.out.println("TRACE_MULTICAST 1073741824");
        System.out.println("TRACE_SS 1048576");
        System.out.println("TRACE_MSTORE 8589934592");
        System.out.println("TRACE_LOADER 17179869184");
        System.out.println("TRACE_CONFIG_DETAIL 34359738368");
    }

    public static String TraceItemsToString(long ti, String prefix) {
        StringBuffer r = new StringBuffer();
        boolean def = false;
        if ((ti & Trace.DEFAULT.id) == Trace.DEFAULT.id) {
            def = true;
            r.append(prefix);
            r.append((Object)Trace.DEFAULT);
            r.append(',');
        }
        if ((ti & Trace.MEMORY.id) == Trace.MEMORY.id) {
            r.append(prefix);
            r.append((Object)Trace.MEMORY);
            r.append(',');
        }
        if ((ti & Trace.MEMORY_DEBUG.id) == Trace.MEMORY_DEBUG.id) {
            r.append(prefix);
            r.append((Object)Trace.MEMORY_DEBUG);
            r.append(',');
        }
        if ((ti & Trace.JAAS.id) == Trace.JAAS.id) {
            r.append(prefix);
            r.append((Object)Trace.JAAS);
            r.append(',');
        }
        if ((ti & Trace.JVM.id) == Trace.JVM.id) {
            r.append(prefix);
            r.append((Object)Trace.JVM);
            r.append(',');
        }
        if ((ti & Trace.JVMERR.id) == Trace.JVMERR.id) {
            r.append(prefix);
            r.append((Object)Trace.JVMERR);
            r.append(',');
        }
        if ((ti & Trace.DBSTORE.id) == Trace.DBSTORE.id) {
            r.append(prefix);
            r.append((Object)Trace.DBSTORE);
            r.append(',');
        }
        if ((ti & Trace.LOADER.id) == Trace.LOADER.id) {
            r.append(prefix);
            r.append((Object)Trace.LOADER);
            r.append(',');
        }
        if ((ti & Trace.MULTICAST.id) == Trace.MULTICAST.id) {
            r.append(prefix);
            r.append((Object)Trace.MULTICAST);
            r.append(',');
        }
        if (!def && (ti & Trace.ACL.id) != 0L) {
            r.append(prefix);
            r.append((Object)Trace.ACL);
            r.append(',');
        }
        if (!def && (ti & Trace.ADMIN.id) != 0L) {
            r.append(prefix);
            r.append((Object)Trace.ADMIN);
            r.append(',');
        }
        if ((ti & Trace.AUTH.id) != 0L) {
            r.append(prefix);
            r.append((Object)Trace.AUTH);
            r.append(',');
        }
        if (!def && (ti & Trace.CONFIG.id) != 0L) {
            r.append(prefix);
            r.append((Object)Trace.CONFIG);
            r.append(',');
        }
        if (!def && (ti & Trace.CONFIG_DETAIL.id) != 0L) {
            r.append(prefix);
            r.append((Object)Trace.CONFIG_DETAIL);
            r.append(',');
        }
        if ((ti & Trace.CONNECT.id) != 0L) {
            r.append(prefix);
            r.append((Object)Trace.CONNECT);
            r.append(',');
        }
        if (!def && (ti & Trace.CONNECT_ERROR.id) != 0L) {
            r.append(prefix);
            r.append((Object)Trace.CONNECT_ERROR);
            r.append(',');
        }
        if ((ti & Trace.DEST.id) != 0L) {
            r.append(prefix);
            r.append((Object)Trace.DEST);
            r.append(',');
        }
        if ((ti & Trace.FLOW.id) != 0L) {
            r.append(prefix);
            r.append((Object)Trace.FLOW);
            r.append(',');
        }
        if (!def && (ti & Trace.INFO.id) != 0L) {
            r.append(prefix);
            r.append((Object)Trace.INFO);
            r.append(',');
        }
        if ((ti & Trace.LDAP_DEBUG.id) != 0L) {
            r.append(prefix);
            r.append((Object)Trace.LDAP_DEBUG);
            r.append(',');
        }
        if (!def && (ti & Trace.LIMITS.id) != 0L) {
            r.append(prefix);
            r.append((Object)Trace.LIMITS);
            r.append(',');
        }
        if (!def && (ti & Trace.MSG.id) != 0L) {
            r.append(prefix);
            r.append((Object)Trace.MSG);
            r.append(',');
        }
        if ((ti & Trace.PRODCONS.id) != 0L) {
            r.append(prefix);
            r.append((Object)Trace.PRODCONS);
            r.append(',');
        }
        if (!def && (ti & Trace.ROUTE.id) != 0L) {
            r.append(prefix);
            r.append((Object)Trace.ROUTE);
            r.append(',');
        }
        if ((ti & Trace.ROUTE_DEBUG.id) != 0L) {
            r.append(prefix);
            r.append((Object)Trace.ROUTE_DEBUG);
            r.append(',');
        }
        if (!def && (ti & Trace.RVADV.id) != 0L) {
            r.append(prefix);
            r.append((Object)Trace.RVADV);
            r.append(',');
        }
        if ((ti & Trace.SS.id) != 0L) {
            r.append(prefix);
            r.append((Object)Trace.SS);
            r.append(',');
        }
        if ((ti & Trace.SSL.id) != 0L) {
            r.append(prefix);
            r.append((Object)Trace.SSL);
            r.append(',');
        }
        if ((ti & Trace.SSL_DEBUG.id) != 0L) {
            r.append(prefix);
            r.append((Object)Trace.SSL_DEBUG);
            r.append(',');
        }
        if ((ti & Trace.TX.id) != 0L) {
            r.append(prefix);
            r.append((Object)Trace.TX);
            r.append(',');
        }
        if (!def && (ti & Trace.WARNING.id) != 0L) {
            r.append(prefix);
            r.append((Object)Trace.WARNING);
            r.append(',');
        }
        if (!def && (ti & Trace.MSTORE.id) != 0L) {
            r.append(prefix);
            r.append((Object)Trace.MSTORE);
            r.append(',');
        }
        if (r.length() > 0) {
            r.setLength(r.length() - 1);
        }
        return r.toString();
    }

    public static enum Trace {
        DEFAULT(67204336L),
        ACL(64L),
        ADMIN(4096L),
        AUTH(0x2000000L),
        CONFIG(8192L),
        CONFIG_DETAIL(0x800000000L),
        CONNECT(32768L),
        CONNECT_ERROR(65536L),
        DBSTORE(0x80000000L),
        DEST(262144L),
        FLOW(0x8000000L),
        INFO(16L),
        JAAS(0x20000000L),
        JVM(0x10000000L),
        JVMERR(0x100000000L),
        LDAP_DEBUG(0x1000000L),
        LIMITS(128L),
        LOADER(0x400000000L),
        MEMORY(0x200000L),
        MEMORY_DEBUG(0x400000L),
        MSG(0x4000000L),
        MSTORE(0x200000000L),
        MULTICAST(0x40000000L),
        PRODCONS(131072L),
        ROUTE(1024L),
        ROUTE_DEBUG(2048L),
        RVADV(16384L),
        SS(0x100000L),
        SSL(256L),
        SSL_DEBUG(512L),
        TX(524288L),
        WARNING(32L);

        public final long id;

        private Trace(long id) {
            this.id = id;
        }
    }

    class logPressed
    implements ActionListener {
        logPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsTraceDialog.this.m_isLogTrace = true;
            GemsTraceDialog.this.reset();
        }
    }

    class consolePressed
    implements ActionListener {
        consolePressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsTraceDialog.this.m_isLogTrace = false;
            GemsTraceDialog.this.reset();
        }
    }

    class clearPressed
    implements ActionListener {
        clearPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsTraceDialog.this.m_ti.clearAllTraceItems();
            GemsTraceDialog.this.update();
        }
    }

    class removePressed
    implements ActionListener {
        removePressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsTraceDialog.this.doRemoveTrace();
        }
    }

    class addPressed
    implements ActionListener {
        addPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsTraceDialog.this.doAddTrace();
        }
    }

    class setPressed
    implements ActionListener {
        setPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsTraceDialog.this.doSetTrace();
        }
    }

    class closePressed
    implements ActionListener {
        closePressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsTraceDialog.this.cancel();
        }
    }

    class applyPressed
    implements ActionListener {
        applyPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsTraceDialog.this.m_cn.setServerTrace(GemsTraceDialog.this.m_ti, GemsTraceDialog.this.m_isLogTrace);
            GemsTraceDialog.this.reset();
        }
    }
}

