/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.GemsCheckListTableModel;
import com.tibco.gems.GemsTraceDialog;
import com.tibco.gems.TableSorter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class GemsTracePopup
extends JDialog {
    JPanel m_panel;
    JTable m_table;
    protected GemsCheckListTableModel m_tableModel;
    TableSorter m_sorter;
    protected JButton m_okButton;
    protected JButton m_cancelButton;
    protected boolean m_ok = true;

    public GemsTracePopup(JDialog f, Component c) {
        super(f, "Select Trace Items", true);
        this.setLocationRelativeTo(c);
        this.setDefaultCloseOperation(2);
        JPanel m_panel = new JPanel(true);
        m_panel.setLayout(new BorderLayout());
        this.getContentPane().add("Center", m_panel);
        this.m_tableModel = new GemsCheckListTableModel("TraceItem");
        this.m_sorter = new TableSorter(this.m_tableModel);
        this.m_table = new JTable(this.m_sorter);
        this.m_table.getTableHeader().setReorderingAllowed(false);
        this.m_sorter.setTableHeader(this.m_table.getTableHeader());
        this.m_table.setRowSelectionAllowed(false);
        this.m_tableModel.m_table = this.m_table;
        this.addMouseListenerToTable(this.m_table);
        JScrollPane spane = new JScrollPane(this.m_table);
        spane.setPreferredSize(new Dimension(230, 300));
        m_panel.add((Component)spane, "North");
        JPanel bpanel = new JPanel(true);
        bpanel.setLayout(new BoxLayout(bpanel, 0));
        Component bx = Box.createRigidArea(new Dimension(40, 10));
        bpanel.add(bx);
        this.m_okButton = new JButton("Ok");
        this.m_okButton.addActionListener(new OkPressed());
        this.m_cancelButton = new JButton("Cancel");
        this.m_cancelButton.addActionListener(new CancelPressed());
        bpanel.add(this.m_okButton);
        bx = Box.createRigidArea(new Dimension(20, 10));
        bpanel.add(bx);
        bpanel.add(this.m_cancelButton);
        m_panel.add((Component)bpanel, "South");
        this.pack();
    }

    Vector getSelectedTraceItems() {
        this.populate();
        this.show();
        if (this.m_ok) {
            return this.m_tableModel.getSelectedObjects();
        }
        return null;
    }

    public void populate() {
        this.m_tableModel.buildColumnHeaders();
        for (GemsTraceDialog.Trace t : GemsTraceDialog.Trace.values()) {
            this.m_tableModel.addObject(false, (Object)t);
        }
    }

    public void ok() {
        this.dispose();
    }

    public void cancel() {
        this.m_ok = false;
        this.dispose();
    }

    public void addMouseListenerToTable(JTable table) {
        MouseAdapter listMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && GemsTracePopup.this.m_table.getSelectedColumn() > 0) {
                    GemsTracePopup.this.m_tableModel.toggleSelectedRow();
                }
            }
        };
        table.addMouseListener(listMouseListener);
    }

    class CancelPressed
    implements ActionListener {
        CancelPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsTracePopup.this.cancel();
        }
    }

    class OkPressed
    implements ActionListener {
        OkPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsTracePopup.this.ok();
        }
    }
}

