/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsAdminPermissionDialog;
import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsDestPropEditor;
import com.tibco.gems.GemsDetailsTableModel;
import com.tibco.gems.GemsEventMonitor;
import com.tibco.gems.GemsIconNode;
import com.tibco.gems.GemsPermissionDialog;
import com.tibco.gems.GemsQueueNode;
import com.tibco.gems.GemsTopicNode;
import com.tibco.gems.GemsTraceDialog;
import com.tibco.gems.GetPopupHandler;
import com.tibco.gems.PopupHandler;
import com.tibco.gems.PopupTreeHandler;
import com.tibco.tibjms.admin.ServerInfo;
import com.tibco.tibjms.admin.TibjmsAdmin;
import java.awt.Point;
import java.util.Enumeration;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class GemsTreeModel
extends DefaultTreeModel
implements TreeSelectionListener,
GetPopupHandler {
    DefaultMutableTreeNode m_root;
    JTree m_tree;
    Gems m_gems;
    PopupHandler m_popup = null;
    protected Thread m_connectThread = null;

    public GemsTreeModel(DefaultMutableTreeNode root) {
        super(root);
        this.m_root = root;
    }

    @Override
    public PopupHandler getPopupHandler() {
        if (this.m_popup == null) {
            this.m_popup = new PopupTreeHandler(this);
        }
        return this.m_popup;
    }

    public void setPopupHandler(PopupHandler pop) {
        this.m_popup = pop;
    }

    public DefaultMutableTreeNode getNodeAt(Point p) {
        TreePath selPath = this.m_tree.getClosestPathForLocation(p.x, p.y);
        if (selPath != null) {
            return (DefaultMutableTreeNode)selPath.getLastPathComponent();
        }
        return null;
    }

    public void expandAll(TreeNode n) {
        if (n == null) {
            n = (TreeNode)this.m_tree.getModel().getRoot();
        }
        this.expandAll(new TreePath(n));
    }

    private void expandAll(TreePath parent) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)parent.getLastPathComponent();
        if (node.getChildCount() > 0) {
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
                TreePath path = new TreePath(n.getPath());
                this.expandAll(path);
            }
        }
        this.m_tree.expandPath(parent);
    }

    public void selectNode(DefaultMutableTreeNode node) {
        this.m_tree.setSelectionPath(new TreePath(node.getPath()));
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        this.nodeChanged(aNode);
    }

    public GemsConnectionNode newJMSConnection(DefaultMutableTreeNode parent, String name) {
        GemsConnectionNode node = new GemsConnectionNode(name);
        node.setManualDisconnect(true);
        parent.add(node);
        this.reload();
        this.m_tree.expandPath(new TreePath(node.getPath()));
        this.m_tree.setSelectionPath(new TreePath(node.getPath()));
        return node;
    }

    public void newFolder(DefaultMutableTreeNode parent, String name) {
        GemsIconNode node = new GemsIconNode(name);
        if (parent == null) {
            this.m_root.add(node);
        } else {
            parent.add(node);
        }
        this.reload();
        this.m_tree.expandPath(new TreePath(node.getPath()));
        this.m_tree.setSelectionPath(new TreePath(node.getPath()));
    }

    public void reloadTree() {
        this.reload();
        this.m_tree.expandPath(new TreePath(this.m_root.getPath()));
        this.m_tree.setSelectionPath(new TreePath(this.m_root.getPath()));
    }

    public GemsConnectionNode newJMSConnection(String name) {
        GemsConnectionNode node = new GemsConnectionNode(name);
        node.setManualDisconnect(true);
        this.m_root.add(node);
        this.reload();
        this.m_tree.expandPath(new TreePath(node.getPath()));
        this.m_tree.setSelectionPath(new TreePath(node.getPath()));
        return node;
    }

    public boolean connectCurrentNode(String name, String url, String user, String password, boolean autoConnect, GemsConnectionNode.LOG_TYPE logInfo, String logDir, String queuePattern, String topicPattern, String queueStore, String topicStore, String userFilter, boolean enableMonitor) {
        TreePath selPath = this.m_tree.getSelectionPath();
        if (selPath == null) {
            return false;
        }
        if (!(selPath.getLastPathComponent() instanceof GemsConnectionNode)) {
            return false;
        }
        GemsConnectionNode node = (GemsConnectionNode)selPath.getLastPathComponent();
        if (node == null) {
            return false;
        }
        if (!(node.m_isAutoConnect == autoConnect && node.getQueueNamePattern().equals(queuePattern) && node.getTopicNamePattern().equals(topicPattern) && node.getQueueStoreFilter().equals(queueStore) && node.getTopicStoreFilter().equals(topicStore) && node.getUserNameFilter().equals(userFilter) && node.getUserObject().equals(name) && node.m_url.equals(url) && node.m_user.equals(user) && node.m_logServerInfo == logInfo && node.m_logDir.equals(logDir))) {
            Gems.getGems().isDirty(true);
        }
        node.m_isAutoConnect = autoConnect;
        node.m_queueNamePattern = queuePattern;
        node.m_topicNamePattern = topicPattern;
        node.m_queueStoreFilter = queueStore;
        node.m_topicStoreFilter = topicStore;
        node.m_userNameFilter = userFilter;
        GemsEventMonitor ev = node.getEventMonitor();
        if (enableMonitor) {
            if (ev != null) {
                if (!ev.m_enabled) {
                    Gems.getGems().isDirty(true);
                }
                ev.m_enabled = true;
            } else {
                Gems.getGems().isDirty(true);
                node.addEventMonitor(50L, true);
                System.err.println("Adding monitor event subscription to \"$sys.monitor.limits.*\" for " + url);
                node.addEventSubscription("$sys.monitor.limits.*", null);
                System.err.println("Adding monitor event subscription to \"$sys.monitor.server.warning\" for " + url);
                node.addEventSubscription("$sys.monitor.server.warning", null);
            }
        } else if (ev != null) {
            if (ev.m_enabled) {
                Gems.getGems().isDirty(true);
            }
            ev.m_enabled = false;
        }
        node.connect(name, url, user, password);
        node.setServerLogInfo(logInfo);
        node.setServerLogDir(logDir);
        this.reload();
        this.m_tree.expandPath(new TreePath(node.getPath()));
        this.m_tree.setSelectionPath(new TreePath(node.getPath()));
        return node.isConnected();
    }

    public void connectTreeNodes(DefaultMutableTreeNode node) {
        if (this.m_connectThread == null) {
            this.m_tree.setSelectionPath(new TreePath(node.getPath()));
            this.m_connectThread = new ConnectThread(node);
            this.m_connectThread.start();
        }
    }

    public boolean isConnectThreadRunning() {
        return this.m_connectThread != null;
    }

    public void removeConnectionNode(DefaultMutableTreeNode node) {
        int opt;
        GemsConnectionNode cn = null;
        while (node != null && node.getLevel() > 0) {
            if (node instanceof GemsConnectionNode) {
                cn = (GemsConnectionNode)node;
                break;
            }
            node = (DefaultMutableTreeNode)node.getParent();
        }
        if (cn != null && (opt = JOptionPane.showConfirmDialog(Gems.getGems().m_frame, "Remove EMS Server: " + cn.getUserObject() + "(" + cn.getUrl() + ")", "Remove EMS Server", 0)) == 0) {
            cn.disconnect(false);
            cn.cleanup();
            DefaultMutableTreeNode p = (DefaultMutableTreeNode)cn.getParent();
            cn.removeFromParent();
            this.reload();
            this.m_tree.expandPath(new TreePath(p.getPath()));
            this.m_tree.setSelectionPath(new TreePath(p.getPath()));
        }
    }

    public void removeCurrentConnnectionNode() {
        TreePath tp = this.m_tree.getSelectionPath();
        if (tp == null) {
            return;
        }
        GemsConnectionNode cn = null;
        for (DefaultMutableTreeNode node = (DefaultMutableTreeNode)tp.getLastPathComponent(); node != null && node.getLevel() > 0; node = (DefaultMutableTreeNode)node.getParent()) {
            if (!(node instanceof GemsConnectionNode)) continue;
            cn = (GemsConnectionNode)node;
            break;
        }
        if (cn != null) {
            int opt = JOptionPane.showConfirmDialog(Gems.getGems().m_frame, "Remove EMS Server: " + cn.getUserObject() + "(" + cn.getUrl() + ")", "Remove EMS Server", 0);
            if (opt == 0) {
                cn.disconnect(false);
                cn.cleanup();
                DefaultMutableTreeNode p = (DefaultMutableTreeNode)cn.getParent();
                cn.removeFromParent();
                this.reload();
                this.m_tree.expandPath(new TreePath(p.getPath()));
                this.m_tree.setSelectionPath(new TreePath(p.getPath()));
            }
        } else {
            JOptionPane.showMessageDialog(Gems.getGems().m_frame, "Select an EMS Server in the tree view to remove!", "Remove EMS Server", 1);
        }
    }

    public void removeCurrentFolder() {
        TreePath tp = this.m_tree.getSelectionPath();
        if (tp == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tp.getLastPathComponent();
        this.removeFolder(node);
    }

    public void removeFolder(DefaultMutableTreeNode node) {
        if (node != null && !node.isRoot() && !(node instanceof GemsConnectionNode) && node.getAllowsChildren()) {
            if (node.getChildCount() != 0) {
                JOptionPane.showMessageDialog(Gems.getGems().m_frame, "Folder must be empty!", "Remove Folder", 1);
            } else {
                DefaultMutableTreeNode p = (DefaultMutableTreeNode)node.getParent();
                node.removeFromParent();
                this.reload();
                this.m_tree.expandPath(new TreePath(p.getPath()));
                this.m_tree.setSelectionPath(new TreePath(p.getPath()));
            }
        }
    }

    public void disconnectCurrentNode(boolean manual) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_tree.getSelectionPath().getLastPathComponent();
        GemsConnectionNode cn = null;
        while (node.getLevel() > 0) {
            if (node instanceof GemsConnectionNode) {
                cn = (GemsConnectionNode)node;
                break;
            }
            node = (DefaultMutableTreeNode)node.getParent();
        }
        if (cn != null) {
            cn.disconnect(false, true);
            this.reload();
            this.m_tree.setSelectionPath(new TreePath(node.getPath()));
        }
    }

    public void disconnectTreeNodes(DefaultMutableTreeNode node) {
        if (node == null) {
            return;
        }
        if (node.getChildCount() > 0) {
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
                if (n instanceof GemsConnectionNode) {
                    GemsConnectionNode cn = (GemsConnectionNode)n;
                    cn.disconnect(false, true);
                    continue;
                }
                this.disconnectTreeNodes(n);
            }
        }
    }

    public void detailsPanelDoubleClick(String tn) {
        if (tn == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_tree.getSelectionPath().getLastPathComponent();
        if (node == null) {
            return;
        }
        this.m_tree.expandPath(new TreePath(node.getPath()));
        String nn = (String)node.getUserObject();
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        String pn = null;
        if (parent != null) {
            pn = (String)parent.getUserObject();
        }
        TreePath tp = this.m_tree.getNextMatch(tn, this.m_tree.getRowForPath(new TreePath(node.getPath())), Position.Bias.Forward);
        if (nn.startsWith("Topics")) {
            if (Gems.getGems().getHideTreeDests()) {
                GemsDestPropEditor gemsDestPropEditor = new GemsDestPropEditor(Gems.getGems().m_frame, (GemsConnectionNode)parent, "Topic", tn);
            } else if (tp == null) {
                this.createTopic(tn, true);
            } else {
                this.m_tree.setSelectionPath(tp);
            }
        } else if (nn.startsWith("Queues")) {
            if (Gems.getGems().getHideTreeDests()) {
                GemsDestPropEditor gemsDestPropEditor = new GemsDestPropEditor(Gems.getGems().m_frame, (GemsConnectionNode)parent, "Queue", tn);
            }
            if (tp == null) {
                this.createQueue(tn, true);
            } else {
                this.m_tree.setSelectionPath(tp);
            }
        } else if (!Gems.getGems().getViewOnlyMode() && parent != null && pn.startsWith("Topics")) {
            ((GemsTopicNode)node).setProperty((GemsConnectionNode)parent.getParent(), tn);
        } else if (!Gems.getGems().getViewOnlyMode() && parent != null && pn.startsWith("Queues")) {
            ((GemsQueueNode)node).setProperty((GemsConnectionNode)parent.getParent(), tn);
        } else if (!Gems.getGems().getViewOnlyMode() && nn.equals("ACLs")) {
            GemsPermissionDialog gemsPermissionDialog = new GemsPermissionDialog(Gems.getGems().m_frame, (GemsConnectionNode)node.getParent(), tn, Gems.getGems().getDetailsPanel().getModel().getSelectedCol(2), Gems.getGems().getDetailsPanel().getModel().getSelectedCol(3), Gems.getGems().getDetailsPanel().getModel().getSelectedCol(4), Gems.getGems().getDetailsPanel().getModel().getSelectedCol(5));
        } else if (!Gems.getGems().getViewOnlyMode() && nn.equals("AdminACLs")) {
            GemsAdminPermissionDialog gemsAdminPermissionDialog = new GemsAdminPermissionDialog(Gems.getGems().m_frame, (GemsConnectionNode)node.getParent(), tn, Gems.getGems().getDetailsPanel().getModel().getSelectedCol(2), Gems.getGems().getDetailsPanel().getModel().getSelectedCol(3));
        } else if (nn.equals("Consumers")) {
            GemsDetailsTableModel m = Gems.getGems().getDetailsPanel().getModel();
            String cid = m.getSelectedCol(9);
            if (cid != null && !cid.equals("0") && (tp = this.m_tree.getNextMatch("Connections(Client)", this.m_tree.getRowForPath(new TreePath(parent.getPath())), Position.Bias.Forward)) != null) {
                this.m_tree.setSelectionPath(tp);
                m.selectRow(cid);
            }
        } else if (nn.equals("Producers")) {
            GemsDetailsTableModel m = Gems.getGems().getDetailsPanel().getModel();
            String cid = m.getSelectedCol(5);
            if (cid != null && !cid.equals("0") && (tp = this.m_tree.getNextMatch("Connections(Client)", this.m_tree.getRowForPath(new TreePath(parent.getPath())), Position.Bias.Forward)) != null) {
                this.m_tree.setSelectionPath(tp);
                m.selectRow(cid);
            }
        } else if (tp != null) {
            this.m_tree.setSelectionPath(tp);
        }
    }

    public void selectConnection(String cid) {
        TreePath tp;
        DefaultMutableTreeNode parent;
        DefaultMutableTreeNode node;
        TreePath selPath = this.m_tree.getSelectionPath();
        if (selPath != null && (node = (DefaultMutableTreeNode)selPath.getLastPathComponent()) != null && (parent = (DefaultMutableTreeNode)node.getParent()) != null && cid != null && !cid.equals("0") && (tp = this.m_tree.getNextMatch("Connections(Client)", this.m_tree.getRowForPath(new TreePath(parent.getPath())), Position.Bias.Forward)) != null) {
            this.m_tree.setSelectionPath(tp);
            Gems.getGems().getDetailsPanel().getModel().selectRow(cid);
        }
    }

    public void setServerTrace() {
        DefaultMutableTreeNode n1;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_tree.getSelectionPath().getLastPathComponent();
        if (node == null) {
            return;
        }
        GemsConnectionNode cn = null;
        if (node.isRoot() && node.getChildCount() == 1 && (n1 = (DefaultMutableTreeNode)node.getChildAt(0)) instanceof GemsConnectionNode) {
            cn = (GemsConnectionNode)n1;
        }
        if (cn == null) {
            while (node.getLevel() > 0) {
                if (node instanceof GemsConnectionNode) {
                    cn = (GemsConnectionNode)node;
                    break;
                }
                node = (DefaultMutableTreeNode)node.getParent();
            }
        }
        if (cn != null) {
            if (!Gems.getGems().isStandbyOpsAllowed(cn)) {
                return;
            }
            GemsTraceDialog gemsTraceDialog = new GemsTraceDialog(Gems.getGems().m_frame, cn);
        }
    }

    public void serverPanelDoubleClick(String tn) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_tree.getSelectionPath().getLastPathComponent();
        if (node == null) {
            return;
        }
        GemsConnectionNode cn = null;
        while (node.getLevel() > 0) {
            if (node instanceof GemsConnectionNode) {
                cn = (GemsConnectionNode)node;
                break;
            }
            node = (DefaultMutableTreeNode)node.getParent();
        }
        if (cn != null) {
            if (!Gems.getGems().isStandbyOpsAllowed(cn)) {
                return;
            }
            cn.setServerProperty(tn);
        }
    }

    public void serverMonitorDoubleClick(String tn) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_tree.getSelectionPath().getLastPathComponent();
        if (node == null) {
            return;
        }
        this.m_tree.expandPath(new TreePath(node.getPath()));
        TreePath tp = this.find2(this.m_tree, new TreePath(node.getPath()), tn, node.getLevel(), true);
        if (tp != null) {
            this.m_tree.setSelectionPath(tp);
        }
    }

    public TreePath findByName(JTree tree, String name) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        return this.find2(tree, new TreePath(root), name, 0, true);
    }

    private TreePath find2(JTree tree, TreePath parent, Object name, int depth, boolean byName) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        Object o = node;
        if (byName) {
            o = o.toString();
        }
        if (o.equals(name)) {
            return parent;
        }
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                TreePath result = this.find2(tree, path, name, depth + 1, byName);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public void createQueue(String qn, boolean nodeOnly) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_tree.getSelectionPath().getLastPathComponent();
        GemsConnectionNode cn = null;
        while (node.getLevel() > 0) {
            if (node instanceof GemsConnectionNode) {
                cn = (GemsConnectionNode)node;
                break;
            }
            node = (DefaultMutableTreeNode)node.getParent();
        }
        if (cn != null) {
            if (!Gems.getGems().isStandbyOpsAllowed(cn)) {
                return;
            }
            DefaultMutableTreeNode qnode = cn.createQueue(qn, nodeOnly);
            if (qnode == null) {
                return;
            }
            this.reload();
            this.m_tree.expandPath(new TreePath(((DefaultMutableTreeNode)qnode.getParent()).getPath()));
            this.m_tree.setSelectionPath(new TreePath(qnode.getPath()));
        }
    }

    public void removeQueue(String qn) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_tree.getSelectionPath().getLastPathComponent();
        while (!(node instanceof GemsConnectionNode)) {
            if ((node = (DefaultMutableTreeNode)node.getParent()) != null) continue;
            return;
        }
        if (!Gems.getGems().isStandbyOpsAllowed((GemsConnectionNode)node)) {
            return;
        }
        if ((node = ((GemsConnectionNode)node).removeQueue(qn)) != null) {
            this.m_tree.updateUI();
            this.reload();
            this.m_tree.expandPath(new TreePath(node.getPath()));
            this.m_tree.setSelectionPath(new TreePath(node.getPath()));
        }
    }

    public ServerInfo getSelectedJmsServerInfo() {
        TreePath selPath = this.m_tree.getSelectionPath();
        if (selPath != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
            if (node == null) {
                return null;
            }
            if (node.getLevel() < 0) {
                return null;
            }
            GemsConnectionNode cn = null;
            while (node.getLevel() > 0) {
                if (node instanceof GemsConnectionNode) {
                    cn = (GemsConnectionNode)node;
                    break;
                }
                node = (DefaultMutableTreeNode)node.getParent();
            }
            System.out.println("In getSelectedJmsServerInfo!");
            if (cn != null) {
                return cn.getJmsServerInfo(false);
            }
        }
        return null;
    }

    public TibjmsAdmin getSelectedJmsAdmin() {
        TreePath selPath = this.m_tree.getSelectionPath();
        if (selPath != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
            if (node == null) {
                return null;
            }
            if (node.getLevel() < 0) {
                return null;
            }
            GemsConnectionNode cn = null;
            while (node.getLevel() > 0) {
                if (node instanceof GemsConnectionNode) {
                    cn = (GemsConnectionNode)node;
                    break;
                }
                node = (DefaultMutableTreeNode)node.getParent();
            }
            if (cn != null) {
                return cn.getJmsAdmin();
            }
        }
        return null;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_tree.getLastSelectedPathComponent();
        TreePath selPath = this.m_tree.getSelectionPath();
        if (selPath != null) {
            node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
        }
        if (node == null) {
            return;
        }
        this.m_gems.treeSelectionChange(node, false);
        this.m_gems.selectLastTab();
    }

    public void createTopic(String qn, boolean nodeOnly) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_tree.getSelectionPath().getLastPathComponent();
        GemsConnectionNode cn = null;
        while (node.getLevel() > 0) {
            if (node instanceof GemsConnectionNode) {
                cn = (GemsConnectionNode)node;
                break;
            }
            node = (DefaultMutableTreeNode)node.getParent();
        }
        if (cn != null) {
            if (!Gems.getGems().isStandbyOpsAllowed(cn)) {
                return;
            }
            DefaultMutableTreeNode qnode = cn.createTopic(qn, nodeOnly);
            if (qnode == null) {
                return;
            }
            this.reload();
            this.m_tree.expandPath(new TreePath(((DefaultMutableTreeNode)qnode.getParent()).getPath()));
            this.m_tree.setSelectionPath(new TreePath(qnode.getPath()));
        }
    }

    public void removeTopic(String qn) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_tree.getSelectionPath().getLastPathComponent();
        GemsConnectionNode cn = null;
        while (node.getLevel() > 0) {
            if (node instanceof GemsConnectionNode) {
                cn = (GemsConnectionNode)node;
                break;
            }
            node = (DefaultMutableTreeNode)node.getParent();
        }
        if (cn != null) {
            if (!Gems.getGems().isStandbyOpsAllowed(cn)) {
                return;
            }
            node = cn.removeTopic(qn);
            if (node == null) {
                return;
            }
            this.m_tree.updateUI();
            this.reload();
            this.m_tree.expandPath(new TreePath(node.getPath()));
            this.m_tree.setSelectionPath(new TreePath(node.getPath()));
        }
    }

    public void purgeTopic(String qn) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_tree.getSelectionPath().getLastPathComponent();
        GemsConnectionNode cn = null;
        while (node.getLevel() > 0) {
            if (node instanceof GemsConnectionNode) {
                cn = (GemsConnectionNode)node;
                break;
            }
            node = (DefaultMutableTreeNode)node.getParent();
        }
        if (cn != null) {
            if (!Gems.getGems().isStandbyOpsAllowed(cn)) {
                return;
            }
            cn.purgeTopic(qn);
        }
    }

    public void purgeQueue(String qn) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_tree.getSelectionPath().getLastPathComponent();
        GemsConnectionNode cn = null;
        while (node.getLevel() > 0) {
            if (node instanceof GemsConnectionNode) {
                cn = (GemsConnectionNode)node;
                break;
            }
            node = (DefaultMutableTreeNode)node.getParent();
        }
        if (cn != null) {
            if (!Gems.getGems().isStandbyOpsAllowed(cn)) {
                return;
            }
            cn.purgeQueue(qn);
        }
    }

    class ConnectThread
    extends Thread {
        DefaultMutableTreeNode m_node = null;

        ConnectThread(DefaultMutableTreeNode node) {
            this.m_node = node;
        }

        @Override
        public void run() {
            try {
                if (Gems.getGems().getServerMonitorTableModel().findServers(this.m_node, true, true, true)) {
                    Gems.getGems().scheduleRepaint();
                    GemsTreeModel.this.m_tree.repaint();
                }
            }
            catch (Exception ie) {
                System.err.println("Exception: " + ie.getMessage());
            }
            GemsTreeModel.this.m_connectThread = null;
        }
    }
}

