/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import java.awt.Component;
import java.awt.Container;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.Spring;
import javax.swing.SpringLayout;

public abstract class GemsUtilities {
    private static DecimalFormat oneDecimal = new DecimalFormat("0.0");
    private static Set primitiveTypes = new HashSet();
    private static Map classProperties;

    public static String getHumanReadableSize(long bytes) {
        long mb = (long)Math.pow(2.0, 20.0);
        long kb = (long)Math.pow(2.0, 10.0);
        long gb = (long)Math.pow(2.0, 30.0);
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(1);
        double relSize = 0.0;
        long abytes = Math.abs(bytes);
        String id = "";
        if (abytes / gb >= 1L) {
            relSize = (double)abytes / (double)gb;
            id = "GB";
        } else if (abytes / mb >= 1L) {
            relSize = (double)abytes / (double)mb;
            id = "MB";
        } else if (abytes / kb >= 1L) {
            relSize = (double)abytes / (double)kb;
            id = "KB";
        } else {
            relSize = abytes;
            id = "b";
        }
        return nf.format((double)(bytes < 0L ? -1 : 1) * relSize) + id;
    }

    public static String getHumanReadableLong(long number) {
        long absNumber = Math.abs(number);
        double result = number;
        String suffix = "";
        if (absNumber >= 1024L) {
            if (absNumber < 0x100000L) {
                result = (double)number / 1024.0;
                suffix = "K";
            } else if (absNumber < 0x40000000L) {
                result = (double)number / 1048576.0;
                suffix = "M";
            } else {
                result = (double)number / 1.073741824E9;
                suffix = "G";
            }
        }
        return oneDecimal.format(result) + suffix;
    }

    public static String dumpBytes(byte[] bs) {
        StringBuffer ret = new StringBuffer(bs.length);
        for (int i = 0; i < bs.length; ++i) {
            String hex = Integer.toHexString(256 + (bs[i] & 0xFF)).substring(1);
            ret.append((hex.length() < 2 ? "0" : "") + hex);
        }
        return ret.toString();
    }

    public static String arrayToString(Object[] arr) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; arr != null && i < arr.length; ++i) {
            ret.append(arr[i].toString());
            if (!(arr[i] instanceof String) || i + 1 >= arr.length) continue;
            ret.append(", ");
        }
        return ret.toString();
    }

    public static String arrayToStringExcept(Object[] arr, String n) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; arr != null && i < arr.length; ++i) {
            String s = arr[i].toString();
            if (s == null || s.equals(n)) continue;
            ret.append(s);
            if (!(arr[i] instanceof String) || i + 1 >= arr.length) continue;
            ret.append(", ");
        }
        return ret.toString();
    }

    public static <T> T[] concatArrays(T[] first, T[] second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        T[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static String getFullHumanReadableTime(long milliseconds) {
        long sc = 1000L;
        long mn = 60L * sc;
        long hr = 60L * mn;
        long dy = 24L * hr;
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(0);
        StringBuffer buff = new StringBuffer("");
        double relSize = 0.0;
        boolean showseconds = true;
        boolean showmillis = false;
        long abstime = Math.abs(milliseconds);
        String id = null;
        while (abstime >= 1L) {
            buff.append(" ");
            if (abstime / dy >= 1L) {
                showmillis = false;
                relSize = (double)abstime / (double)dy;
                abstime -= dy * (long)relSize;
                showseconds = false;
                id = "Days";
            } else if (abstime / hr >= 1L) {
                showmillis = false;
                relSize = (double)abstime / (double)hr;
                id = "Hours";
                abstime -= hr * (long)relSize;
            } else if (abstime / mn >= 1L) {
                showmillis = false;
                relSize = (double)abstime / (double)mn;
                id = "Mins";
                abstime -= mn * (long)relSize;
            } else if (abstime / sc >= 1L) {
                showmillis = false;
                relSize = (double)abstime / (double)sc;
                id = "Secs";
                abstime -= sc * (long)relSize;
                if (!showseconds) {
                    continue;
                }
            } else {
                if (showmillis) {
                    relSize = abstime;
                    id = "Millisconds";
                }
                abstime -= abstime;
                if (!showmillis) continue;
            }
            Object[] p = new Object[]{nf.format(Math.floor(relSize)), id};
            buff.append(MessageFormat.format("{0} {1}", p));
        }
        return buff.toString().trim();
    }

    public static String stripSpaces(String source) {
        return source.replaceAll("\\s+", "");
    }

    public static void makeGrid(Container parent, int rows, int cols, int initialX, int initialY, int xPad, int yPad) {
        SpringLayout.Constraints cons;
        int i;
        SpringLayout layout;
        try {
            layout = (SpringLayout)parent.getLayout();
        }
        catch (ClassCastException exc) {
            System.err.println("The first argument to makeGrid must use SpringLayout.");
            return;
        }
        Spring xPadSpring = Spring.constant(xPad);
        Spring yPadSpring = Spring.constant(yPad);
        Spring initialXSpring = Spring.constant(initialX);
        Spring initialYSpring = Spring.constant(initialY);
        int max = rows * cols;
        Spring maxWidthSpring = layout.getConstraints(parent.getComponent(0)).getWidth();
        Spring maxHeightSpring = layout.getConstraints(parent.getComponent(0)).getWidth();
        for (i = 1; i < max; ++i) {
            cons = layout.getConstraints(parent.getComponent(i));
            maxWidthSpring = Spring.max(maxWidthSpring, cons.getWidth());
            maxHeightSpring = Spring.max(maxHeightSpring, cons.getHeight());
        }
        for (i = 0; i < max; ++i) {
            cons = layout.getConstraints(parent.getComponent(i));
            cons.setWidth(maxWidthSpring);
            cons.setHeight(maxHeightSpring);
        }
        SpringLayout.Constraints lastCons = null;
        SpringLayout.Constraints lastRowCons = null;
        for (int i2 = 0; i2 < max; ++i2) {
            SpringLayout.Constraints cons2 = layout.getConstraints(parent.getComponent(i2));
            if (i2 % cols == 0) {
                lastRowCons = lastCons;
                cons2.setX(initialXSpring);
            } else {
                cons2.setX(Spring.sum(lastCons.getConstraint("East"), xPadSpring));
            }
            if (i2 / cols == 0) {
                cons2.setY(initialYSpring);
            } else {
                cons2.setY(Spring.sum(lastRowCons.getConstraint("South"), yPadSpring));
            }
            lastCons = cons2;
        }
        SpringLayout.Constraints pCons = layout.getConstraints(parent);
        pCons.setConstraint("South", Spring.sum(Spring.constant(yPad), lastCons.getConstraint("South")));
        pCons.setConstraint("East", Spring.sum(Spring.constant(xPad), lastCons.getConstraint("East")));
    }

    private static SpringLayout.Constraints getConstraintsForCell(int row, int col, Container parent, int cols) {
        SpringLayout layout = (SpringLayout)parent.getLayout();
        Component c = parent.getComponent(row * cols + col);
        return layout.getConstraints(c);
    }

    public static void makeCompactGrid(Container parent, int rows, int cols, int initialX, int initialY, int xPad, int yPad) {
        SpringLayout layout;
        try {
            layout = (SpringLayout)parent.getLayout();
        }
        catch (ClassCastException exc) {
            System.err.println("The first argument to makeCompactGrid must use SpringLayout.");
            return;
        }
        Spring x = Spring.constant(initialX);
        for (int c = 0; c < cols; ++c) {
            int r;
            Spring width = Spring.constant(0);
            for (r = 0; r < rows; ++r) {
                width = Spring.max(width, GemsUtilities.getConstraintsForCell(r, c, parent, cols).getWidth());
            }
            for (r = 0; r < rows; ++r) {
                SpringLayout.Constraints constraints = GemsUtilities.getConstraintsForCell(r, c, parent, cols);
                constraints.setX(x);
                constraints.setWidth(width);
            }
            x = Spring.sum(x, Spring.sum(width, Spring.constant(xPad)));
        }
        Spring y = Spring.constant(initialY);
        for (int r = 0; r < rows; ++r) {
            int c;
            Spring height = Spring.constant(0);
            for (c = 0; c < cols; ++c) {
                height = Spring.max(height, GemsUtilities.getConstraintsForCell(r, c, parent, cols).getHeight());
            }
            for (c = 0; c < cols; ++c) {
                SpringLayout.Constraints constraints = GemsUtilities.getConstraintsForCell(r, c, parent, cols);
                constraints.setY(y);
                constraints.setHeight(height);
            }
            y = Spring.sum(y, Spring.sum(height, Spring.constant(yPad)));
        }
        SpringLayout.Constraints pCons = layout.getConstraints(parent);
        pCons.setConstraint("South", y);
        pCons.setConstraint("East", x);
    }

    public static boolean isPrimitiveType(String className) {
        return primitiveTypes.contains(className);
    }

    public static Map getClassProperties(Class c) {
        String className = c.getName();
        if (classProperties.containsKey(className)) {
            return (Map)classProperties.get(className);
        }
        TreeMap<String, Property> propertyMap = new TreeMap<String, Property>();
        Method[] methods = c.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] parameterTypes;
            Property prop;
            Property prop2;
            String methodName = methods[i].getName();
            if (methodName.startsWith("get") || methodName.startsWith("is")) {
                int modifiers;
                Class<?>[] parameterTypes2 = methods[i].getParameterTypes();
                if (parameterTypes2.length > 0 || Modifier.isTransient(modifiers = methods[i].getModifiers())) continue;
                String propertyName = null;
                propertyName = methodName.startsWith("get") ? Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4) : Character.toLowerCase(methodName.charAt(2)) + methodName.substring(3);
                if (propertyMap.containsKey(propertyName)) {
                    prop2 = (Property)propertyMap.get(propertyName);
                    prop2.setGetter(methods[i]);
                    continue;
                }
                String returnClass = methods[i].getReturnType().getName();
                if (propertyName.equals("class")) continue;
                prop = new Property(propertyName, returnClass, null, methods[i]);
                propertyMap.put(propertyName, prop);
                continue;
            }
            if (!methodName.startsWith("set")) continue;
            String propertyName = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
            String returnClass = methods[i].getReturnType().getName();
            if (!returnClass.equals("void") || (parameterTypes = methods[i].getParameterTypes()).length != 1) continue;
            if (propertyMap.containsKey(propertyName)) {
                prop2 = (Property)propertyMap.get(propertyName);
                prop2.setSetter(methods[i]);
                continue;
            }
            String parameterClassName = parameterTypes[0].getName();
            prop = new Property(propertyName, parameterClassName, methods[i], null);
            propertyMap.put(propertyName, prop);
        }
        classProperties.put(className, propertyMap);
        return propertyMap;
    }

    public static Map getWriteableProperties(Class c) {
        Map props = GemsUtilities.getClassProperties(c);
        TreeMap<String, String> propertyMap = new TreeMap<String, String>();
        for (String name : props.keySet()) {
            Property prop = (Property)props.get(name);
            if (!prop.isWriteable()) continue;
            propertyMap.put(name, prop.getClassType());
        }
        return propertyMap;
    }

    public static Object buildObject(String className, Map propertyMap) {
        try {
            Class<?> c = Class.forName(className);
            Object o = c.newInstance();
            Method[] methods = c.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                String value;
                String parameterClassName;
                Class<?>[] parameterTypes;
                String methodName = methods[i].getName();
                if (!methodName.startsWith("set")) continue;
                String propertyName = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
                String returnClass = methods[i].getReturnType().getName();
                if (!returnClass.equals("void") || (parameterTypes = methods[i].getParameterTypes()).length != 1 || !propertyMap.containsKey(propertyName) || !primitiveTypes.contains(parameterClassName = parameterTypes[0].getName()) || (value = (String)propertyMap.get(propertyName)) == null || value.length() <= 0) continue;
                Object[] parameters = new Object[]{GemsUtilities.convertStringToObjectWrapper(parameterClassName, value)};
                methods[i].invoke(o, parameters);
            }
            return o;
        }
        catch (Exception e) {
            System.err.println(e.getClass() + ": " + e.getMessage());
            return null;
        }
    }

    public static Vector getStatsMethodNames(Class c) {
        Vector<String> v = new Vector<String>();
        Method[] methods = c.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            int modifiers;
            Class<?>[] parameterTypes;
            String methodName = methods[i].getName();
            if (!methodName.startsWith("get") || (parameterTypes = methods[i].getParameterTypes()).length > 0 || Modifier.isTransient(modifiers = methods[i].getModifiers()) || !methods[i].getReturnType().getName().equals("long") && !methods[i].getReturnType().getName().equals("int") || !methodName.contains("MsgMem") && !methodName.contains("Size") && !methodName.contains("Count") && !methodName.contains("Rate") || methodName.contains("Log") || methodName.contains("Trace") || methodName.contains("SSL") || methodName.contains("Max") || methodName.contains("MessagePool") || methodName.endsWith("Interval")) continue;
            String displayName = Character.isLowerCase(methodName.charAt(4)) ? Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4) : methodName.substring(3);
            v.add(displayName);
        }
        return v;
    }

    public static Hashtable getStatsMethodValues(Object obj) {
        Hashtable<String, Object> h = new Hashtable<String, Object>();
        Class<?> c = obj.getClass();
        Method[] methods = c.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            int modifiers;
            Class<?>[] parameterTypes;
            String methodName = methods[i].getName();
            if (!methodName.startsWith("get") || (parameterTypes = methods[i].getParameterTypes()).length > 0 || Modifier.isTransient(modifiers = methods[i].getModifiers())) continue;
            try {
                if (!methods[i].getReturnType().getName().equals("long") && !methods[i].getReturnType().getName().equals("int") || !methodName.contains("MsgMem") && !methodName.contains("Size") && !methodName.contains("Count") && !methodName.contains("Rate") || methodName.contains("Log") || methodName.contains("Trace") || methodName.contains("SSL") || methodName.contains("Max") || methodName.contains("MessagePool") || methodName.endsWith("Interval")) continue;
                String displayName = Character.isLowerCase(methodName.charAt(4)) ? Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4) : methodName.substring(3);
                Object ret = methods[i].invoke(obj, (Object[])null);
                h.put(displayName, ret);
                continue;
            }
            catch (Throwable e) {
                System.err.println(e.getClass() + ": " + e.getMessage());
            }
        }
        return h;
    }

    private static Object convertStringToObjectWrapper(String className, String value) {
        Object o = null;
        if (className.equals("java.lang.Integer") || className.equals("int")) {
            o = new Integer(value);
        } else if (className.equals("java.lang.Long") || className.equals("long")) {
            o = new Long(value);
        } else if (className.equals("java.lang.Short") || className.equals("short")) {
            o = new Short(value);
        } else if (className.equals("java.lang.Byte") || className.equals("byte")) {
            o = new Byte(value);
        } else if (className.equals("java.lang.Float") || className.equals("float")) {
            o = new Float(value);
        } else if (className.equals("java.lang.Double") || className.equals("double")) {
            o = new Double(value);
        } else if (className.equals("java.lang.String")) {
            o = value;
        } else if (className.equals("java.lang.Boolean") || className.equals("boolean")) {
            o = new Boolean(value);
        }
        return o;
    }

    public static String getPropValueFromString(String prop, String str, HashMap list) {
        int i = str.indexOf(prop);
        if (i >= 0) {
            int j = str.indexOf(44, i += prop.length() + 1);
            if (j >= 0) {
                if (list == null) {
                    return str.substring(i, j);
                }
                while (j > 0) {
                    int k = str.indexOf(61, j);
                    if (k >= 0 && list.containsKey(str.substring(j + 1, k))) {
                        return str.substring(i, j);
                    }
                    ++j;
                    j = str.indexOf(44, j);
                }
            } else {
                return str.substring(i);
            }
        }
        return null;
    }

    static {
        primitiveTypes.add("byte");
        primitiveTypes.add("short");
        primitiveTypes.add("int");
        primitiveTypes.add("long");
        primitiveTypes.add("float");
        primitiveTypes.add("double");
        primitiveTypes.add("boolean");
        primitiveTypes.add("java.lang.String");
        primitiveTypes.add("java.lang.Byte");
        primitiveTypes.add("java.lang.Short");
        primitiveTypes.add("java.lang.Integer");
        primitiveTypes.add("java.lang.Long");
        primitiveTypes.add("java.lang.Float");
        primitiveTypes.add("java.lang.Double");
        primitiveTypes.add("java.lang.Boolean");
        classProperties = new TreeMap();
    }

    private static class Property {
        private String name;
        private Method setter;
        private Method getter;
        private boolean readable;
        private boolean writeable;
        private String classType;

        public Property() {
        }

        public Property(String name, String classType, Method setter, Method getter) {
            this.name = name;
            this.classType = classType;
            this.setter = setter;
            this.getter = getter;
            this.writeable = setter != null;
            this.readable = getter != null;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Method getSetter() {
            return this.setter;
        }

        public void setSetter(Method setter) {
            this.setter = setter;
            if (setter != null) {
                this.writeable = true;
            }
        }

        public Method getGetter() {
            return this.getter;
        }

        public void setGetter(Method getter) {
            this.getter = getter;
            if (getter != null) {
                this.readable = true;
            }
        }

        public boolean isReadable() {
            return this.readable;
        }

        public void setReadable(boolean readable) {
            this.readable = readable;
        }

        public boolean isWriteable() {
            return this.writeable;
        }

        public void setWriteable(boolean writeable) {
            this.writeable = writeable;
        }

        public String getClassType() {
            return this.classType;
        }

        public void setClassType(String classType) {
            this.classType = classType;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("Property(").append(this.name).append(": ");
            sb.append(this.classType).append(") -> ");
            if (this.readable) {
                sb.append("getter: ").append(this.getter.getName());
            }
            if (this.writeable) {
                sb.append(", setter: ").append(this.setter.getName());
            }
            return sb.toString();
        }
    }
}

