/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsBridgeTableModel;
import com.tibco.gems.GemsManageBridgesDialog;
import com.tibco.gems.PopupTableHandler;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JTable;

public class PopupBridgeTableHandler
extends PopupTableHandler {
    public AbstractAction selAll = null;
    public AbstractAction createTar = null;
    public AbstractAction delBridge = null;
    public AbstractAction delSelBridges = null;
    public GemsBridgeTableModel m_model;
    GemsManageBridgesDialog m_manager = null;

    public PopupBridgeTableHandler(JTable tab, GemsBridgeTableModel mod, GemsManageBridgesDialog m) {
        super(tab);
        this.m_model = mod;
        this.m_manager = m;
    }

    @Override
    public JPopupMenu createPopup(Point loc) {
        JPopupMenu popup = super.createPopup(loc);
        if (this.m_model.m_showCheckbox) {
            if (this.selAll == null) {
                this.selAll = new TableSelectAllAction("Select All", null);
            }
            popup.insert(this.selAll, 1);
        }
        if (!Gems.getGems().getViewOnlyMode()) {
            if (this.createTar == null) {
                this.createTar = new CreateTargetAction("Create New Target...", null);
            }
            if (this.delBridge == null) {
                this.delBridge = new DeleteBridgeAction("Destroy Bridge", null);
            }
            if (this.delSelBridges == null) {
                this.delSelBridges = new DeleteSelectedBridgesAction("Destroy Selected Bridges", null);
            }
            popup.addSeparator();
            popup.add(this.createTar);
            popup.addSeparator();
            popup.add(this.delBridge);
            popup.add(this.delSelBridges);
        }
        return popup;
    }

    public class DeleteSelectedBridgesAction
    extends AbstractAction {
        public DeleteSelectedBridgesAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PopupBridgeTableHandler.this.m_manager.deleteSelectedBridges();
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }

    public class DeleteBridgeAction
    extends AbstractAction {
        public DeleteBridgeAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String v1 = PopupBridgeTableHandler.this.m_table.getModel().getValueAt(PopupBridgeTableHandler.this.m_row, 1).toString();
            String v2 = PopupBridgeTableHandler.this.m_table.getModel().getValueAt(PopupBridgeTableHandler.this.m_row, 2).toString();
            String v3 = PopupBridgeTableHandler.this.m_table.getModel().getValueAt(PopupBridgeTableHandler.this.m_row, 3).toString();
            String v4 = PopupBridgeTableHandler.this.m_table.getModel().getValueAt(PopupBridgeTableHandler.this.m_row, 4).toString();
            PopupBridgeTableHandler.this.m_manager.deleteBridge(v1, v2, v3, v4);
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }

    public class CreateTargetAction
    extends AbstractAction {
        public CreateTargetAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String v = PopupBridgeTableHandler.this.m_table.getModel().getValueAt(PopupBridgeTableHandler.this.m_row, 1).toString();
            PopupBridgeTableHandler.this.m_manager.createBridge(v);
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }

    public class TableSelectAllAction
    extends AbstractAction {
        public TableSelectAllAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PopupBridgeTableHandler.this.m_model.selectAllRows();
        }
    }
}

