/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsConsumerDisplay;
import com.tibco.gems.GemsDestPropEditor;
import com.tibco.gems.GemsDetailsTableModel;
import com.tibco.gems.GemsMessageFrame;
import com.tibco.gems.GemsQueueBrowser;
import com.tibco.gems.GemsTopicSubscriber;
import com.tibco.gems.PopupTableHandler;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;

public class PopupDestDisplayHandler
extends PopupTableHandler {
    public AbstractAction bq = null;
    public AbstractAction qp = null;
    public AbstractAction stm = null;
    public AbstractAction smm = null;
    public AbstractAction qcon = null;
    public AbstractAction ts = null;
    public AbstractAction tp = null;
    public AbstractAction ptm = null;
    public AbstractAction pmm = null;
    public AbstractAction tcon = null;
    public AbstractAction qpur = null;
    public AbstractAction tpur = null;
    public GemsDetailsTableModel m_model;
    public GemsConnectionNode m_cn;
    public JFrame m_frame;

    public PopupDestDisplayHandler(JTable tab, GemsDetailsTableModel mod, GemsConnectionNode cn, JFrame frame) {
        super(tab);
        this.m_model = mod;
        this.m_cn = cn;
        this.m_frame = frame;
    }

    @Override
    public JPopupMenu createPopup(Point loc) {
        JPopupMenu popup = super.createPopup(loc);
        if (this.m_model.getColumnName(0).equals("QueueName")) {
            if (this.bq == null) {
                this.bq = new BrowseQueueAction("Browse Queue...", null);
            }
            if (this.qp == null) {
                this.qp = new SetPropertyAction("Queue Properties...", null);
            }
            if (this.qcon == null) {
                this.qcon = new ShowConsumersAction("Queue Consumers...", null);
            }
            if (this.stm == null) {
                this.stm = new SendTextMessageAction("Send TextMessage...", null);
            }
            if (this.smm == null) {
                this.smm = new SendMapMessageAction("Send MapMessage...", null);
            }
            if (this.qpur == null) {
                this.qpur = new PurgeAction("Purge Queue...", null);
            }
            popup.addSeparator();
            popup.add(this.bq);
            popup.add(this.qp);
            popup.add(this.qcon);
            popup.addSeparator();
            popup.add(this.stm);
            popup.add(this.smm);
            popup.addSeparator();
            popup.add(this.qpur);
        } else if (this.m_model.getColumnName(0).equals("TopicName")) {
            if (this.ts == null) {
                this.ts = new TopicSubscriberAction("Topic Subscriber...", null);
            }
            if (this.tp == null) {
                this.tp = new SetPropertyAction("Topic Properties...", null);
            }
            if (this.tcon == null) {
                this.tcon = new ShowConsumersAction("Topic Consumers...", null);
            }
            if (this.ptm == null) {
                this.ptm = new PublishTextMessageAction("Publish TextMessage...", null);
            }
            if (this.pmm == null) {
                this.pmm = new PublishMapMessageAction("Publish MapMessage...", null);
            }
            if (this.tpur == null) {
                this.tpur = new PurgeAction("Purge Topic...", null);
            }
            popup.addSeparator();
            popup.add(this.ts);
            popup.add(this.tp);
            popup.add(this.tcon);
            popup.addSeparator();
            popup.add(this.ptm);
            popup.add(this.pmm);
            popup.addSeparator();
            popup.add(this.tpur);
        }
        return popup;
    }

    public class PurgeAction
    extends AbstractAction {
        public PurgeAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String dest = null;
            if (PopupDestDisplayHandler.this.m_cn != null) {
                if (PopupDestDisplayHandler.this.m_model.getColumnName(0).equals("TopicName")) {
                    dest = (String)PopupDestDisplayHandler.this.m_table.getModel().getValueAt(PopupDestDisplayHandler.this.m_row, 0);
                    int opt = JOptionPane.showConfirmDialog(PopupDestDisplayHandler.this.m_frame, "Purge Topic: " + dest, "Purge Topic", 0);
                    if (opt == 0) {
                        PopupDestDisplayHandler.this.m_cn.purgeTopic(dest);
                        Gems.getGems().scheduleRepaint();
                    }
                } else if (PopupDestDisplayHandler.this.m_model.getColumnName(0).equals("QueueName")) {
                    dest = (String)PopupDestDisplayHandler.this.m_table.getModel().getValueAt(PopupDestDisplayHandler.this.m_row, 0);
                    int opt = JOptionPane.showConfirmDialog(PopupDestDisplayHandler.this.m_frame, "Purge Queue: " + dest, "Purge Queue", 0);
                    if (opt == 0) {
                        PopupDestDisplayHandler.this.m_cn.purgeQueue(dest);
                        Gems.getGems().scheduleRepaint();
                    }
                }
            }
        }

        @Override
        public boolean isEnabled() {
            return !Gems.getGems().getViewOnlyMode();
        }
    }

    public class BrowseQueueAction
    extends AbstractAction {
        public BrowseQueueAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PopupDestDisplayHandler.this.m_cn != null) {
                new GemsQueueBrowser(PopupDestDisplayHandler.this.m_cn, (String)PopupDestDisplayHandler.this.m_table.getModel().getValueAt(PopupDestDisplayHandler.this.m_row, 0));
            }
        }

        @Override
        public boolean isEnabled() {
            return !Gems.getGems().getViewOnlyMode() || Gems.getGems().getAllowMsgReadInViewOnlyMode();
        }
    }

    public class SendTextMessageAction
    extends AbstractAction {
        public SendTextMessageAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PopupDestDisplayHandler.this.m_cn != null) {
                new GemsMessageFrame(PopupDestDisplayHandler.this.m_cn, true, (String)PopupDestDisplayHandler.this.m_table.getModel().getValueAt(PopupDestDisplayHandler.this.m_row, 0), true, PopupDestDisplayHandler.this.m_frame, false);
            }
        }

        @Override
        public boolean isEnabled() {
            return !Gems.getGems().getViewOnlyMode();
        }
    }

    public class SendMapMessageAction
    extends AbstractAction {
        public SendMapMessageAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PopupDestDisplayHandler.this.m_cn != null) {
                new GemsMessageFrame(PopupDestDisplayHandler.this.m_cn, true, (String)PopupDestDisplayHandler.this.m_table.getModel().getValueAt(PopupDestDisplayHandler.this.m_row, 0), true, PopupDestDisplayHandler.this.m_frame, false, true);
            }
        }

        @Override
        public boolean isEnabled() {
            return !Gems.getGems().getViewOnlyMode();
        }
    }

    public class TopicSubscriberAction
    extends AbstractAction {
        public TopicSubscriberAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PopupDestDisplayHandler.this.m_cn != null) {
                new GemsTopicSubscriber(PopupDestDisplayHandler.this.m_cn, (String)PopupDestDisplayHandler.this.m_table.getModel().getValueAt(PopupDestDisplayHandler.this.m_row, 0), "Topic Subscriber");
            }
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }

    public class PublishMapMessageAction
    extends AbstractAction {
        public PublishMapMessageAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PopupDestDisplayHandler.this.m_cn != null) {
                new GemsMessageFrame(PopupDestDisplayHandler.this.m_cn, true, (String)PopupDestDisplayHandler.this.m_table.getModel().getValueAt(PopupDestDisplayHandler.this.m_row, 0), false, PopupDestDisplayHandler.this.m_frame, false, true);
            }
        }

        @Override
        public boolean isEnabled() {
            return !Gems.getGems().getViewOnlyMode();
        }
    }

    public class PublishTextMessageAction
    extends AbstractAction {
        public PublishTextMessageAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PopupDestDisplayHandler.this.m_cn != null) {
                new GemsMessageFrame(PopupDestDisplayHandler.this.m_cn, true, (String)PopupDestDisplayHandler.this.m_table.getModel().getValueAt(PopupDestDisplayHandler.this.m_row, 0), false, PopupDestDisplayHandler.this.m_frame, false);
            }
        }

        @Override
        public boolean isEnabled() {
            return !Gems.getGems().getViewOnlyMode();
        }
    }

    public class SetPropertyAction
    extends AbstractAction {
        public SetPropertyAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String dest = null;
            Object prop = null;
            if (PopupDestDisplayHandler.this.m_cn != null) {
                if (PopupDestDisplayHandler.this.m_model.getColumnName(0).equals("TopicName")) {
                    dest = (String)PopupDestDisplayHandler.this.m_table.getModel().getValueAt(PopupDestDisplayHandler.this.m_row, 0);
                    GemsDestPropEditor d = new GemsDestPropEditor(PopupDestDisplayHandler.this.m_frame, PopupDestDisplayHandler.this.m_cn, "Topic", dest);
                } else if (PopupDestDisplayHandler.this.m_model.getColumnName(0).equals("QueueName")) {
                    dest = (String)PopupDestDisplayHandler.this.m_table.getModel().getValueAt(PopupDestDisplayHandler.this.m_row, 0);
                    GemsDestPropEditor gemsDestPropEditor = new GemsDestPropEditor(PopupDestDisplayHandler.this.m_frame, PopupDestDisplayHandler.this.m_cn, "Queue", dest);
                }
            }
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }

    public class ShowConsumersAction
    extends AbstractAction {
        public ShowConsumersAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String dest = null;
            Object prop = null;
            if (PopupDestDisplayHandler.this.m_cn != null) {
                if (PopupDestDisplayHandler.this.m_model.getColumnName(0).equals("TopicName")) {
                    dest = (String)PopupDestDisplayHandler.this.m_table.getModel().getValueAt(PopupDestDisplayHandler.this.m_row, 0);
                    GemsConsumerDisplay d = new GemsConsumerDisplay(PopupDestDisplayHandler.this.m_cn, "Topic", dest);
                } else if (PopupDestDisplayHandler.this.m_model.getColumnName(0).equals("QueueName")) {
                    dest = (String)PopupDestDisplayHandler.this.m_table.getModel().getValueAt(PopupDestDisplayHandler.this.m_row, 0);
                    GemsConsumerDisplay gemsConsumerDisplay = new GemsConsumerDisplay(PopupDestDisplayHandler.this.m_cn, "Queue", dest);
                }
            }
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }
}

