/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsConsumerDisplay;
import com.tibco.gems.GemsDestPropEditor;
import com.tibco.gems.GemsDetailsTableModel;
import com.tibco.gems.GemsMessageFrame;
import com.tibco.gems.GemsQueueBrowser;
import com.tibco.gems.GemsQueueNode;
import com.tibco.gems.GemsTopicNode;
import com.tibco.gems.GemsTopicSubscriber;
import com.tibco.gems.PopupTableHandler;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class PopupDetailsTableHandler
extends PopupTableHandler {
    public AbstractAction bq = null;
    public AbstractAction qp = null;
    public AbstractAction stm = null;
    public AbstractAction smm = null;
    public AbstractAction qcon = null;
    public AbstractAction ts = null;
    public AbstractAction tp = null;
    public AbstractAction ptm = null;
    public AbstractAction pmm = null;
    public AbstractAction tcon = null;
    public AbstractAction qpur = null;
    public AbstractAction tpur = null;
    public AbstractAction sp = null;
    public AbstractAction gc = null;
    public AbstractAction cltro = null;
    public AbstractAction cltre = null;
    public GemsDetailsTableModel m_model;

    public PopupDetailsTableHandler(JTable tab, GemsDetailsTableModel mod) {
        super(tab);
        this.m_model = mod;
    }

    @Override
    public JPopupMenu createPopup(Point loc) {
        JPopupMenu popup = super.createPopup(loc);
        if (this.m_model.getColumnName(0).equals("QueueName")) {
            if (this.bq == null) {
                this.bq = new BrowseQueueAction("Browse Queue...", null);
            }
            if (this.qp == null) {
                this.qp = new SetPropertyAction("Queue Properties...", null);
            }
            if (this.stm == null) {
                this.qcon = new ShowConsumersAction("Queue Consumers...", null);
            }
            if (this.stm == null) {
                this.stm = new SendTextMessageAction("Send TextMessage...", null);
            }
            if (this.smm == null) {
                this.smm = new SendMapMessageAction("Send MapMessage...", null);
            }
            if (this.qpur == null) {
                this.qpur = new PurgeAction("Purge Queue...", null);
            }
            popup.addSeparator();
            popup.add(this.bq);
            popup.add(this.qp);
            popup.add(this.qcon);
            popup.addSeparator();
            popup.add(this.stm);
            popup.add(this.smm);
            popup.addSeparator();
            popup.add(this.qpur);
        } else if (this.m_model.getColumnName(0).equals("TopicName")) {
            if (this.ts == null) {
                this.ts = new TopicSubscriberAction("Topic Subscriber...", null);
            }
            if (this.tp == null) {
                this.tp = new SetPropertyAction("Topic Properties...", null);
            }
            if (this.tcon == null) {
                this.tcon = new ShowConsumersAction("Topic Consumers...", null);
            }
            if (this.ptm == null) {
                this.ptm = new PublishTextMessageAction("Publish TextMessage...", null);
            }
            if (this.pmm == null) {
                this.pmm = new PublishMapMessageAction("Publish MapMessage...", null);
            }
            if (this.tpur == null) {
                this.tpur = new PurgeAction("Purge Topic...", null);
            }
            popup.addSeparator();
            popup.add(this.ts);
            popup.add(this.tp);
            popup.add(this.tcon);
            popup.addSeparator();
            popup.add(this.ptm);
            popup.add(this.pmm);
            popup.addSeparator();
            popup.add(this.tpur);
        } else if (this.m_model.getColumnName(0).equals("ID") && this.m_model.getColumnName(2).equals("Host")) {
            if (this.cltro == null) {
                this.cltro = new ClientTraceAction("To stdout...", null, true);
            }
            if (this.cltre == null) {
                this.cltre = new ClientTraceAction("To stderr...", null, false);
            }
            popup.addSeparator();
            JMenu stm = new JMenu("Enable Client Trace");
            stm.add(this.cltro);
            stm.add(this.cltre);
            popup.add(stm);
        } else if (this.m_model.getColumnCount() == 2 && (this.m_model.getColumnName(0).equals("QueueProperty") || this.m_model.getColumnName(0).equals("TopicProperty"))) {
            if (this.sp == null) {
                this.sp = new SetPropertyAction("Set Property...", null);
            }
            popup.addSeparator();
            popup.add(this.sp);
        } else if (this.m_model.getColumnCount() > 15 && this.m_model.getColumnName(0).equals("ID") && this.m_model.getColumnName(15).equals("ConnectionID")) {
            if (this.gc == null) {
                this.gc = new GotoConnectionAction("Go To Connection", null);
            }
            popup.addSeparator();
            popup.add(this.gc);
        } else if (this.m_model.getColumnCount() > 4 && this.m_model.getColumnName(0).equals("ID") && this.m_model.getColumnName(4).equals("ConnectionID")) {
            if (this.gc == null) {
                this.gc = new GotoConnectionAction("Go To Connection", null);
            }
            popup.addSeparator();
            popup.add(this.gc);
        }
        return popup;
    }

    public class PurgeAction
    extends AbstractAction {
        public PurgeAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsConnectionNode cn = Gems.getGems().getConnectionNode();
            String dest = null;
            if (cn != null) {
                if (PopupDetailsTableHandler.this.m_model.getColumnName(0).equals("TopicName")) {
                    dest = (String)PopupDetailsTableHandler.this.m_table.getModel().getValueAt(PopupDetailsTableHandler.this.m_row, 0);
                    int opt = JOptionPane.showConfirmDialog(Gems.getGems().m_frame, "Purge Topic: " + dest, "Purge Topic", 0);
                    if (opt == 0) {
                        cn.purgeTopic(dest);
                        Gems.getGems().scheduleRepaint();
                    }
                } else if (PopupDetailsTableHandler.this.m_model.getColumnName(0).equals("QueueName")) {
                    dest = (String)PopupDetailsTableHandler.this.m_table.getModel().getValueAt(PopupDetailsTableHandler.this.m_row, 0);
                    int opt = JOptionPane.showConfirmDialog(Gems.getGems().m_frame, "Purge Queue: " + dest, "Purge Queue", 0);
                    if (opt == 0) {
                        cn.purgeQueue(dest);
                        Gems.getGems().scheduleRepaint();
                    }
                }
            }
        }

        @Override
        public boolean isEnabled() {
            return !Gems.getGems().getViewOnlyMode();
        }
    }

    public class BrowseQueueAction
    extends AbstractAction {
        public BrowseQueueAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsConnectionNode cn = Gems.getGems().getConnectionNode();
            if (cn != null) {
                new GemsQueueBrowser(cn, (String)PopupDetailsTableHandler.this.m_table.getModel().getValueAt(PopupDetailsTableHandler.this.m_row, 0));
            }
        }

        @Override
        public boolean isEnabled() {
            return !Gems.getGems().getViewOnlyMode() || Gems.getGems().getAllowMsgReadInViewOnlyMode();
        }
    }

    public class SendTextMessageAction
    extends AbstractAction {
        public SendTextMessageAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsConnectionNode cn = Gems.getGems().getConnectionNode();
            if (cn != null) {
                new GemsMessageFrame(cn, true, (String)PopupDetailsTableHandler.this.m_table.getModel().getValueAt(PopupDetailsTableHandler.this.m_row, 0), true, Gems.getGems().m_frame, false);
            }
        }

        @Override
        public boolean isEnabled() {
            return !Gems.getGems().getViewOnlyMode();
        }
    }

    public class SendMapMessageAction
    extends AbstractAction {
        public SendMapMessageAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsConnectionNode cn = Gems.getGems().getConnectionNode();
            if (cn != null) {
                new GemsMessageFrame(cn, true, (String)PopupDetailsTableHandler.this.m_table.getModel().getValueAt(PopupDetailsTableHandler.this.m_row, 0), true, Gems.getGems().m_frame, false, true);
            }
        }

        @Override
        public boolean isEnabled() {
            return !Gems.getGems().getViewOnlyMode();
        }
    }

    public class TopicSubscriberAction
    extends AbstractAction {
        public TopicSubscriberAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsConnectionNode cn = Gems.getGems().getConnectionNode();
            if (cn != null) {
                new GemsTopicSubscriber(cn, (String)PopupDetailsTableHandler.this.m_table.getModel().getValueAt(PopupDetailsTableHandler.this.m_row, 0), "Topic Subscriber");
            }
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }

    public class PublishMapMessageAction
    extends AbstractAction {
        public PublishMapMessageAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsConnectionNode cn = Gems.getGems().getConnectionNode();
            if (cn != null) {
                new GemsMessageFrame(cn, true, (String)PopupDetailsTableHandler.this.m_table.getModel().getValueAt(PopupDetailsTableHandler.this.m_row, 0), false, Gems.getGems().m_frame, false, true);
            }
        }

        @Override
        public boolean isEnabled() {
            return !Gems.getGems().getViewOnlyMode();
        }
    }

    public class PublishTextMessageAction
    extends AbstractAction {
        public PublishTextMessageAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsConnectionNode cn = Gems.getGems().getConnectionNode();
            if (cn != null) {
                new GemsMessageFrame(cn, true, (String)PopupDetailsTableHandler.this.m_table.getModel().getValueAt(PopupDetailsTableHandler.this.m_row, 0), false, Gems.getGems().m_frame, false);
            }
        }

        @Override
        public boolean isEnabled() {
            return !Gems.getGems().getViewOnlyMode();
        }
    }

    public class SetPropertyAction
    extends AbstractAction {
        public SetPropertyAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsConnectionNode cn = Gems.getGems().getConnectionNode();
            String dest = null;
            String prop = null;
            if (cn != null) {
                if (PopupDetailsTableHandler.this.m_model.getColumnName(0).equals("TopicName")) {
                    dest = (String)PopupDetailsTableHandler.this.m_table.getModel().getValueAt(PopupDetailsTableHandler.this.m_row, 0);
                    GemsDestPropEditor d = new GemsDestPropEditor(Gems.getGems().m_frame, cn, "Topic", dest);
                } else if (PopupDetailsTableHandler.this.m_model.getColumnName(0).equals("QueueName")) {
                    dest = (String)PopupDetailsTableHandler.this.m_table.getModel().getValueAt(PopupDetailsTableHandler.this.m_row, 0);
                    GemsDestPropEditor d = new GemsDestPropEditor(Gems.getGems().m_frame, cn, "Queue", dest);
                } else {
                    DefaultMutableTreeNode parent;
                    DefaultMutableTreeNode node = Gems.getGems().getSelectedNode();
                    if (node != null && (parent = (DefaultMutableTreeNode)node.getParent()) != null) {
                        prop = (String)PopupDetailsTableHandler.this.m_table.getModel().getValueAt(PopupDetailsTableHandler.this.m_row, 0);
                        if (((String)parent.getUserObject()).startsWith("Topics")) {
                            ((GemsTopicNode)node).setProperty(cn, prop);
                        } else if (((String)parent.getUserObject()).startsWith("Queues")) {
                            ((GemsQueueNode)node).setProperty(cn, prop);
                        }
                    }
                }
            }
        }

        public void actionPerformedOLD(ActionEvent e) {
            GemsConnectionNode cn = Gems.getGems().getConnectionNode();
            DefaultMutableTreeNode node = Gems.getGems().getSelectedNode();
            String dn = null;
            String prop = null;
            if (cn != null && node != null) {
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                String nodename = (String)node.getUserObject();
                if (nodename.startsWith("Topics") || nodename.startsWith("Queues")) {
                    dn = (String)PopupDetailsTableHandler.this.m_table.getModel().getValueAt(PopupDetailsTableHandler.this.m_row, 0);
                    if (dn != null) {
                        Enumeration<TreeNode> ch = node.children();
                        while (ch.hasMoreElements()) {
                            DefaultMutableTreeNode n = (DefaultMutableTreeNode)ch.nextElement();
                            if (n == null || !dn.equals((String)n.getUserObject())) continue;
                            String dest = (String)PopupDetailsTableHandler.this.m_table.getModel().getValueAt(PopupDetailsTableHandler.this.m_row, 0);
                            if (PopupDetailsTableHandler.this.m_model.getColumnName(0).equals("TopicName")) {
                                GemsDestPropEditor d = new GemsDestPropEditor(Gems.getGems().m_frame, cn, "Topic", dest);
                            } else {
                                GemsDestPropEditor d = new GemsDestPropEditor(Gems.getGems().m_frame, cn, "Queue", dest);
                            }
                            return;
                        }
                    }
                } else if (parent != null) {
                    prop = (String)PopupDetailsTableHandler.this.m_table.getModel().getValueAt(PopupDetailsTableHandler.this.m_row, 0);
                    if (((String)parent.getUserObject()).startsWith("Topics")) {
                        ((GemsTopicNode)node).setProperty(cn, prop);
                    } else {
                        ((GemsQueueNode)node).setProperty(cn, prop);
                    }
                }
            }
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }

    public class GotoConnectionAction
    extends AbstractAction {
        public GotoConnectionAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cid = null;
            Object v = PopupDetailsTableHandler.this.m_model.getColumnName(4).equals("ConnectionID") ? PopupDetailsTableHandler.this.m_table.getValueAt(PopupDetailsTableHandler.this.m_row, 4) : PopupDetailsTableHandler.this.m_table.getValueAt(PopupDetailsTableHandler.this.m_row, 15);
            if (v != null) {
                cid = v instanceof Long ? String.valueOf((Long)v) : (String)v;
            }
            if (cid != null && !cid.equals("0")) {
                Gems.getGems().getTreeModel().selectConnection(cid);
            }
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }

    public class ShowConsumersAction
    extends AbstractAction {
        public ShowConsumersAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsConnectionNode cn = Gems.getGems().getConnectionNode();
            String dest = null;
            Object prop = null;
            if (cn != null) {
                if (PopupDetailsTableHandler.this.m_model.getColumnName(0).equals("TopicName")) {
                    dest = (String)PopupDetailsTableHandler.this.m_table.getModel().getValueAt(PopupDetailsTableHandler.this.m_row, 0);
                    GemsConsumerDisplay d = new GemsConsumerDisplay(cn, "Topic", dest);
                } else if (PopupDetailsTableHandler.this.m_model.getColumnName(0).equals("QueueName")) {
                    dest = (String)PopupDetailsTableHandler.this.m_table.getModel().getValueAt(PopupDetailsTableHandler.this.m_row, 0);
                    GemsConsumerDisplay gemsConsumerDisplay = new GemsConsumerDisplay(cn, "Queue", dest);
                }
            }
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }

    public class ClientTraceAction
    extends AbstractAction {
        boolean isStdout;

        public ClientTraceAction(String text, Icon icon, boolean isStdout) {
            super(text, icon);
            this.isStdout = isStdout;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsConnectionNode cn = Gems.getGems().getConnectionNode();
            String user = null;
            String host = null;
            Long id = null;
            if (cn != null && PopupDetailsTableHandler.this.m_model.getColumnName(0).equals("ID")) {
                id = (Long)PopupDetailsTableHandler.this.m_table.getModel().getValueAt(PopupDetailsTableHandler.this.m_row, 0);
                user = (String)PopupDetailsTableHandler.this.m_table.getModel().getValueAt(PopupDetailsTableHandler.this.m_row, 11);
                host = (String)PopupDetailsTableHandler.this.m_table.getModel().getValueAt(PopupDetailsTableHandler.this.m_row, 2);
                cn.enableClientTrace(id, user, host, this.isStdout);
            }
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }
}

