/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;

public class PopupHandler {
    public JPopupMenu createPopup(Point loc) {
        JPopupMenu popup = new JPopupMenu();
        return popup;
    }

    public class SelectAllAction
    extends TextAction {
        public SelectAllAction(String text, Icon icon) {
            super(text, icon);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl A"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.txtcomp.selectAll();
        }

        @Override
        public boolean isEnabled() {
            return this.txtcomp != null && this.txtcomp.isEnabled() && this.txtcomp.getText().length() > 0 && (this.txtcomp.getSelectedText() == null || this.txtcomp.getSelectedText().length() < this.txtcomp.getText().length());
        }
    }

    public class PasteAction
    extends TextAction {
        public PasteAction(String text, Icon icon) {
            super(text, icon);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl V"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.txtcomp.paste();
        }

        @Override
        public boolean isEnabled() {
            Transferable content = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            return this.txtcomp != null && this.txtcomp.isEnabled() && this.txtcomp.isEditable() && content.isDataFlavorSupported(DataFlavor.stringFlavor);
        }
    }

    public class CopyAction
    extends TextAction {
        public CopyAction(String text, Icon icon) {
            super(text, icon);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl C"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.txtcomp.copy();
        }

        @Override
        public boolean isEnabled() {
            return this.txtcomp != null && this.txtcomp.getSelectedText() != null;
        }
    }

    public class CutAction
    extends TextAction {
        public CutAction(String text, Icon icon) {
            super(text, icon);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl X"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.txtcomp.cut();
        }

        @Override
        public boolean isEnabled() {
            return this.txtcomp != null && this.txtcomp.isEditable() && this.txtcomp.getSelectedText() != null;
        }
    }

    public abstract class TextAction
    extends AbstractAction {
        JTextComponent txtcomp;

        public TextAction(String text, Icon icon) {
            super(text, icon);
            this.putValue("ShortDescription", text);
        }

        public void setTextComponent(JTextComponent comp) {
            this.txtcomp = comp;
        }

        @Override
        public abstract void actionPerformed(ActionEvent var1);
    }
}

