/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsEventMessageTableModel;
import com.tibco.gems.GemsMessageFrame;
import com.tibco.gems.GemsMessageSenderTableModel;
import com.tibco.gems.GemsMessageTableModel;
import com.tibco.gems.GemsMonitorDestMessageTableModel;
import com.tibco.gems.GemsMonitorMessageTableModel;
import com.tibco.gems.GemsReqReplyMessageTableModel;
import com.tibco.gems.PopupTableHandler;
import com.tibco.tibjms.Tibjms;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;

public class PopupMsgTableHandler
extends PopupTableHandler {
    public AbstractAction openReqMsg = null;
    public AbstractAction openRepMsg = null;
    public AbstractAction openOrigMsg = null;
    public AbstractAction openMsg = null;
    public AbstractAction addProp = null;
    public AbstractAction selAll = null;
    public AbstractAction clrEvents = null;
    public AbstractAction origEvent = null;
    public GemsMessageTableModel m_model;

    public PopupMsgTableHandler(JTable tab, GemsMessageTableModel mod) {
        super(tab);
        this.m_model = mod;
    }

    @Override
    public JPopupMenu createPopup(Point loc) {
        JPopupMenu popup = super.createPopup(loc);
        if (this.m_model.m_showCheckbox) {
            if (this.selAll == null) {
                this.selAll = new TableSelectAllAction("Select All", null);
            }
            popup.insert(this.selAll, 1);
        }
        if (this.m_model.getColumnName(0).equals("RequestMessageID")) {
            if (this.openReqMsg == null) {
                this.openReqMsg = new OpenMsgAction("Open Request Message...", null);
            }
            if (this.openRepMsg == null) {
                this.openRepMsg = new OpenReplyMsgAction("Open Reply Message...", null);
            }
            popup.addSeparator();
            popup.add(this.openReqMsg);
            popup.add(this.openRepMsg);
        } else if (this.m_model instanceof GemsMonitorMessageTableModel) {
            if (this.openMsg == null) {
                this.openMsg = new OpenMsgAction("Open Monitor Event...", null);
            }
            popup.addSeparator();
            popup.add(this.openMsg);
        } else if (this.m_model instanceof GemsMonitorDestMessageTableModel) {
            if (this.openMsg == null) {
                this.openMsg = new OpenMsgAction("Open Monitor Event...", null);
            }
            popup.addSeparator();
            popup.add(this.openMsg);
            if (this.openOrigMsg == null) {
                this.openOrigMsg = new OpenOrigMsgAction("Open Original JMS Message...", null);
            }
            popup.add(this.openOrigMsg);
        } else if (this.m_model instanceof GemsEventMessageTableModel) {
            if (this.clrEvents == null) {
                this.clrEvents = new TableClearEventsAction("Clear Events", null);
            }
            if (this.origEvent == null) {
                this.origEvent = new OriginalEventAction("Open Original JMS Message...", null);
            }
            if (this.openMsg == null) {
                this.openMsg = new OpenMsgAction("Open Monitor Event...", null);
            }
            popup.addSeparator();
            popup.add(this.openMsg);
            popup.add(this.origEvent);
            popup.addSeparator();
            popup.add(this.clrEvents);
        } else if (!(this.m_model instanceof GemsMessageSenderTableModel)) {
            if (this.openMsg == null) {
                this.openMsg = new OpenMsgAction("Open Message...", null);
            }
            popup.addSeparator();
            popup.add(this.openMsg);
        }
        return popup;
    }

    public class TableClearEventsAction
    extends AbstractAction {
        public TableClearEventsAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Gems.getGems().clearCurrentEventsDisplay();
        }
    }

    public class TableSelectAllAction
    extends AbstractAction {
        public TableSelectAllAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PopupMsgTableHandler.this.m_model.selectAllRows();
        }
    }

    public class OpenReplyMsgAction
    extends AbstractAction {
        public OpenReplyMsgAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PopupMsgTableHandler.this.m_model instanceof GemsReqReplyMessageTableModel) {
                Message m = ((GemsReqReplyMessageTableModel)PopupMsgTableHandler.this.m_model).getReplyMessageAt(PopupMsgTableHandler.this.m_row);
                if (m != null) {
                    GemsMessageFrame f = new GemsMessageFrame(null, false, null, false, null, false);
                    f.populate(m);
                } else {
                    JOptionPane.showMessageDialog(null, "There is no reply Message to view!", "View Reply Message", 1);
                }
            }
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }

    public class OpenMsgAction
    extends AbstractAction {
        boolean m_isMonitor;

        public OpenMsgAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Message m;
            String c = PopupMsgTableHandler.this.m_model.getColumnName(0);
            boolean isMonitor = false;
            if (c != null && c.equals("MonitorEventID")) {
                isMonitor = true;
            }
            if ((m = PopupMsgTableHandler.this.m_model.getMessageAt(PopupMsgTableHandler.this.m_row)) != null) {
                GemsMessageFrame f = new GemsMessageFrame(null, false, null, false, null, isMonitor);
                f.populate(m);
            }
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }

    public class OpenOrigMsgAction
    extends AbstractAction {
        public OpenOrigMsgAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Message m = PopupMsgTableHandler.this.m_model.getMessageAt(PopupMsgTableHandler.this.m_row);
            if (m != null && m instanceof MapMessage) {
                try {
                    MapMessage mapMsg = (MapMessage)m;
                    if (mapMsg.itemExists("message_bytes")) {
                        Message msg = Tibjms.createFromBytes((byte[])mapMsg.getBytes("message_bytes"));
                        GemsMessageFrame f = new GemsMessageFrame(null, false, null, false, null, false);
                        f.populate(msg);
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            JOptionPane.showMessageDialog(null, "There is no original JMS message associated with this monitor message", "Error", 1);
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }

    public class OriginalEventAction
    extends AbstractAction {
        public OriginalEventAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Message m = PopupMsgTableHandler.this.m_model.getMessageAt(PopupMsgTableHandler.this.m_row);
            if (m != null && m instanceof MapMessage) {
                try {
                    MapMessage mapMsg = (MapMessage)m;
                    if (mapMsg.itemExists("message_bytes")) {
                        Message msg = Tibjms.createFromBytes((byte[])mapMsg.getBytes("message_bytes"));
                        GemsMessageFrame f = new GemsMessageFrame(null, false, null, false, null, false);
                        f.populate(msg);
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            JOptionPane.showMessageDialog(null, "There is no original JMS message associated with this monitor message", "Error", 1);
        }

        @Override
        public boolean isEnabled() {
            String v = PopupMsgTableHandler.this.m_model.getValueAt(PopupMsgTableHandler.this.m_row, 2).toString();
            return v.equals("message");
        }
    }
}

