/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsDetailsTableModel;
import com.tibco.gems.GemsSSDetails;
import com.tibco.gems.GemsSSNode;
import com.tibco.gems.PopupDetailsTableHandler;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.tree.DefaultMutableTreeNode;

public class PopupSSDetailsTableHandler
extends PopupDetailsTableHandler {
    public AbstractAction rss = null;
    public AbstractAction dss = null;
    public AbstractAction ess = null;
    public AbstractAction rdss = null;
    public AbstractAction tdss = null;
    public AbstractAction sss = null;

    public PopupSSDetailsTableHandler(JTable tab, GemsDetailsTableModel mod) {
        super(tab, mod);
    }

    @Override
    public JPopupMenu createPopup(Point loc) {
        JPopupMenu popup = super.createPopup(loc);
        if (this.m_model.getColumnName(0).equals("Identifier")) {
            if (this.rss == null) {
                this.rss = new SSRefreshAction("Refresh", null);
            }
            popup.addSeparator();
            popup.add(this.rss);
            GemsSSNode ssn = Gems.getGems().getSSConnectionNode();
            if (ssn.m_ver.equals("2.8") || ssn.m_ver.equals("2.9")) {
                if (this.rdss == null) {
                    this.rdss = new SSDetailsAction("Details", null);
                }
                popup.add(this.rdss);
            }
            popup.addSeparator();
            DefaultMutableTreeNode node = Gems.getGems().getSelectedNode();
            if (((String)node.getUserObject()).startsWith("Disabled") || ((String)node.getUserObject()).startsWith("Suspended")) {
                if (this.ess == null) {
                    this.ess = new SSEnableAction("Enable", null);
                }
                popup.add(this.ess);
            } else {
                if (this.dss == null) {
                    this.dss = new SSDisableAction("Disable", null);
                }
                popup.add(this.dss);
            }
            if ((ssn.m_ver.equals("2.8") || ssn.m_ver.equals("2.9")) && ((String)node.getUserObject()).startsWith("Active Recipes")) {
                if (this.sss == null) {
                    this.sss = new SSSuspendAction("Suspend", null);
                }
                popup.add(this.sss);
            }
        }
        return popup;
    }

    public class SSDetailsAction
    extends AbstractAction {
        public SSDetailsAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsConnectionNode cn = Gems.getGems().getConnectionNode();
            GemsSSNode ssn = Gems.getGems().getSSConnectionNode();
            DefaultMutableTreeNode node = Gems.getGems().getSelectedNode();
            JFrame m_frame = Gems.getGems().m_frame;
            if (cn != null) {
                String ssname = (String)PopupSSDetailsTableHandler.this.m_table.getModel().getValueAt(PopupSSDetailsTableHandler.this.m_row, 0);
                String intf = ((String)((DefaultMutableTreeNode)node.getParent()).getUserObject()).substring(5);
                String sstype = (String)PopupSSDetailsTableHandler.this.m_table.getModel().getValueAt(PopupSSDetailsTableHandler.this.m_row, 1);
                String state = "Disabled";
                if (((String)node.getUserObject()).startsWith("Active R")) {
                    sstype = "Recipe";
                    state = "Enabled";
                }
                if (((String)node.getUserObject()).startsWith("Active T")) {
                    sstype = "Trigger";
                    state = "Enabled";
                }
                new GemsSSDetails(m_frame, sstype, cn, ssn, ssname, intf, state);
            }
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }

    public class SSSuspendAction
    extends AbstractAction {
        public SSSuspendAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsConnectionNode cn = Gems.getGems().getConnectionNode();
            GemsSSNode ssn = Gems.getGems().getSSConnectionNode();
            DefaultMutableTreeNode node = Gems.getGems().getSelectedNode();
            if (cn != null) {
                String ssname = (String)PopupSSDetailsTableHandler.this.m_table.getModel().getValueAt(PopupSSDetailsTableHandler.this.m_row, 0);
                String intf = ((String)((DefaultMutableTreeNode)node.getParent()).getUserObject()).substring(5);
                String result = "";
                if (((String)node.getUserObject()).startsWith("Active R")) {
                    result = ssn.RunCommand("SUSPEND,RID=" + ssname.trim());
                }
                JOptionPane.showMessageDialog(Gems.getGems().m_frame, result, "Suspend Recipe", 1);
            }
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }

    public class SSDisableAction
    extends AbstractAction {
        public SSDisableAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsConnectionNode cn = Gems.getGems().getConnectionNode();
            GemsSSNode ssn = Gems.getGems().getSSConnectionNode();
            DefaultMutableTreeNode node = Gems.getGems().getSelectedNode();
            if (cn != null) {
                String ssname = (String)PopupSSDetailsTableHandler.this.m_table.getModel().getValueAt(PopupSSDetailsTableHandler.this.m_row, 0);
                String intf = ((String)((DefaultMutableTreeNode)node.getParent()).getUserObject()).substring(5);
                String result = "";
                if (((String)node.getUserObject()).startsWith("Active R")) {
                    result = ssn.RunCommand("DISABLE,RID=" + ssname.trim() + ",INTF=" + intf);
                }
                if (((String)node.getUserObject()).startsWith("Active T")) {
                    result = ssn.RunCommand("DISABLE,TID=" + ssname.trim() + ",INTF=" + intf);
                }
                JOptionPane.showMessageDialog(Gems.getGems().m_frame, result, "Disable SS Object", 1);
            }
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }

    public class SSEnableAction
    extends AbstractAction {
        public SSEnableAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsConnectionNode cn = Gems.getGems().getConnectionNode();
            GemsSSNode ssn = Gems.getGems().getSSConnectionNode();
            DefaultMutableTreeNode node = Gems.getGems().getSelectedNode();
            if (cn != null) {
                String ssname = (String)PopupSSDetailsTableHandler.this.m_table.getModel().getValueAt(PopupSSDetailsTableHandler.this.m_row, 0);
                String sstype = (String)PopupSSDetailsTableHandler.this.m_table.getModel().getValueAt(PopupSSDetailsTableHandler.this.m_row, 1);
                String intf = ((String)((DefaultMutableTreeNode)node.getParent()).getUserObject()).substring(5);
                String result = "";
                result = sstype.equals("Recipe") || node.getUserObject().equals("Suspended") ? ssn.RunCommand("ENABLE,RID=" + ssname.trim() + ",INTF=" + intf) : ssn.RunCommand("ENABLE,TID=" + ssname.trim() + ",INTF=" + intf);
                JOptionPane.showMessageDialog(Gems.getGems().m_frame, result, "Enable SS Object", 1);
            }
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }

    public class SSRefreshAction
    extends AbstractAction {
        public SSRefreshAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsConnectionNode cn = Gems.getGems().getConnectionNode();
            GemsSSNode ssn = Gems.getGems().getSSConnectionNode();
            DefaultMutableTreeNode node = Gems.getGems().getSelectedNode();
            if (cn != null) {
                String ssname = (String)PopupSSDetailsTableHandler.this.m_table.getModel().getValueAt(PopupSSDetailsTableHandler.this.m_row, 0);
                String sstype = (String)PopupSSDetailsTableHandler.this.m_table.getModel().getValueAt(PopupSSDetailsTableHandler.this.m_row, 1);
                String intf = ((String)((DefaultMutableTreeNode)node.getParent()).getUserObject()).substring(5);
                String result = "";
                if (((String)node.getUserObject()).startsWith("Active R")) {
                    result = ssn.RunCommand("REFRESH,RID=" + ssname.trim() + ",INTF=" + intf);
                }
                if (((String)node.getUserObject()).startsWith("Active T")) {
                    result = ssn.RunCommand("REFRESH,TID=" + ssname.trim() + ",INTF=" + intf);
                }
                if (((String)node.getUserObject()).startsWith("Disabled")) {
                    result = sstype.equals("Recipe") ? ssn.RunCommand("REFRESH,RID=" + ssname.trim() + ",INTF=" + intf) : ssn.RunCommand("REFRESH,TID=" + ssname.trim() + ",INTF=" + intf);
                }
                JOptionPane.showMessageDialog(Gems.getGems().m_frame, result, "Refresh SS Object", 1);
            }
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }
}

