/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.PopupHandler;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class PopupTableHandler
extends PopupHandler {
    public JTable m_table;
    public int m_row = 0;
    public int m_col = 0;
    public Object m_value = null;
    public AbstractAction copy = null;
    public AbstractAction save2csv = null;
    static File m_currentdir = null;

    public PopupTableHandler(JTable tab) {
        this.m_table = tab;
    }

    @Override
    public JPopupMenu createPopup(Point loc) {
        JPopupMenu popup = super.createPopup(loc);
        this.m_col = this.m_table.columnAtPoint(loc);
        this.m_row = this.m_table.rowAtPoint(loc);
        this.m_value = this.m_table.getModel().getValueAt(this.m_row, this.m_col);
        if (this.m_value == null) {
            this.m_value = new String();
        }
        if (this.copy == null) {
            this.copy = new TableCopyAction("Copy Cell", null);
        }
        if (this.save2csv == null) {
            this.save2csv = new TableSave2CSVAction("Save Table To CSV File...", null);
        }
        popup.add(this.copy);
        popup.addSeparator();
        popup.add(this.save2csv);
        return popup;
    }

    public class TableSave2CSVAction
    extends AbstractAction {
        public TableSave2CSVAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                TableModel model = PopupTableHandler.this.m_table.getModel();
                JFileChooser chooser = new JFileChooser(m_currentdir);
                chooser.setApproveButtonText("Save");
                chooser.setDialogTitle("Save Table To CSV File");
                int returnVal = chooser.showOpenDialog(PopupTableHandler.this.m_table);
                m_currentdir = chooser.getCurrentDirectory();
                if (returnVal == 0) {
                    File f = chooser.getSelectedFile();
                    f.createNewFile();
                    FileOutputStream fout = new FileOutputStream(f);
                    PrintWriter writer = new PrintWriter(fout);
                    int m = model.getColumnCount();
                    int n = model.getRowCount();
                    StringBuffer b = new StringBuffer();
                    for (int j = 0; j < m; ++j) {
                        TableColumn col = PopupTableHandler.this.m_table.getColumnModel().getColumn(j);
                        b.append(col.getHeaderValue());
                        if (j + 1 >= m) continue;
                        b.append(Gems.getGems().getCSVFileDelimiter());
                    }
                    if (b.charAt(0) == 'I' && b.charAt(1) == 'D') {
                        writer.print('\'');
                    }
                    writer.println(b.toString());
                    for (int i = 0; i < n; ++i) {
                        StringBuffer builder = new StringBuffer();
                        for (int j = 0; j < m; ++j) {
                            builder.append(model.getValueAt(i, j));
                            if (j + 1 >= m) continue;
                            builder.append(Gems.getGems().getCSVFileDelimiter());
                        }
                        writer.println(builder.toString());
                    }
                    writer.close();
                }
            }
            catch (IOException ie) {
                System.err.println("JavaIOException: " + ie.getMessage());
                return;
            }
        }

        @Override
        public boolean isEnabled() {
            return PopupTableHandler.this.m_table != null;
        }
    }

    public class TableCopyAction
    extends AbstractAction {
        public TableCopyAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StringSelection ss = new StringSelection(PopupTableHandler.this.m_value.toString());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, ss);
        }

        @Override
        public boolean isEnabled() {
            return PopupTableHandler.this.m_table != null;
        }
    }
}

