/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsIconNode;
import com.tibco.gems.GemsTreeModel;
import com.tibco.gems.GemsUtilities;
import com.tibco.gems.PopupHandler;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;

public class PopupTreeHandler
extends PopupHandler {
    public GemsTreeModel m_model;
    public int m_row = 0;
    public int m_col = 0;
    public AbstractAction consvr = null;
    public AbstractAction newsvr = null;
    public AbstractAction expall = null;
    public AbstractAction remsvr = null;
    public AbstractAction newfol = null;
    public AbstractAction remfol = null;
    public AbstractAction dissvr = null;
    public DefaultMutableTreeNode m_node;

    public PopupTreeHandler(GemsTreeModel mod) {
        this.m_model = mod;
    }

    @Override
    public JPopupMenu createPopup(Point loc) {
        JPopupMenu popup = super.createPopup(loc);
        this.m_node = this.m_model.getNodeAt(loc);
        if (this.consvr == null) {
            this.consvr = new ConnectServersAction("Connect Servers in Folder", null);
        }
        if (this.dissvr == null) {
            this.dissvr = new DisconnectServersAction("Disconnect Servers in Folder", null);
        }
        if (this.remfol == null) {
            this.remfol = new RemoveFolderAction("Remove Folder", null);
        }
        if (this.newfol == null) {
            this.newfol = new NewFolderAction("Add New Folder", null);
        }
        if (this.remsvr == null) {
            this.remsvr = new RemoveServerAction("Remove EMS Server", null);
        }
        if (this.newsvr == null) {
            this.newsvr = new NewServerAction("Add New EMS Server", null);
        }
        if (this.expall == null) {
            this.expall = new ExpandAllAction("Expand Folder", null);
        }
        popup.add(this.newsvr);
        popup.add(this.remsvr);
        popup.addSeparator();
        popup.add(this.newfol);
        popup.add(this.remfol);
        popup.add(this.expall);
        popup.addSeparator();
        popup.add(this.consvr);
        popup.add(this.dissvr);
        return popup;
    }

    public class ExpandAllAction
    extends AbstractAction {
        public ExpandAllAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PopupTreeHandler.this.m_model.expandAll(PopupTreeHandler.this.m_node);
        }

        @Override
        public boolean isEnabled() {
            return PopupTreeHandler.this.m_node != null && PopupTreeHandler.this.m_node.getChildCount() > 0 && PopupTreeHandler.this.m_node instanceof GemsIconNode && !(PopupTreeHandler.this.m_node instanceof GemsConnectionNode) && PopupTreeHandler.this.m_node.getAllowsChildren() && !PopupTreeHandler.this.m_node.getUserObject().equals("Topics") && !PopupTreeHandler.this.m_node.getUserObject().equals("Queues");
        }
    }

    public class RemoveServerAction
    extends AbstractAction {
        public RemoveServerAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PopupTreeHandler.this.m_model.removeConnectionNode(PopupTreeHandler.this.m_node);
            Gems.getGems().isDirty(true);
        }

        @Override
        public boolean isEnabled() {
            return PopupTreeHandler.this.m_node != null && PopupTreeHandler.this.m_node.getParent() != null && (PopupTreeHandler.this.m_node instanceof GemsConnectionNode || PopupTreeHandler.this.m_node.getParent() instanceof GemsConnectionNode);
        }
    }

    public class NewServerAction
    extends AbstractAction {
        public NewServerAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultMutableTreeNode n = PopupTreeHandler.this.m_node;
            if (n != null && n instanceof GemsIconNode && n.getAllowsChildren() && !n.getUserObject().equals("Topics") && !n.getUserObject().equals("Queues")) {
                if (n instanceof GemsConnectionNode) {
                    n = (DefaultMutableTreeNode)n.getParent();
                }
                PopupTreeHandler.this.m_model.newJMSConnection(n, "EMS Server");
            } else {
                PopupTreeHandler.this.m_model.newJMSConnection("EMS Server");
            }
            Gems.getGems().isDirty(true);
        }

        @Override
        public boolean isEnabled() {
            return PopupTreeHandler.this.m_node != null;
        }
    }

    public class RemoveFolderAction
    extends AbstractAction {
        public RemoveFolderAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PopupTreeHandler.this.m_model.removeFolder(PopupTreeHandler.this.m_node);
            Gems.getGems().isDirty(true);
        }

        @Override
        public boolean isEnabled() {
            return PopupTreeHandler.this.m_node != null && !PopupTreeHandler.this.m_node.isRoot() && PopupTreeHandler.this.m_node.getChildCount() == 0 && PopupTreeHandler.this.m_node instanceof GemsIconNode && !(PopupTreeHandler.this.m_node instanceof GemsConnectionNode) && PopupTreeHandler.this.m_node.getAllowsChildren() && !PopupTreeHandler.this.m_node.getUserObject().equals("Topics") && !PopupTreeHandler.this.m_node.getUserObject().equals("Queues");
        }
    }

    public class NewFolderAction
    extends AbstractAction {
        public NewFolderAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultMutableTreeNode n = PopupTreeHandler.this.m_node;
            if (n == null) {
                n = (DefaultMutableTreeNode)PopupTreeHandler.this.m_model.getRoot();
            }
            if (n instanceof GemsConnectionNode) {
                n = (DefaultMutableTreeNode)n.getParent();
            } else if (n.getParent() != null && n.getParent() instanceof GemsConnectionNode) {
                n = (DefaultMutableTreeNode)n.getParent().getParent();
            }
            if (n != null && n instanceof GemsIconNode && n.getAllowsChildren()) {
                String fn;
                JPanel messagePanel = new JPanel();
                messagePanel.setLayout(new BoxLayout(messagePanel, 1));
                messagePanel.add(new JLabel("Folder Name:"));
                JTextField juf = new JTextField(10);
                messagePanel.add(juf);
                int result = JOptionPane.showConfirmDialog(null, messagePanel, "Create Folder", 2);
                if (result == 0 && (fn = juf.getText()) != null && fn.length() > 0) {
                    PopupTreeHandler.this.m_model.newFolder(n, GemsUtilities.stripSpaces(fn));
                    Gems.getGems().isDirty(true);
                }
            }
        }

        @Override
        public boolean isEnabled() {
            return PopupTreeHandler.this.m_node != null;
        }
    }

    public class DisconnectServersAction
    extends AbstractAction {
        public DisconnectServersAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PopupTreeHandler.this.m_model.disconnectTreeNodes(PopupTreeHandler.this.m_node);
            PopupTreeHandler.this.m_model.selectNode(PopupTreeHandler.this.m_node);
            Gems.getGems().scheduleRepaint();
        }

        @Override
        public boolean isEnabled() {
            return PopupTreeHandler.this.m_node != null && PopupTreeHandler.this.m_node.getChildCount() > 0 && PopupTreeHandler.this.m_node instanceof GemsIconNode && !(PopupTreeHandler.this.m_node instanceof GemsConnectionNode) && PopupTreeHandler.this.m_node.getAllowsChildren() && !PopupTreeHandler.this.m_node.getUserObject().equals("Topics") && !PopupTreeHandler.this.m_node.getUserObject().equals("Queues");
        }
    }

    public class ConnectServersAction
    extends AbstractAction {
        public ConnectServersAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PopupTreeHandler.this.m_model.connectTreeNodes(PopupTreeHandler.this.m_node);
        }

        @Override
        public boolean isEnabled() {
            return PopupTreeHandler.this.m_node != null && PopupTreeHandler.this.m_node.getChildCount() > 0 && PopupTreeHandler.this.m_node instanceof GemsIconNode && !(PopupTreeHandler.this.m_node instanceof GemsConnectionNode) && PopupTreeHandler.this.m_node.getAllowsChildren() && !PopupTreeHandler.this.m_node.getUserObject().equals("Topics") && !PopupTreeHandler.this.m_node.getUserObject().equals("Queues");
        }
    }
}

