/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import java.awt.Color;

public class SSCellValue
implements Comparable {
    String m_datatype = "S";
    public String m_cellValue;
    public long m_cellValueLong;
    public String m_cellType;
    public String m_errorValue;
    public long m_warnLimit = 10L;
    public long m_errorLimit = 100L;

    public SSCellValue(long cellValue, String cellType, long warnLimit, long errorLimit) {
        this.m_cellValueLong = cellValue;
        this.m_datatype = "L";
        this.m_cellValue = String.valueOf(this.m_cellValueLong);
        this.m_cellType = cellType;
        this.m_warnLimit = warnLimit;
        this.m_errorLimit = errorLimit;
    }

    public SSCellValue(long cellValue, String cellType, long errorLimit) {
        this.m_cellValueLong = cellValue;
        this.m_datatype = "L";
        this.m_cellValue = String.valueOf(this.m_cellValueLong);
        this.m_cellType = cellType;
        this.m_errorLimit = errorLimit;
        this.m_warnLimit = errorLimit;
    }

    public SSCellValue(String cellValue, String cellType, String errorValue) {
        this.m_cellValue = cellValue;
        this.m_datatype = "S";
        this.m_cellType = cellType;
        this.m_errorValue = errorValue;
    }

    public SSCellValue(String cellValue, String cellType) {
        this.m_cellValue = cellValue;
        this.m_cellType = cellType;
    }

    public SSCellValue(String cellValue) {
        this.m_cellValue = cellValue;
        this.m_cellType = "";
    }

    public String toString() {
        return String.valueOf(this.m_cellValue);
    }

    public int compareTo(Object o) throws ClassCastException {
        SSCellValue mv = (SSCellValue)o;
        if (!this.m_cellValue.equals(mv.m_cellValue)) {
            return 1;
        }
        if (this.m_cellValue == mv.m_cellValue) {
            return 0;
        }
        return -1;
    }

    public Color CellColour() {
        if (this.m_cellType.equals("Head")) {
            return Color.lightGray;
        }
        if (this.m_cellType.equals("Error") && this.m_datatype.equals("L")) {
            if (this.m_cellValueLong >= this.m_errorLimit) {
                return Color.red;
            }
            if (this.m_cellValueLong >= this.m_warnLimit) {
                return Color.yellow;
            }
            return Color.green;
        }
        if (this.m_cellType.equals("Large") && this.m_datatype.equals("L")) {
            if (this.m_cellValueLong >= this.m_errorLimit) {
                return Color.yellow;
            }
            if (this.m_cellValueLong >= this.m_warnLimit) {
                return Color.cyan;
            }
        }
        if (this.m_cellType.equals("Status") && this.m_datatype.equals("S")) {
            if (this.m_cellValue.equals(this.m_errorValue)) {
                return Color.red;
            }
            return Color.green;
        }
        return Color.white;
    }
}

