/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems.chart;

import com.tibco.gems.chart.GemsChartFrame;
import com.tibco.gems.chart.GemsSubscriptionData;
import com.tibco.gems.chart.GemsTableListModelBase;
import com.tibco.gems.chart.GemsTableListPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;

public class GemsChartFieldList
extends JPanel
implements GemsTableListModelBase {
    private static final int[] m_columnSizes = new int[]{10, 125};
    private static final String[] m_colunnHeaders = new String[]{" ", "Fields"};
    private GemsSubscriptionData m_subscriptionData;
    private Vector m_listElements;
    private GemsTableListPanel m_tableListPanel;
    private GemsChartFrame m_chart;
    protected Timer m_timer = null;

    public void resetSelection() {
        this.m_tableListPanel.resetSelection();
    }

    @Override
    public Vector getDataVector() {
        return this.m_listElements;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int[] getColumnSizes() {
        return m_columnSizes;
    }

    @Override
    public String[] getColumnHeadings() {
        return m_colunnHeaders;
    }

    public void SelectChartableField(String f) {
        for (int j = 0; j < this.m_listElements.size(); ++j) {
            ChartableField chartablefield = (ChartableField)this.m_listElements.elementAt(j);
            if (!chartablefield.name.equals(f)) continue;
            this.SelectChartableField(j);
            return;
        }
    }

    public void SelectChartableField() {
        this.SelectChartableField(this.m_tableListPanel.getSelectedIndex());
    }

    public void SelectChartableField(int i) {
        if (i == -1) {
            return;
        }
        ChartableField chartablefield = (ChartableField)this.m_listElements.elementAt(i);
        boolean bl = chartablefield.show = !chartablefield.show;
        if (!chartablefield.show) {
            this.m_chart.removeChartableField(chartablefield.series);
            chartablefield.color = null;
        } else {
            if (chartablefield.series == -1) {
                if (this.m_timer == null) {
                    this.m_timer = new Timer(500, new RefreshColorsTimerAction());
                    this.m_timer.setInitialDelay(500);
                    this.m_timer.start();
                } else {
                    this.m_timer.restart();
                }
            }
            chartablefield.series = i;
            this.m_chart.showChartableField(chartablefield.series);
            chartablefield.color = this.m_chart.getSeriesColor(chartablefield.series);
        }
        this.m_tableListPanel.getTable().repaint();
    }

    public void refreshChartableFieldColors() {
        for (int j = 0; j < this.m_listElements.size(); ++j) {
            ChartableField chartablefield = (ChartableField)this.m_listElements.elementAt(j);
            if (!chartablefield.show || chartablefield.color != null) continue;
            chartablefield.color = this.m_chart.getSeriesColor(chartablefield.series);
            if (chartablefield.color != null || this.m_timer != null) {
                // empty if block
            }
            this.m_timer.restart();
        }
        this.m_tableListPanel.resizeAndRepaint();
    }

    public void setListData(Vector vector) {
        this.m_listElements = vector;
        this.m_tableListPanel.setListElements(vector);
        this.resetSelection();
    }

    @Override
    public Class getColumnClass(int i) {
        if (i == 0) {
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public Object getValueAt(int i, int j) {
        ChartableField chartablefield = (ChartableField)this.m_listElements.elementAt(i);
        if (chartablefield != null) {
            if (j == 0) {
                return new Boolean(chartablefield.show);
            }
            return chartablefield.name;
        }
        return "";
    }

    @Override
    public int getRowCount() {
        if (this.m_listElements == null) {
            return 0;
        }
        return this.m_listElements.size();
    }

    public Vector createChartableFields(Vector vector) {
        Vector<ChartableField> vector1 = new Vector<ChartableField>();
        for (int i = 0; i < vector.size(); ++i) {
            vector1.addElement(new ChartableField((String)vector.elementAt(i), i));
        }
        return vector1;
    }

    public GemsChartFieldList(GemsChartFrame chart, String s, Vector vector, GemsSubscriptionData subscriptiondata) {
        this.m_chart = chart;
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(180, 120));
        this.setBackground(Color.lightGray);
        this.m_subscriptionData = subscriptiondata;
        this.m_listElements = this.createChartableFields(vector);
        this.m_tableListPanel = new GemsTableListPanel(this);
        this.m_tableListPanel.add((Component)this.m_tableListPanel.constructListPanel(), "Center");
        JTable jtable = this.m_tableListPanel.getTable();
        jtable.setDefaultRenderer(String.class, new ChartableFieldRenderer());
        jtable.setShowGrid(false);
        jtable.getColumn("Fields").setPreferredWidth(140);
        JTableHeader jtableheader = jtable.getTableHeader();
        jtableheader.setReorderingAllowed(false);
        jtable.addMouseListener(new MouseListener());
        this.add("Center", this.m_tableListPanel);
    }

    private class MouseListener
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent mouseevent) {
            GemsChartFieldList.this.SelectChartableField();
        }

        MouseListener() {
        }
    }

    private class ChartableFieldRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jtable, Object obj, boolean flag, boolean flag1, int i, int j) {
            ChartableField chartablefield = (ChartableField)GemsChartFieldList.this.m_listElements.elementAt(i);
            if (chartablefield.show) {
                this.setBackground(chartablefield.color);
            } else {
                this.setBackground(Color.white);
            }
            if (j > 0) {
                flag = false;
                flag1 = false;
            }
            return super.getTableCellRendererComponent(jtable, obj, flag, flag1, i, j);
        }

        private ChartableFieldRenderer() {
        }
    }

    class RefreshColorsTimerAction
    implements ActionListener {
        RefreshColorsTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsChartFieldList.this.m_timer.stop();
            GemsChartFieldList.this.refreshChartableFieldColors();
        }
    }

    private class ChartableField {
        boolean show;
        int series;
        String name;
        Color color = null;

        ChartableField(String s, int i) {
            this.name = s;
            this.series = -1;
            this.show = false;
        }
    }
}

