/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems.chart;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.chart.GemsChartFieldList;
import com.tibco.gems.chart.GemsSubscriber;
import com.tibco.gems.chart.GemsSubscriptionData;
import com.tibco.gems.chart.GemsTableChartData;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Scanner;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.border.LineBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.event.RendererChangeListener;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class GemsChartFrame
extends JFrame {
    private long m_timeLimit;
    private JFrame m_frame;
    private JComponent m_tablePane;
    private JComponent m_chartPane;
    private String m_chartPaneTitle;
    private GemsSubscriber m_subscriber;
    private GemsSubscriptionData m_subscriptionData;
    private JComboBox m_retainDataCombo;
    private JTable m_table;
    private String m_title;
    private String m_title1;
    private JTabbedPane m_tabbedPane;
    private GemsConnectionNode m_cn = null;
    private JFreeChart m_chart;
    static File m_currentdir = null;
    private ChartPanel m_chartPanel = null;
    private Vector m_chartableFields;
    private Vector m_series = new Vector();
    private GemsChartFieldList m_fieldList = null;
    protected JCheckBoxMenuItem m_showLegends = null;
    protected JCheckBoxMenuItem m_showTitle = null;
    protected JCheckBoxMenuItem m_showShapes = null;
    protected JCheckBoxMenuItem m_autoRefresh = null;
    public static final SimpleDateFormat dateFormat = new SimpleDateFormat("EEE d MMM yyyy");
    protected Timer m_loadHistoryTimer = null;
    protected SimpleDateFormat dateFormatMillis = null;

    public boolean checkRetainDataPeriod() {
        Integer integer;
        Object obj = this.m_retainDataCombo.getSelectedItem();
        try {
            integer = new Integer(obj.toString());
        }
        catch (NumberFormatException numberformatexception) {
            JOptionPane.showMessageDialog(this.m_frame, "Input numeric data only !", "Warning", 2);
            return false;
        }
        if (integer <= 0) {
            JOptionPane.showMessageDialog(this.m_frame, "Input a value greater than 0 !", "Warning", 2);
            return false;
        }
        this.m_timeLimit = integer * 60 * 1000;
        return true;
    }

    public void clickedOKInOptionsEditor(long l) {
        if (this.m_subscriptionData.getTimeLimit() != l) {
            this.m_subscriptionData.setTimeLimit(l);
            this.updateRetentionPeriod();
        }
    }

    public void done() {
        if (this.m_loadHistoryTimer != null) {
            this.m_loadHistoryTimer.stop();
        }
        this.m_frame.dispose();
        if (this.m_subscriber != null) {
            this.m_subscriber.doneSelectedInTabbedPane(this);
        }
        if (this.m_cn != null) {
            this.m_cn.stopCharting();
        }
    }

    public void bringToFront() {
        this.m_frame.setAlwaysOnTop(true);
        this.m_frame.setAlwaysOnTop(false);
    }

    public void loadHistoricalFields(File file) {
        File m_file = file;
        try {
            Scanner scanner = new Scanner(m_file);
            Scanner dataScanner = null;
            int index = 0;
            Vector<String> fields = new Vector<String>();
            while (scanner.hasNextLine()) {
                dataScanner = new Scanner(scanner.nextLine());
                dataScanner.useDelimiter(Gems.getGems().getCSVFileDelimiter());
                boolean header = false;
                while (dataScanner.hasNext()) {
                    String f = dataScanner.next();
                    if (index == 0) {
                        if (f.equals("timestamp")) {
                            header = true;
                        }
                    } else if (header) {
                        fields.add(f);
                    }
                    ++index;
                }
                index = 0;
                if (!header) continue;
                this.m_chartableFields = fields;
                scanner.close();
                return;
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.m_frame, ex.toString(), "Error", 2);
        }
    }

    public void newDataAvailable(Date date, Hashtable hashtable) {
        if (hashtable != null && hashtable.size() > 0) {
            if (this.m_subscriptionData != null) {
                this.m_subscriptionData.addRow(date, hashtable);
            }
            for (int i = 0; i < this.m_series.size(); ++i) {
                Second now = new Second(date);
                ((TimeSeries)this.m_series.get(i)).addOrUpdate((RegularTimePeriod)now, (Number)hashtable.get((String)this.m_chartableFields.get(i)));
            }
        }
        this.m_fieldList.refreshChartableFieldColors();
    }

    public void updateRetentionPeriod() {
        for (int i = 0; i < this.m_series.size(); ++i) {
            ((TimeSeries)this.m_series.get(i)).setMaximumItemAge(this.m_timeLimit / 1000L);
        }
    }

    public JPanel constructListPanel() {
        JPanel jpanel = new JPanel();
        jpanel.setLayout(new BorderLayout());
        if (this.m_subscriber != null) {
            ComboActionListener m_comboListener = new ComboActionListener();
            this.m_retainDataCombo = new ComboKeyAction();
            this.m_retainDataCombo.setEditable(true);
            TitledBorder tb = new TitledBorder(LineBorder.createBlackLineBorder(), "Retention Period (min)");
            tb.setTitleColor(Color.black);
            this.m_retainDataCombo.setBorder(tb);
            this.m_retainDataCombo.setPreferredSize(new Dimension(50, 45));
            this.m_retainDataCombo.addItem("30");
            this.m_retainDataCombo.addItem("60");
            this.m_retainDataCombo.addItem("120");
            this.m_retainDataCombo.addItem("180");
            this.m_retainDataCombo.setSelectedIndex(0);
            this.m_retainDataCombo.addActionListener(m_comboListener);
            jpanel.add("North", this.m_retainDataCombo);
        }
        this.m_fieldList = new GemsChartFieldList(this, "Chartable Fields", this.m_chartableFields, this.m_subscriptionData);
        jpanel.add("Center", this.m_fieldList);
        return jpanel;
    }

    public JPanel createTablePane() {
        Vector vector = this.m_subscriptionData.getColumnHeaders();
        this.m_table = new GemsTableChartData((TableModel)this.m_subscriptionData, vector);
        this.m_table.setAutoCreateColumnsFromModel(false);
        this.m_table.setDefaultRenderer(Number.class, null);
        JPanel jpanel = ((GemsTableChartData)this.m_table).createView(new Dimension(750, 300));
        JPanel jpanel1 = new JPanel();
        jpanel1.setLayout(new BorderLayout());
        jpanel1.setBorder(new SoftBevelBorder(1));
        TitledBorder tb = new TitledBorder(LineBorder.createBlackLineBorder(), "Table");
        tb.setTitleColor(Color.black);
        jpanel1.setBorder(tb);
        jpanel1.add("Center", jpanel);
        return jpanel1;
    }

    public void setChartTitle(String title) {
        Font font = new Font("Tahoma", 1, 16);
        TextTitle subtitle = new TextTitle(title, font);
        this.m_chart.setTitle(subtitle);
    }

    public JPanel createChartPane(String title) {
        JPanel jpanel = new JPanel();
        jpanel.setLayout(new BorderLayout());
        TitledBorder tb = new TitledBorder(LineBorder.createBlackLineBorder(), title);
        tb.setTitleColor(Color.black);
        jpanel.setBorder(tb);
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        for (int i = 0; i < this.m_chartableFields.size(); ++i) {
            TimeSeries series = new TimeSeries((Comparable)((Object)((String)this.m_chartableFields.get(i))), Second.class);
            series.setMaximumItemAge(this.m_timeLimit / 1000L);
            dataset.addSeries(series);
            this.m_series.addElement(series);
        }
        this.m_chart = ChartFactory.createTimeSeriesChart((String)"", null, null, (XYDataset)dataset, (boolean)true, (boolean)false, (boolean)false);
        this.setChartTitle(this.m_title);
        XYPlot plot = this.m_chart.getXYPlot();
        ValueAxis axis = plot.getDomainAxis();
        axis = plot.getRangeAxis();
        plot.setRenderer((XYItemRenderer)new XYLineAndShapeRenderer());
        axis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        XYLineAndShapeRenderer r = (XYLineAndShapeRenderer)plot.getRenderer();
        for (int i = 0; i < this.m_series.size(); ++i) {
            r.setSeriesStroke(i, (Stroke)new BasicStroke(2.0f, 1, 1));
            r.setSeriesVisible(i, Boolean.valueOf(false));
            r.setSeriesShapesVisible(i, false);
        }
        this.m_chartPanel = new ChartPanel(this.m_chart);
        jpanel.add("West", this.constructListPanel());
        jpanel.add("Center", (Component)this.m_chartPanel);
        return jpanel;
    }

    public void removeChartableField(int index) {
        XYPlot plot = this.m_chart.getXYPlot();
        XYItemRenderer r = plot.getRenderer();
        r.setSeriesVisible(index, Boolean.valueOf(false));
    }

    public void showChartableField(int index) {
        XYPlot plot = this.m_chart.getXYPlot();
        XYItemRenderer r = plot.getRenderer();
        r.setSeriesVisible(index, Boolean.valueOf(true));
    }

    public Color getSeriesColor(int index) {
        XYPlot plot = this.m_chart.getXYPlot();
        XYItemRenderer r = plot.getRenderer();
        return (Color)r.getSeriesPaint(index);
    }

    public void createTabListener() {
        TabChangeAction m_tabChangeListener = new TabChangeAction();
        this.m_tabbedPane.addChangeListener(m_tabChangeListener);
    }

    public GemsChartFrame(String s, Vector vector, GemsSubscriber subscriber, GemsConnectionNode cn, File file) {
        super(s);
        Date date = new Date();
        if (subscriber == null && file != null) {
            this.loadHistoricalFields(file);
            if (this.m_chartableFields == null) {
                JOptionPane.showMessageDialog(this.m_frame, "Could not load chartable fields", "Error", 2);
                return;
            }
            String f = file.getName();
            int i = f.lastIndexOf(".");
            if (i > 0) {
                f = f.substring(0, i);
            }
            this.m_title1 = "Time Series Chart for " + f;
            this.m_title = "Loading chart data, please wait...";
            this.m_timeLimit = 86400000L;
        } else {
            this.m_title = "Time Series Chart for " + cn.getName() + " (" + dateFormat.format(date) + ")";
            this.m_cn = cn;
            this.m_chartableFields = vector;
            this.m_timeLimit = 1800000L;
        }
        this.m_frame = this;
        JMenuBar menuBar = this.constructMenuBar(s.startsWith("Today"));
        this.setJMenuBar(menuBar);
        this.m_table = null;
        this.m_retainDataCombo = null;
        this.m_chartPane = null;
        this.m_tablePane = null;
        this.m_subscriber = subscriber;
        if (subscriber != null) {
            this.m_subscriptionData = new GemsSubscriptionData(this.m_chartableFields);
            this.m_subscriptionData.setChart(this);
            this.m_subscriptionData.setTimeLimit(this.m_timeLimit);
        }
        this.m_frame.setIconImage(Gems.getGems().m_icon.getImage());
        this.m_frame.addWindowListener(new CloseAction());
        String t = "";
        int i = s.indexOf("Chart");
        if (i > 0) {
            t = s.substring(0, i + 5);
        }
        this.m_chartPane = this.createChartPane(t);
        if (subscriber != null) {
            this.m_tabbedPane = new JTabbedPane();
            this.m_tabbedPane.setFont(new Font("Dialog", 1, 12));
            this.m_tabbedPane.addTab("Chart View", this.m_chartPane);
            this.m_tablePane = this.createTablePane();
            this.m_tabbedPane.addTab("Tabular View", this.m_tablePane);
            this.createTabListener();
            this.m_tabbedPane.setSelectedIndex(0);
        }
        JPanel jpanel = new JPanel();
        jpanel.setLayout(new BorderLayout());
        jpanel.setBorder(new SoftBevelBorder(1));
        if (subscriber != null) {
            jpanel.add("Center", this.m_tabbedPane);
        } else {
            jpanel.add("Center", this.m_chartPane);
        }
        this.m_frame.getContentPane().add(jpanel);
        this.m_fieldList.SelectChartableField("inboundMessageRate");
        this.m_fieldList.SelectChartableField("outboundMessageRate");
        this.m_frame.setLocation(200, 100);
        this.m_frame.pack();
        this.m_frame.setVisible(true);
        if (subscriber == null && file != null) {
            this.m_loadHistoryTimer = new Timer(50, new LoadHistoricalChartTimerAction(file));
            this.m_loadHistoryTimer.setRepeats(false);
            this.m_loadHistoryTimer.start();
        }
    }

    private JMenuBar constructMenuBar(boolean showRefresh) {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menuBar.add(menu);
        JMenuItem menuItem = menu.add(new JMenuItem("Save Chart As..."));
        menuItem.addActionListener(new ChartSaveAction());
        if (this.m_title.startsWith("Time")) {
            menuItem = menu.add(new JMenuItem("Save Chart Data As CSV..."));
            menuItem.addActionListener(new TableSave2CSVAction());
        }
        menuItem = menu.add(new JMenuItem("Print Chart..."));
        menuItem.addActionListener(new ChartPrintAction());
        menuItem = menu.add(new JMenuItem("Exit"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemsChartFrame.this.done();
            }
        });
        menu = new JMenu("Edit");
        menu.setMnemonic(69);
        menuBar.add(menu);
        menuItem = menu.add(new JMenuItem("Copy Chart"));
        menuItem.addActionListener(new ChartCopyAction());
        menuItem = menu.add(new JMenuItem("Chart Properties..."));
        menuItem.addActionListener(new ChartPropertiesAction());
        menu = new JMenu("View");
        menu.setMnemonic(86);
        menuBar.add(menu);
        this.m_showLegends = new JCheckBoxMenuItem("Legends");
        this.m_showLegends.addActionListener(new ChartShowLegendsAction());
        this.m_showLegends.setSelected(true);
        this.m_showTitle = new JCheckBoxMenuItem("Chart Title");
        this.m_showTitle.setSelected(true);
        this.m_showTitle.addActionListener(new ChartShowTitleAction());
        menu.add(this.m_showTitle);
        this.m_showShapes = new JCheckBoxMenuItem("Series Shapes");
        this.m_showShapes.setSelected(false);
        this.m_showShapes.addActionListener(new ShowShapesAction());
        menu.add(this.m_showShapes);
        if (showRefresh) {
            menu.addSeparator();
            menuItem = menu.add(new JMenuItem("Refresh"));
            menuItem.addActionListener(new RefreshAction());
        }
        return menuBar;
    }

    private class CloseAction
    extends WindowAdapter {
        @Override
        public void windowClosing(WindowEvent windowevent) {
            GemsChartFrame.this.done();
        }

        CloseAction() {
        }
    }

    private class TabChangeAction
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent changeevent) {
            JTabbedPane jtabbedpane = (JTabbedPane)changeevent.getSource();
            int i = jtabbedpane.getSelectedIndex();
            Component component = jtabbedpane.getComponentAt(i);
        }

        TabChangeAction() {
        }
    }

    private class ComboKeyAction
    extends JComboBox {
        @Override
        public void processKeyEvent(KeyEvent keyevent) {
            if (keyevent.getKeyCode() == 10 && GemsChartFrame.this.checkRetainDataPeriod()) {
                GemsChartFrame.this.clickedOKInOptionsEditor(GemsChartFrame.this.m_timeLimit);
            }
        }

        ComboKeyAction() {
        }
    }

    private class ComboActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionevent) {
            if (GemsChartFrame.this.checkRetainDataPeriod()) {
                GemsChartFrame.this.clickedOKInOptionsEditor(GemsChartFrame.this.m_timeLimit);
            }
        }

        ComboActionListener() {
        }
    }

    private class RendererChanged
    implements RendererChangeListener {
        private RendererChanged() {
        }

        public void rendererChanged(RendererChangeEvent e) {
            if (e.getSeriesVisibilityChanged()) {
                GemsChartFrame.this.m_fieldList.refreshChartableFieldColors();
            }
        }
    }

    class ChartPropertiesAction
    implements ActionListener {
        ChartPropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsChartFrame.this.m_chartPanel.doEditChartProperties();
        }
    }

    class AutoRefreshAction
    implements ActionListener {
        AutoRefreshAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GemsChartFrame.this.m_autoRefresh.isSelected()) {
                if (GemsChartFrame.this.m_loadHistoryTimer != null) {
                    GemsChartFrame.this.m_loadHistoryTimer.setRepeats(true);
                    GemsChartFrame.this.m_loadHistoryTimer.restart();
                }
            } else if (GemsChartFrame.this.m_loadHistoryTimer != null) {
                GemsChartFrame.this.m_loadHistoryTimer.stop();
            }
        }
    }

    class RefreshAction
    implements ActionListener {
        RefreshAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GemsChartFrame.this.m_loadHistoryTimer != null) {
                GemsChartFrame.this.m_loadHistoryTimer.restart();
            }
        }
    }

    class ChartPrintAction
    implements ActionListener {
        ChartPrintAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsChartFrame.this.m_chartPanel.createChartPrintJob();
        }
    }

    class ChartCopyAction
    implements ActionListener {
        ChartCopyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsChartFrame.this.m_chartPanel.doCopy();
        }
    }

    class ChartSaveAction
    implements ActionListener {
        ChartSaveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                GemsChartFrame.this.m_chartPanel.doSaveAs();
            }
            catch (IOException ex) {
                System.err.println(ex.toString());
            }
        }
    }

    class ShowShapesAction
    implements ActionListener {
        ShowShapesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            XYPlot plot = GemsChartFrame.this.m_chart.getXYPlot();
            XYLineAndShapeRenderer r = (XYLineAndShapeRenderer)plot.getRenderer();
            for (int i = 0; i < GemsChartFrame.this.m_series.size(); ++i) {
                r.setSeriesShapesVisible(i, GemsChartFrame.this.m_showShapes.isSelected());
            }
        }
    }

    class ChartShowTitleAction
    implements ActionListener {
        ChartShowTitleAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GemsChartFrame.this.m_showTitle.isSelected()) {
                GemsChartFrame.this.m_chart.setTitle(GemsChartFrame.this.m_title);
            } else {
                GemsChartFrame.this.m_chart.setTitle((String)null);
            }
        }
    }

    class ChartShowLegendsAction
    implements ActionListener {
        ChartShowLegendsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            XYPlot plot = GemsChartFrame.this.m_chart.getXYPlot();
            XYItemRenderer r = plot.getRenderer();
            r.setBaseSeriesVisibleInLegend(GemsChartFrame.this.m_showLegends.isSelected());
        }
    }

    class LoadHistoricalChartTimerAction
    implements ActionListener {
        File m_file;

        public LoadHistoricalChartTimerAction(File file) {
            this.m_file = file;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsChartFrame.this.m_frame.setCursor(Cursor.getPredefinedCursor(3));
            try {
                Scanner scanner = new Scanner(this.m_file);
                Scanner dataScanner = null;
                int index = 0;
                ArrayList<String> fields = new ArrayList<String>();
                Hashtable<String, Long> data = new Hashtable<String, Long>();
                GemsChartFrame.this.dateFormatMillis = new SimpleDateFormat(Gems.getGems().getLogDateTimeFormat());
                while (scanner.hasNextLine()) {
                    dataScanner = new Scanner(scanner.nextLine());
                    dataScanner.useDelimiter(Gems.getGems().getCSVFileDelimiter());
                    Date timestamp = null;
                    boolean header = false;
                    data.clear();
                    while (dataScanner.hasNext()) {
                        String f = dataScanner.next();
                        if (index == 0) {
                            if (f.equals("timestamp")) {
                                header = true;
                                fields.clear();
                                fields.add(f);
                            } else {
                                timestamp = GemsChartFrame.this.dateFormatMillis.parse(f);
                                header = false;
                            }
                        } else if (header) {
                            if (GemsChartFrame.this.m_chartableFields == null || GemsChartFrame.this.m_chartableFields.contains(f)) {
                                fields.add(f);
                            } else {
                                System.out.println("loadHistoricalData: invalid field:" + f);
                                fields.add(new String("x"));
                            }
                        } else if (index < fields.size()) {
                            String field = (String)fields.get(index);
                            if (field != null && !field.equals("x")) {
                                data.put(field, Long.parseLong(f));
                            } else {
                                data.put(field, new Long(0L));
                            }
                        } else {
                            System.out.println("loadHistoricalData: invalid data:" + f + " index " + index);
                        }
                        ++index;
                    }
                    if (!header && index > 0) {
                        GemsChartFrame.this.newDataAvailable(timestamp, data);
                    }
                    if (header && GemsChartFrame.this.m_chartableFields == null) {
                        GemsChartFrame.this.m_chartableFields = new Vector(fields);
                    }
                    index = 0;
                }
                scanner.close();
            }
            catch (Exception ex) {
                GemsChartFrame.this.m_frame.setCursor(Cursor.getDefaultCursor());
                if (GemsChartFrame.this.m_loadHistoryTimer != null) {
                    GemsChartFrame.this.m_loadHistoryTimer.stop();
                }
                JOptionPane.showMessageDialog(GemsChartFrame.this.m_frame, ex.toString(), "Error", 2);
            }
            GemsChartFrame.this.m_frame.setCursor(Cursor.getDefaultCursor());
            GemsChartFrame.this.setChartTitle(GemsChartFrame.this.m_title1);
        }
    }

    class TableSave2CSVAction
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                TableModel model = GemsChartFrame.this.m_table.getModel();
                JFileChooser chooser = new JFileChooser(m_currentdir);
                chooser.setApproveButtonText("Save");
                chooser.setDialogTitle("Save Table To CSV File");
                int returnVal = chooser.showOpenDialog(GemsChartFrame.this.m_table);
                m_currentdir = chooser.getCurrentDirectory();
                if (returnVal == 0) {
                    File f = chooser.getSelectedFile();
                    f.createNewFile();
                    FileOutputStream fout = new FileOutputStream(f);
                    PrintWriter writer = new PrintWriter(fout);
                    int m = model.getColumnCount();
                    int n = model.getRowCount();
                    StringBuffer b = new StringBuffer();
                    for (int j = 0; j < m; ++j) {
                        TableColumn col = GemsChartFrame.this.m_table.getColumnModel().getColumn(j);
                        b.append(col.getHeaderValue());
                        if (j + 1 >= m) continue;
                        b.append(Gems.getGems().getCSVFileDelimiter());
                    }
                    if (b.charAt(0) == 'I' && b.charAt(1) == 'D') {
                        writer.print('\'');
                    }
                    writer.println(b.toString());
                    for (int i = 0; i < n; ++i) {
                        StringBuffer builder = new StringBuffer();
                        for (int j = 0; j < m; ++j) {
                            builder.append(model.getValueAt(i, j));
                            if (j + 1 >= m) continue;
                            builder.append(Gems.getGems().getCSVFileDelimiter());
                        }
                        writer.println(builder.toString());
                    }
                    writer.close();
                }
            }
            catch (IOException ie) {
                System.err.println("JavaIOException: " + ie.getMessage());
                return;
            }
        }
    }
}

