/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems.chart;

import com.tibco.gems.Gems;
import com.tibco.gems.chart.GemsChartFrame;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class GemsSubscriptionData
extends AbstractTableModel {
    private GemsChartFrame mm_chart;
    private long m_timeLimit = 300000L;
    public static final SimpleDateFormat m_timeFormat = new SimpleDateFormat("h:mm:ss");
    public static final SimpleDateFormat m_dateFormatMillis = new SimpleDateFormat(Gems.getGems().getLogDateTimeFormat());
    private Vector m_chartingColumns = null;
    private Vector m_subscriptionDataHeaders = null;
    private Vector[] m_subscriptionDataVector = null;

    public synchronized void purgeAllData() {
        for (int k = 0; k < this.m_subscriptionDataHeaders.size(); ++k) {
            this.m_subscriptionDataVector[k].removeAllElements();
        }
    }

    public synchronized void purgeOldData(long l) {
        Long long2;
        long l1 = l;
        Vector vector = this.m_subscriptionDataVector[0];
        int i = vector.size();
        if (i <= 1) {
            return;
        }
        if (l1 == 0L) {
            Long long1 = (Long)vector.elementAt(0);
            l1 = long1 - this.m_timeLimit;
        }
        for (int j = i - 1; j >= 0 && l1 > (long2 = (Long)vector.elementAt(0)) + this.m_timeLimit; --j) {
            for (int k = 0; k < this.m_subscriptionDataHeaders.size(); ++k) {
                this.m_subscriptionDataVector[k].removeElementAt(0);
            }
        }
    }

    public void setTimeLimit(long l) {
        this.m_timeLimit = l;
        this.purgeOldData(0L);
        this.setXAxisMinMax();
    }

    public long getTimeLimit() {
        return this.m_timeLimit;
    }

    public void setXAxisMinMax() {
    }

    public synchronized String[] getPointLabels() {
        Vector vector = this.m_subscriptionDataVector[0];
        if (vector == null) {
            return null;
        }
        int i = vector.size();
        String[] as = new String[i];
        for (int j = 0; j < i; ++j) {
            long l = (Long)vector.elementAt(j);
            Date date = new Date(l);
            as[j] = new String(m_timeFormat.format(date));
        }
        return as;
    }

    public String getSeriesLabel(int i) {
        return null;
    }

    public String getSeriesName(int i) {
        return null;
    }

    public String getName() {
        return "Real-time Data";
    }

    public void setChart(GemsChartFrame chart) {
        this.mm_chart = chart;
    }

    public synchronized Object getDataItem(int i, int j) {
        Vector vector = this.m_subscriptionDataVector[0];
        Vector vector1 = this.m_subscriptionDataVector[1];
        switch (i) {
            case 0: {
                return vector.elementAt(j);
            }
            case 1: {
                return vector1.elementAt(j);
            }
        }
        return null;
    }

    public synchronized int getDataInterpretation() {
        return 0;
    }

    @Override
    public boolean isCellEditable(int i, int j) {
        return false;
    }

    @Override
    public Object getValueAt(int i, int j) {
        int l;
        int k = this.getRowCount();
        int n = l = k != 0 ? k - 1 : k;
        if (j == 0) {
            long l1 = (Long)this.m_subscriptionDataVector[0].elementAt(l - i);
            Date formatteddate = new Date(l1);
            return m_dateFormatMillis.format(formatteddate).toString();
        }
        return this.m_subscriptionDataVector[j].elementAt(l - i);
    }

    @Override
    public int getColumnCount() {
        return this.m_subscriptionDataHeaders != null ? this.m_subscriptionDataHeaders.size() : 0;
    }

    @Override
    public String getColumnName(int i) {
        return (String)this.m_subscriptionDataHeaders.elementAt(i);
    }

    @Override
    public int getRowCount() {
        if (this.m_subscriptionDataVector == null || this.m_subscriptionDataVector[0] == null) {
            return 0;
        }
        return this.m_subscriptionDataVector[0].size();
    }

    public Vector getColumnHeaders() {
        return this.m_subscriptionDataHeaders;
    }

    public Vector getTimeSlices() {
        return this.m_subscriptionDataVector[0];
    }

    public synchronized Vector getDataPoints(String s) {
        for (int i = 0; i < this.m_subscriptionDataHeaders.size(); ++i) {
            if (!this.m_subscriptionDataHeaders.elementAt(i).equals(s)) continue;
            return this.m_subscriptionDataVector[i];
        }
        return new Vector();
    }

    public int getChartableFieldIndex(String s) {
        for (int i = 0; i < this.m_chartingColumns.size(); ++i) {
            int j = ((Long)this.m_chartingColumns.elementAt(i)).intValue();
            if (!this.m_subscriptionDataHeaders.elementAt(j).equals(s)) continue;
            return i;
        }
        return -1;
    }

    public void showChartableField(int i) {
        try {
            this.mm_chart.showChartableField(i);
        }
        catch (Exception e) {
            Gems.getGems();
            Gems.debug(e.toString());
        }
    }

    public void removeChartableField(String s, int i) {
        this.mm_chart.removeChartableField(i);
    }

    public synchronized void addRow(Date date, Hashtable hashtable) {
        this.purgeOldData(date.getTime());
        this.m_subscriptionDataVector[0].addElement(new Long(date.getTime()));
        for (int i = 1; i < this.m_subscriptionDataHeaders.size(); ++i) {
            String s = (String)this.m_subscriptionDataHeaders.elementAt(i);
            this.m_subscriptionDataVector[i].addElement(hashtable.get(s));
        }
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void setColumnIdentifiers(Vector vector) {
        this.m_subscriptionDataVector = new Vector[vector.size() + 1];
        this.m_subscriptionDataHeaders = new Vector(vector.size() + 1);
        this.m_subscriptionDataHeaders.insertElementAt("timestamp", 0);
        for (int i = 0; i < vector.size(); ++i) {
            this.m_subscriptionDataHeaders.addElement((String)vector.elementAt(i));
        }
        for (int j = 0; j < this.m_subscriptionDataHeaders.size(); ++j) {
            this.m_subscriptionDataVector[j] = new Vector(50);
        }
    }

    public GemsSubscriptionData(Vector vector) {
        this.setColumnIdentifiers(vector);
        this.m_chartingColumns = new Vector();
        m_timeFormat.setTimeZone(TimeZone.getDefault());
    }
}

