/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems.chart;

import com.tibco.gems.chart.GemsTableListModel;
import com.tibco.gems.chart.GemsTableListModelBase;
import com.tibco.gems.chart.GemsTableListTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;

public class GemsTableListPanel
extends JPanel {
    private ChangeListener m_changetListener;
    protected int iLastSelected = -1;
    protected JLabel m_headerLabel;
    protected Vector m_listElements;
    protected GemsTableListModelBase m_tableListModel;
    protected TableListControl m_tableListControl;

    public void onMouseClick() {
        this.iLastSelected = this.getSelectedIndex();
    }

    public void onDoubleClick() {
        this.iLastSelected = this.getSelectedIndex();
    }

    public void resizeAndRepaint() {
        if (this.m_tableListControl == null) {
            return;
        }
        this.m_tableListControl.resizeAndRepaint();
    }

    public void setAutoResizeMode(int i) {
        if (this.m_tableListControl == null) {
            return;
        }
        this.m_tableListControl.setAutoResizeMode(i);
    }

    public int getSelectedColumn() {
        return this.m_tableListControl.getSelectedColumn();
    }

    public int getSelectedIndex() {
        return this.m_tableListControl.getSelectedRow();
    }

    public void setSelectedIndex(int i) {
        this.iLastSelected = i;
        if (i == -1) {
            this.m_tableListControl.clearSelection();
            return;
        }
        this.m_tableListControl.setRowSelectionInterval(i, i);
    }

    public void addChangetListener(ChangeListener changelistener) {
        this.m_changetListener = changelistener;
    }

    public boolean onSelectionChanged(Object obj) {
        if (this.m_changetListener != null) {
            this.m_changetListener.stateChanged(new ChangeEvent(obj));
        }
        return true;
    }

    protected void editObject(Object obj, int i) {
        if (obj != null) {
            this.editObject(this.m_listElements.indexOf(obj), i);
        }
    }

    protected void editObject(int i, int j) {
        if (i != -1) {
            this.setSelectedIndex(i);
            if (j < 0) {
                j = 0;
            }
            this.getTable().editCellAt(this.getSelectedIndex(), j);
            this.m_tableListControl.editCellAt(i, 0);
        }
    }

    public void onBottom(int i) {
        this.stopEditing();
        if (i == this.m_listElements.size() - 1) {
            return;
        }
        Object obj = this.m_listElements.elementAt(i);
        this.m_listElements.removeElementAt(i);
        this.m_listElements.addElement(obj);
        this.setSelectedIndex(this.m_listElements.size() - 1);
    }

    public void onUp(int i) {
        if (i < 1 || i >= this.m_listElements.size()) {
            return;
        }
        Object obj = this.m_listElements.elementAt(i);
        this.m_listElements.removeElementAt(i);
        this.m_listElements.insertElementAt(obj, i - 1);
        this.setSelectedIndex(i - 1);
    }

    public void onDown(int i) {
        this.stopEditing();
        if (i == this.m_listElements.size() - 1) {
            return;
        }
        Object obj = this.m_listElements.elementAt(i);
        this.m_listElements.removeElementAt(i);
        this.m_listElements.insertElementAt(obj, i + 1);
        this.setSelectedIndex(i + 1);
    }

    public void onTop(int i) {
        this.stopEditing();
        if (i < 0 || i >= this.m_listElements.size()) {
            return;
        }
        Object obj = this.m_listElements.elementAt(i);
        this.m_listElements.removeElementAt(i);
        this.m_listElements.insertElementAt(obj, 0);
        this.setSelectedIndex(0);
    }

    public void stopEditing() {
        TableCellEditor tablecelleditor = this.m_tableListControl.getCellEditor();
        if (tablecelleditor != null) {
            tablecelleditor.stopCellEditing();
        }
        this.m_tableListControl.requestFocus();
    }

    public void addExtraButtons(JPanel jpanel) {
    }

    public JPanel constructHeaderPanel(String s) {
        JPanel jpanel = new JPanel();
        jpanel.setLayout(new BorderLayout());
        jpanel.setBackground(Color.lightGray);
        jpanel.setPreferredSize(new Dimension(250, 20));
        jpanel.setMinimumSize(new Dimension(250, 20));
        this.m_headerLabel = new JLabel(s, 2);
        jpanel.add("Center", this.m_headerLabel);
        return jpanel;
    }

    public JComponent constructListPanel(TableListControl tablelistcontrol) {
        this.m_tableListControl = tablelistcontrol;
        this.m_tableListControl.setBackground(Color.white);
        this.m_tableListControl.clearSelection();
        this.m_tableListControl.getSelectionModel().setSelectionMode(0);
        JScrollPane jscrollpane = new JScrollPane();
        jscrollpane.setBorder(new SoftBevelBorder(1));
        jscrollpane.getViewport().add(this.m_tableListControl);
        jscrollpane.setBackground(Color.white);
        return jscrollpane;
    }

    public JComponent constructListPanel() {
        return this.constructListPanel(new TableListControl(this.m_tableListModel));
    }

    public Object getSelectedObject() {
        int i = this.getSelectedIndex();
        if (i < 0) {
            return null;
        }
        return this.m_listElements.elementAt(i);
    }

    public void resetSelection() {
        if (this.m_listElements.size() != 0) {
            int i = this.getSelectedIndex();
            this.m_tableListControl.clearSelection();
            this.m_tableListControl.validate();
            this.m_tableListControl.repaint();
            if (i >= 0) {
                this.setSelectedIndex(i);
            }
        }
    }

    public Vector getListElements() {
        return this.m_listElements;
    }

    public Object elementAt(int i) {
        return this.m_listElements.elementAt(i);
    }

    public int indexOf(Object o) {
        return this.m_listElements.indexOf(o);
    }

    public void insertElementAt(Object obj, int i) {
        this.m_listElements.insertElementAt(obj, i);
    }

    public void addElement(Object obj) {
        this.m_listElements.addElement(obj);
        this.resizeAndRepaint();
    }

    public void setListElements(Vector vector) {
        this.m_listElements = vector;
        if (this.m_listElements.size() != 0) {
            this.iLastSelected = 0;
        }
        this.resizeAndRepaint();
    }

    public void setDescription(String s) {
        this.m_headerLabel.setText(s);
        this.doLayout();
        this.repaint();
    }

    public JTable getTable() {
        return this.m_tableListControl;
    }

    public void setPanels(JComponent jcomponent, JComponent jcomponent1) {
        if (jcomponent != null) {
            this.add((Component)jcomponent, "North");
        }
        this.add((Component)jcomponent1, "Center");
    }

    public void setTableModel(GemsTableListModelBase tablelistmodel) {
        this.m_tableListModel = tablelistmodel;
        this.m_listElements = this.m_tableListModel.getDataVector();
        if (this.m_listElements == null) {
            this.m_listElements = new Vector();
        }
    }

    public GemsTableListPanel(String s, String s1, GemsTableListModelBase tablelistmodel) {
        this(tablelistmodel);
        JPanel jpanel = this.constructHeaderPanel(s1);
        this.setPanels(jpanel, this.constructListPanel());
    }

    public GemsTableListPanel(String s, GemsTableListModelBase tablelistmodel) {
        this(null, s, tablelistmodel);
    }

    public GemsTableListPanel(GemsTableListModelBase tablelistmodel) {
        this();
        this.setTableModel(tablelistmodel);
    }

    public GemsTableListPanel() {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.lightGray);
    }

    private class TableListControl
    extends GemsTableListTable {
        boolean resizing;

        @Override
        protected void resizeAndRepaint() {
            this.resizing = true;
            super.resizeAndRepaint();
            this.resizing = false;
        }

        @Override
        public void onMouseClick() {
            GemsTableListPanel.this.onMouseClick();
        }

        @Override
        public void onDoubleClick() {
            GemsTableListPanel.this.onDoubleClick();
        }

        @Override
        public void onSelectionChanged() {
            if (this.resizing) {
                return;
            }
            GemsTableListPanel.this.iLastSelected = GemsTableListPanel.this.getSelectedIndex();
        }

        public TableListControl(GemsTableListModel tablelistmodel) {
            super(tablelistmodel);
            this.resizing = false;
        }

        public TableListControl(GemsTableListModelBase tablelistmodel) {
            super(tablelistmodel);
            this.resizing = false;
        }
    }
}

