/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems.chart;

import com.tibco.gems.chart.GemsTableListModel;
import com.tibco.gems.chart.GemsTableListModelBase;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;

public abstract class GemsTableListTable
extends JTable {
    final int m_nCols = 4;
    GemsTableListModel m_dataModel;

    public void setColumns() {
        String[] as = this.m_dataModel.getColumnHeadings();
        int[] ai = this.m_dataModel.getColumnSizes();
        int i = as.length <= this.getColumnCount() ? ai.length : this.getColumnCount();
        for (int j = 0; j < i; ++j) {
            TableColumn tablecolumn = new TableColumn(j);
            tablecolumn.setHeaderValue(as[j]);
            this.addColumn(tablecolumn);
        }
    }

    public GemsTableListTable(GemsTableListModel tablelistmodeladapter) {
        super(tablelistmodeladapter);
        this.m_dataModel = tablelistmodeladapter;
        this.m_dataModel.setTable(this);
        ListSelectionModel listselectionmodel = this.getSelectionModel();
        listselectionmodel.addListSelectionListener(new TableListTableSelectionListener());
        this.setRequestFocusEnabled(true);
        KeyStroke keystroke = KeyStroke.getKeyStroke(10, 0);
        this.registerKeyboardAction(new TableListTableAction(), keystroke, 2);
        this.addMouseListener(new TableListTableMouseListener());
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.setAutoResizeMode(0);
        this.m_dataModel.setColumnHeadings();
        this.m_dataModel.setColumnSizes();
    }

    public GemsTableListTable(GemsTableListModelBase tablelistmodel) {
        this(new GemsTableListModel(tablelistmodel));
    }

    public abstract void onMouseClick();

    public abstract void onDoubleClick();

    public abstract void onSelectionChanged();

    private class TableListTableMouseListener
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent mouseevent) {
            GemsTableListTable.this.onMouseClick();
            if (mouseevent.getClickCount() == 2) {
                GemsTableListTable.this.onDoubleClick();
            }
        }

        TableListTableMouseListener() {
        }
    }

    private class TableListTableAction
    extends AbstractAction {
        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent actionevent) {
            System.out.println("RowSelectionAction:actionPerformed - " + actionevent);
            GemsTableListTable.this.onDoubleClick();
        }

        TableListTableAction() {
        }
    }

    private class TableListTableSelectionListener
    implements ListSelectionListener {
        @Override
        public void valueChanged(ListSelectionEvent listselectionevent) {
            GemsTableListTable.this.onSelectionChanged();
        }

        TableListTableSelectionListener() {
        }
    }
}

